/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.attacheddata.ui.export;

import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IFlowElement;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataItemConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttachedDataRequestConfigurationExporter
implements IConfigurationExporter {
    public void exportConfiguration(IFlowElement flowElement, Element actionElement) {
        Element item;
        String uri = "http://eclipse.org/vtp/xml/configuration/attacheddata/request";
        NodeList bindingsList = flowElement.getConfiguration().getElementsByTagNameNS(uri, "bindings");
        Element attachedData = null;
        int i = 0;
        while (attachedData == null && i < bindingsList.getLength()) {
            Element bindings = (Element)bindingsList.item(i);
            NodeList itemList = bindings.getElementsByTagNameNS(uri, "attached-data-binding");
            int j = 0;
            while (attachedData == null && j < itemList.getLength()) {
                item = (Element)itemList.item(j);
                if ("default".equals(item.getAttribute("name"))) {
                    attachedData = item;
                }
                ++j;
            }
            ++i;
        }
        if (attachedData == null) {
            return;
        }
        MetaDataConfiguration config = new MetaDataConfiguration();
        NodeList itemList = attachedData.getElementsByTagNameNS(uri, "item");
        int count = 0;
        int i2 = 0;
        while (i2 < itemList.getLength()) {
            item = (Element)itemList.item(i2);
            NodeList entryList = item.getElementsByTagNameNS(uri, "entry");
            if (entryList.getLength() > 0) {
                MetaDataItemConfiguration[] metaDataItems = new MetaDataItemConfiguration[entryList.getLength()];
                int j = 0;
                while (j < entryList.getLength()) {
                    Element entry = (Element)entryList.item(j);
                    MetaDataItemConfiguration metaDataItem = new MetaDataItemConfiguration();
                    metaDataItem.setName(entry.getAttribute("name"));
                    System.out.println("Meta Data Entry Type: " + entry.getAttribute("type"));
                    if ("variable".equalsIgnoreCase(entry.getAttribute("type"))) {
                        metaDataItem.setVariableValue(entry.getAttribute("value"));
                    } else if ("expression".equalsIgnoreCase(entry.getAttribute("type"))) {
                        metaDataItem.setExpressionValue(entry.getAttribute("value"), "JavaScript");
                    } else if ("map".equalsIgnoreCase(entry.getAttribute("type"))) {
                        metaDataItem.setMapValue(entry.getAttribute("value"));
                    } else {
                        metaDataItem.setStaticValue(entry.getAttribute("value"));
                    }
                    metaDataItems[j] = metaDataItem;
                    ++j;
                }
                config.setItem(item.getAttribute("key"), metaDataItems);
                ++count;
            }
            ++i2;
        }
        if (count == 0) {
            return;
        }
        Element configElement = actionElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "interactions:meta-data");
        config.save(configElement);
        actionElement.appendChild(configElement);
    }

    public String getActionId(IFlowElement flowElement) {
        return "org.eclipse.vtp.framework.interactions.core.actions.meta-data-request";
    }

    public String getDefaultPath(IFlowElement flowElement) {
        return "Continue";
    }

    public String translatePath(IFlowElement flowElement, String uiPath) {
        return uiPath;
    }

    public String getTargetId(IFlowElement flowElement, Element afterTransitionElement) {
        return flowElement.getDefaultTargetId(afterTransitionElement);
    }

    public boolean isEntryPoint(IFlowElement flowElement) {
        return false;
    }
}

