/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.database.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.database.ui.properties.DatabaseQuerySettingsStructure;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseQueryInformationProvider
extends PrimitiveInformationProvider {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    DatabaseQuerySettingsStructure settings = null;

    public DatabaseQueryInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.database.connection", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList nl = configuration.getElementsByTagName("settings");
        if (nl.getLength() > 0) {
            this.getSettings().read((Element)nl.item(0));
        }
    }

    public void writeConfiguration(Element configuration) {
        Element settingsElement = configuration.getOwnerDocument().createElement("settings");
        configuration.appendChild(settingsElement);
        this.getSettings().write(settingsElement);
    }

    public DatabaseQuerySettingsStructure getSettings() {
        if (this.settings == null) {
            this.settings = new DatabaseQuerySettingsStructure(this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet());
        }
        return this.settings;
    }

    public void setSettings(DatabaseQuerySettingsStructure settings) {
        this.settings = settings;
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        ArrayList<Variable> ret = new ArrayList<Variable>();
        if (exitPoint.equals("Continue") && !this.settings.isTargetVariableExists() && !this.settings.getTargetVariableName().equals("")) {
            Variable v = new Variable(this.settings.getTargetVariableName(), this.settings.getTargetVariableType());
            VariableHelper.buildObjectFields((ObjectDefinition)v, (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet());
            ret.add(v);
        }
        return ret;
    }

    public boolean hasConnectors() {
        return true;
    }
}

