/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.database.ui.export;

import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IFlowElement;
import org.eclipse.vtp.framework.databases.configurations.DatabaseCriteriaConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseMappingConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseQueryConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseConfigurationExporter
implements IConfigurationExporter {
    public void exportConfiguration(IFlowElement flowElement, Element actionElement) {
        String uri = "http://www.eclipse.org/vtp/namespaces/config";
        DatabaseQueryConfiguration query = new DatabaseQueryConfiguration();
        Element settings = (Element)((Element)flowElement.getConfiguration().getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "settings").item(0);
        query.setDatabase(settings.getAttribute("db-name"));
        query.setTable(settings.getAttribute("db-table"));
        query.setResultName(settings.getAttribute("var-name"));
        query.setResultType(settings.getAttribute("var-type"));
        query.setResultSecured(Boolean.parseBoolean(settings.getAttribute("var-secured")));
        query.setResultArray("1".equals(settings.getAttribute("var-multi")));
        if (query.isResultArray()) {
            query.setResultLimit(Integer.parseInt(settings.getAttribute("db-result-limit")));
        }
        NodeList list = ((Element)settings.getElementsByTagNameNS(uri, "mappings").item(0)).getElementsByTagNameNS(uri, "mapping");
        int i = 0;
        while (i < list.getLength()) {
            Element mappingElement = (Element)list.item(i);
            DatabaseMappingConfiguration mapping = new DatabaseMappingConfiguration();
            mapping.setName(mappingElement.getAttribute("name"));
            if ("0".equals(mappingElement.getAttribute("type"))) {
                mapping.setType(2);
            } else if ("1".equals(mappingElement.getAttribute("type"))) {
                mapping.setType(1);
            } else {
                mapping.setType(0);
            }
            if (mapping.getType() != 0) {
                mapping.setValue(mappingElement.getAttribute("value"));
            }
            query.addMapping(mapping);
            ++i;
        }
        list = ((Element)settings.getElementsByTagNameNS(uri, "criteria").item(0)).getElementsByTagNameNS(uri, "criterium");
        i = 0;
        while (i < list.getLength()) {
            Element criteriumElement = (Element)list.item(i);
            DatabaseCriteriaConfiguration criteria = new DatabaseCriteriaConfiguration();
            criteria.setName(criteriumElement.getAttribute("name"));
            if ("0".equals(criteriumElement.getAttribute("type"))) {
                criteria.setType(2);
            } else if ("1".equals(criteriumElement.getAttribute("type"))) {
                criteria.setType(1);
            } else {
                criteria.setType(0);
            }
            if (criteria.getType() != 0) {
                if ("1".equals(criteriumElement.getAttribute("comp"))) {
                    criteria.setComparison(1);
                } else if ("2".equals(criteriumElement.getAttribute("comp"))) {
                    criteria.setComparison(2);
                } else if ("3".equals(criteriumElement.getAttribute("comp"))) {
                    criteria.setComparison(3);
                } else if ("4".equals(criteriumElement.getAttribute("comp"))) {
                    criteria.setComparison(4);
                } else if ("5".equals(criteriumElement.getAttribute("comp"))) {
                    criteria.setComparison(5);
                } else {
                    criteria.setComparison(0);
                }
                criteria.setValue(criteriumElement.getAttribute("value"));
            }
            query.addCriteria(criteria);
            ++i;
        }
        Element configElement = actionElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "database:query");
        query.save(configElement);
        actionElement.appendChild(configElement);
    }

    public String getActionId(IFlowElement flowElement) {
        return "org.eclipse.vtp.framework.databases.actions.database-query";
    }

    public String getDefaultPath(IFlowElement flowElement) {
        return "Continue";
    }

    public String translatePath(IFlowElement flowElement, String uiPath) {
        return uiPath;
    }

    public String getTargetId(IFlowElement flowElement, Element afterTransitionElement) {
        return flowElement.getDefaultTargetId(afterTransitionElement);
    }

    public boolean isEntryPoint(IFlowElement flowElement) {
        return false;
    }
}

