/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.database.ui.properties;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.core.dialogs.FramedDialog;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.IDatabase;
import org.eclipse.vtp.desktop.model.core.IDatabaseTable;
import org.eclipse.vtp.desktop.model.core.IDatabaseTableColumn;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.database.ui.DatabaseQueryInformationProvider;
import org.eclipse.vtp.modules.database.ui.properties.DatabaseQuerySettingsListener;
import org.eclipse.vtp.modules.database.ui.properties.DatabaseQuerySettingsStructure;

public class DatabaseQuerySearchCriteriaPropertiesPanel
extends DesignElementPropertiesPanel
implements DatabaseQuerySettingsListener {
    DatabaseQueryInformationProvider queryElement;
    DatabaseQuerySettingsStructure settings;
    TableViewer criteriaViewer;
    Button resultLimitButton;
    Text resultLimitField;
    String[] comparisonNames = new String[]{"Equals", "Not Equals", "Less Than", "Less Than or Equal", "Greater Than", "Greater Than or Equal"};
    ComboBoxCellEditor comparisonEditor;
    ValueCellEditor valueEditor;
    IBusinessObjectSet businessObjectSet = null;

    public DatabaseQuerySearchCriteriaPropertiesPanel(PrimitiveElement dqe, DatabaseQuerySettingsStructure settings) {
        super("Search Criteria", (IDesignElement)dqe);
        this.queryElement = (DatabaseQueryInformationProvider)dqe.getInformationProvider();
        this.settings = settings;
        this.businessObjectSet = dqe.getDesign().getDocument().getProject().getBusinessObjectSet();
    }

    public void createControls(Composite parent) {
        this.settings.addSettingsListener(this);
        GridLayout gl = new GridLayout(2, false);
        parent.setLayout((Layout)gl);
        Table criteriaTable = new Table(parent, 67620);
        criteriaTable.setHeaderVisible(true);
        TableColumn columnNameColumn = new TableColumn(criteriaTable, 0);
        columnNameColumn.setText("Column Name");
        columnNameColumn.setWidth(150);
        TableColumn comparisonColumn = new TableColumn(criteriaTable, 0);
        comparisonColumn.setText("Comparison");
        comparisonColumn.setWidth(80);
        TableColumn matchingValueColumn = new TableColumn(criteriaTable, 0);
        matchingValueColumn.setText("Matching Value");
        matchingValueColumn.setWidth(200);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        criteriaTable.setLayoutData((Object)gd);
        this.comparisonEditor = new ComboBoxCellEditor((Composite)criteriaTable, this.comparisonNames, 12);
        this.valueEditor = new ValueCellEditor((Composite)criteriaTable);
        this.criteriaViewer = new TableViewer(criteriaTable);
        this.criteriaViewer.setColumnProperties(new String[]{"Name", "Comparison", "Value"});
        this.criteriaViewer.setCellModifier((ICellModifier)new ValueCellModifier());
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = this.comparisonEditor;
        cellEditorArray[2] = this.valueEditor;
        this.criteriaViewer.setCellEditors(cellEditorArray);
        this.criteriaViewer.setContentProvider((IContentProvider)new CriteriaContentProvider());
        this.criteriaViewer.setLabelProvider((IBaseLabelProvider)new CriteriaLabelProvider());
        this.criteriaViewer.setInput((Object)this);
        this.resultLimitButton = new Button(parent, 32);
        this.resultLimitButton.setText("Limit results to this many records");
        this.resultLimitButton.setSelection(this.settings.resultLimit != -1);
        this.resultLimitButton.setEnabled(!this.settings.targetVariableType.isObject() && this.settings.targetVariableType.getPrimitiveType() == FieldType.Primitive.ARRAY);
        this.resultLimitButton.setBackground(parent.getBackground());
        this.resultLimitButton.setLayoutData((Object)new GridData());
        this.resultLimitButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseQuerySearchCriteriaPropertiesPanel.this.settings.resultLimit = DatabaseQuerySearchCriteriaPropertiesPanel.this.resultLimitButton.getSelection() ? Integer.parseInt(DatabaseQuerySearchCriteriaPropertiesPanel.this.resultLimitField.getText() == null ? "0" : (DatabaseQuerySearchCriteriaPropertiesPanel.this.resultLimitField.getText().equals("") ? "0" : DatabaseQuerySearchCriteriaPropertiesPanel.this.resultLimitField.getText())) : -1;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.resultLimitField = new Text(parent, 2048);
        if (this.settings.resultLimit != -1) {
            this.resultLimitField.setText(Integer.toString(this.settings.resultLimit));
        }
        this.resultLimitField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DatabaseQuerySearchCriteriaPropertiesPanel.this.settings.resultLimit = DatabaseQuerySearchCriteriaPropertiesPanel.this.resultLimitButton.getSelection() ? Integer.parseInt(DatabaseQuerySearchCriteriaPropertiesPanel.this.resultLimitField.getText() == null ? "0" : (DatabaseQuerySearchCriteriaPropertiesPanel.this.resultLimitField.getText().equals("") ? "0" : DatabaseQuerySearchCriteriaPropertiesPanel.this.resultLimitField.getText())) : -1;
            }
        });
        this.resultLimitField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char[] chars = e.text.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    if (!Character.isDigit(chars[i])) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        GridData rlfdata = new GridData();
        rlfdata.widthHint = 60;
        this.resultLimitField.setLayoutData((Object)rlfdata);
        int i = 0;
        while (i < this.settings.criteria.size()) {
            DatabaseQuerySettingsStructure.SelectionCriteria criteria = this.settings.criteria.get(i);
            criteriaTable.getItem(i).setChecked(criteria.comparison != -1);
            ++i;
        }
        criteriaTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    DatabaseQuerySettingsStructure.SelectionCriteria criteria = (DatabaseQuerySettingsStructure.SelectionCriteria)((TableItem)e.item).getData();
                    if (((TableItem)e.item).getChecked()) {
                        criteria.comparison = 0;
                    } else {
                        criteria.comparison = -1;
                        criteria.type = -1;
                        criteria.value = null;
                    }
                    DatabaseQuerySearchCriteriaPropertiesPanel.this.criteriaViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void save() {
    }

    public void cancel() {
    }

    @Override
    public void targetVariableChanged() {
        this.resultLimitButton.setEnabled(!this.settings.targetVariableType.isObject() && this.settings.targetVariableType.getPrimitiveType() == FieldType.Primitive.ARRAY);
        this.resultLimitButton.setSelection(false);
        this.resultLimitField.setText("");
    }

    @Override
    public void sourceDatabaseChanged() {
        this.settings.criteria.clear();
        if (this.settings.sourceDatabase != null && this.settings.sourceDatabaseTable != null && !this.settings.sourceDatabase.equals("") && !this.settings.sourceDatabaseTable.equals("")) {
            List databases = this.getElement().getDesign().getDocument().getProject().getDatabaseSet().getDatabases();
            int i = 0;
            while (i < databases.size()) {
                IDatabase database = (IDatabase)databases.get(i);
                if (database.getName().equals(this.settings.sourceDatabase)) {
                    List tables = database.getTables();
                    int t = 0;
                    while (t < tables.size()) {
                        IDatabaseTable table = (IDatabaseTable)tables.get(t);
                        if (table.getName().equals(this.settings.sourceDatabaseTable)) {
                            List columns = table.getColumns();
                            int c = 0;
                            while (c < columns.size()) {
                                IDatabaseTableColumn column = (IDatabaseTableColumn)columns.get(c);
                                List<DatabaseQuerySettingsStructure.SelectionCriteria> list = this.settings.criteria;
                                DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                                databaseQuerySettingsStructure.getClass();
                                list.add(new DatabaseQuerySettingsStructure.SelectionCriteria(databaseQuerySettingsStructure, column.getName()));
                                ++c;
                            }
                        }
                        ++t;
                    }
                }
                ++i;
            }
        }
        this.criteriaViewer.refresh();
    }

    @Override
    public void dataMappingChanged() {
    }

    @Override
    public void searchCriteriaChanged() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    public class CriteriaContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return DatabaseQuerySearchCriteriaPropertiesPanel.this.settings.criteria.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class CriteriaLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DatabaseQuerySettingsStructure.SelectionCriteria criteria = (DatabaseQuerySettingsStructure.SelectionCriteria)element;
            if (columnIndex == 0) {
                return criteria.columnName;
            }
            if (columnIndex == 1) {
                if (criteria.comparison != -1) {
                    return DatabaseQuerySearchCriteriaPropertiesPanel.this.comparisonNames[criteria.comparison];
                }
            } else if (columnIndex == 2) {
                return criteria.value;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ValueCellEditor
    extends DialogCellEditor {
        public ValueCellEditor(Composite parent) {
            super(parent);
        }

        protected void updateContents(Object value) {
            DatabaseQuerySettingsStructure.SelectionCriteria mapping = (DatabaseQuerySettingsStructure.SelectionCriteria)value;
            if (mapping != null) {
                if (mapping.type == -1) {
                    this.getDefaultLabel().setText("Not Used");
                } else if (mapping.type == 0) {
                    this.getDefaultLabel().setText(mapping.value);
                } else {
                    this.getDefaultLabel().setText(mapping.value);
                }
            } else {
                super.updateContents(value);
            }
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            ValueDialog vd = new ValueDialog(cellEditorWindow.getShell());
            vd.setValue((DatabaseQuerySettingsStructure.SelectionCriteria)this.getValue());
            vd.open();
            return this.getValue();
        }
    }

    public class ValueCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            DatabaseQuerySettingsStructure.SelectionCriteria criteria = (DatabaseQuerySettingsStructure.SelectionCriteria)element;
            return (property.equals("Value") || property.equals("Comparison")) && criteria.comparison != -1;
        }

        public Object getValue(Object element, String property) {
            DatabaseQuerySettingsStructure.SelectionCriteria criteria = (DatabaseQuerySettingsStructure.SelectionCriteria)element;
            if (property.equals("Comparison")) {
                return new Integer(criteria.comparison);
            }
            return element;
        }

        public void modify(Object element, String property, Object value) {
            DatabaseQuerySettingsStructure.SelectionCriteria criteria = (DatabaseQuerySettingsStructure.SelectionCriteria)((TableItem)element).getData();
            if (property.equals("Comparison")) {
                criteria.comparison = (Integer)value;
            }
            DatabaseQuerySearchCriteriaPropertiesPanel.this.criteriaViewer.refresh();
        }
    }

    public class ValueDialog
    extends FramedDialog {
        Button variableButton;
        TreeViewer variableViewer;
        Button staticValueButton;
        Text staticValueField;
        DatabaseQuerySettingsStructure.SelectionCriteria value;
        Color darkBlue;
        Color lightBlue;
        int originalType;
        String originalValue;
        List<Variable> vars;

        public ValueDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("Select a value");
            this.vars = DatabaseQuerySearchCriteriaPropertiesPanel.this.getElement().getDesign().getVariablesFor(DatabaseQuerySearchCriteriaPropertiesPanel.this.getElement());
        }

        public void setValue(DatabaseQuerySettingsStructure.SelectionCriteria value) {
            this.value = value;
            this.originalType = value.type;
            this.originalValue = value.value;
        }

        public void updateValue() {
            if (this.staticValueButton.getSelection()) {
                this.value.type = 0;
                this.value.value = this.staticValueField.getText();
            } else {
                this.value.type = 1;
                this.value.value = !this.variableViewer.getSelection().isEmpty() ? ((ObjectDefinition)((IStructuredSelection)this.variableViewer.getSelection()).getFirstElement()).getPath() : "";
            }
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            Button okButton = new Button(buttons, 8);
            okButton.setText("Ok");
            okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ValueDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 8);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ValueDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (Display.getCurrent().getDismissalAlignment() == 131072) {
                cancelButton.moveAbove((Control)okButton);
            }
            this.getShell().setDefaultButton(okButton);
        }

        public void okPressed() {
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.value.type = this.originalType;
            this.value.value = this.originalValue;
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ValueDialog.this.darkBlue.dispose();
                    ValueDialog.this.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            parent.setLayout((Layout)new GridLayout(2, false));
            Label preambleLabel = new Label(parent, 0);
            preambleLabel.setText("Select a value to match against");
            preambleLabel.setBackground(parent.getBackground());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            preambleLabel.setLayoutData((Object)gd);
            this.variableButton = new Button(parent, 16);
            this.variableButton.setText("This variable's current value");
            this.variableButton.setBackground(parent.getBackground());
            this.variableButton.setSelection(this.value.type == 1);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.variableButton.setLayoutData((Object)gd);
            Tree variableTree = new Tree(parent, 67588);
            gd = new GridData(1808);
            gd.horizontalIndent = 10;
            gd.horizontalSpan = 2;
            variableTree.setLayoutData((Object)gd);
            this.variableViewer = new TreeViewer(variableTree);
            this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
            this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
            this.variableViewer.setInput((Object)this);
            this.staticValueButton = new Button(parent, 16);
            this.staticValueButton.setText("The value I've entered");
            this.staticValueButton.setBackground(parent.getBackground());
            this.staticValueButton.setSelection(this.value.type <= 0);
            gd = new GridData();
            this.staticValueButton.setLayoutData((Object)gd);
            this.staticValueField = new Text(parent, 2052);
            gd = new GridData(768);
            if (this.value.type == 1) {
                int i = 0;
                while (i < this.vars.size()) {
                    Variable v = this.vars.get(i);
                    if (v.getName().equals(this.value.value)) {
                        this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                    } else if (this.value.value != null && this.value.value.startsWith(v.getName())) {
                        List objectFields = v.getFields();
                        int f = 0;
                        while (f < objectFields.size()) {
                            ObjectField of = (ObjectField)objectFields.get(f);
                            if (of.getPath().equals(this.value.value)) {
                                this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)of));
                            }
                            ++f;
                        }
                    }
                    ++i;
                }
            }
            this.staticValueField.setLayoutData((Object)gd);
            if (this.value.type == 0) {
                this.staticValueField.setText(this.value.value == null ? "" : this.value.value);
            }
            this.staticValueField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    ValueDialog.this.updateValue();
                }
            });
            this.staticValueButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ValueDialog.this.staticValueButton.getSelection()) {
                        ValueDialog.this.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.variableButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ValueDialog.this.variableButton.getSelection()) {
                        ValueDialog.this.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.variableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ValueDialog.this.updateValue();
                }
            });
        }

        public class VariableContentProvider
        implements ITreeContentProvider {
            public Object[] getElements(Object inputElement) {
                return ValueDialog.this.vars.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return ((ObjectDefinition)parentElement).getFields().toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof Variable) {
                    return null;
                }
                return ((ObjectField)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return true;
            }
        }

        public class VariableLabelProvider
        extends LabelProvider {
            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }

            public String getText(Object element) {
                return ((ObjectDefinition)element).getName();
            }
        }
    }
}

