/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.ISecurableElement;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.interactive.ui.ExtendedInteractiveEventManager;
import org.w3c.dom.Element;

public class PlayPromptInformationProvider
extends PrimitiveInformationProvider
implements ISecurableElement {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    boolean secured = false;

    public PlayPromptInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.disconnect.hangup", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        List<String> events = ExtendedInteractiveEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            this.connectorRecords.add(new ConnectorRecord((DesignElement)element, event, IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        }
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        this.secured = Boolean.parseBoolean(configuration.getAttribute("secured"));
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("secured", Boolean.toString(this.secured));
    }

    public boolean hasConnectors() {
        return true;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }
}

