/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.ISecurableElement;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.interactive.ui.ExtendedInteractiveEventManager;
import org.w3c.dom.Element;

public class QuestionInformationProvider
extends PrimitiveInformationProvider
implements ISecurableElement {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    String variableName = "";
    boolean secured = false;

    public QuestionInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.input.noinput", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.input.nomatch", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.disconnect.hangup", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        List<String> events = ExtendedInteractiveEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            this.connectorRecords.add(new ConnectorRecord((DesignElement)element, event, IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        }
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        this.variableName = configuration.getAttribute("variable-name");
        this.secured = Boolean.parseBoolean(configuration.getAttribute("secured"));
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("variable-name", this.variableName);
        configuration.setAttribute("secured", Boolean.toString(this.secured));
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String text) {
        this.variableName = text;
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        ArrayList<Variable> ret = new ArrayList<Variable>();
        if (exitPoint.equals("Continue") && !this.variableName.equals("")) {
            Variable var = new Variable(this.variableName, FieldType.STRING);
            ret.add(var);
        }
        return ret;
    }

    public boolean hasConnectors() {
        return true;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }
}

