/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.modules.interactive.ui.ExtendedInteractiveEventManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SubdialogInformationProvider
extends PrimitiveInformationProvider {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    private List<SubdialogInput> inputs = new ArrayList<SubdialogInput>();
    private List<SubdialogOutput> outputs = new ArrayList<SubdialogOutput>();
    private List<SubdialogParameter> urlParameters = new ArrayList<SubdialogParameter>();
    private String url = "";

    public SubdialogInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.subdialog", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.disconnect.hangup", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        List<String> events = ExtendedInteractiveEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            this.connectorRecords.add(new ConnectorRecord((DesignElement)element, event, IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        }
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("url", XMLUtilities.encodeAttribute((String)this.url));
        Element paramsElement = configuration.getOwnerDocument().createElement("params");
        configuration.appendChild(paramsElement);
        int i = 0;
        while (i < this.urlParameters.size()) {
            SubdialogParameter sp = this.urlParameters.get(i);
            Element paramElement = configuration.getOwnerDocument().createElement("param");
            paramsElement.appendChild(paramElement);
            paramElement.setAttribute("name", sp.name);
            paramElement.setAttribute("type", Integer.toString(sp.type));
            paramElement.setAttribute("value", sp.value);
            ++i;
        }
        Element inputsElement = configuration.getOwnerDocument().createElement("inputs");
        configuration.appendChild(inputsElement);
        int i2 = 0;
        while (i2 < this.inputs.size()) {
            SubdialogInput si = this.inputs.get(i2);
            Element inputElement = configuration.getOwnerDocument().createElement("input");
            inputsElement.appendChild(inputElement);
            inputElement.setAttribute("name", si.name);
            inputElement.setAttribute("type", Integer.toString(si.type));
            inputElement.setAttribute("value", si.value);
            ++i2;
        }
        Element outputsElement = configuration.getOwnerDocument().createElement("outputs");
        configuration.appendChild(outputsElement);
        int i3 = 0;
        while (i3 < this.outputs.size()) {
            SubdialogOutput so = this.outputs.get(i3);
            Element outputElement = configuration.getOwnerDocument().createElement("output");
            outputsElement.appendChild(outputElement);
            outputElement.setAttribute("name", so.varName);
            outputElement.setAttribute("value", so.valueName);
            ++i3;
        }
    }

    public void readConfiguration(Element configuration) {
        String varName;
        int inputType;
        int i;
        this.url = configuration.getAttribute("url");
        NodeList nl = configuration.getElementsByTagName("inputs");
        if (nl.getLength() > 0) {
            Element inputsElement = (Element)nl.item(0);
            nl = inputsElement.getElementsByTagName("input");
            i = 0;
            while (i < nl.getLength()) {
                Element inputElement = (Element)nl.item(i);
                String inputName = inputElement.getAttribute("name");
                inputType = Integer.parseInt(inputElement.getAttribute("type"));
                String inputValue = inputElement.getAttribute("value");
                this.inputs.add(new SubdialogInput(inputName, inputType, inputValue));
                ++i;
            }
        }
        if ((nl = configuration.getElementsByTagName("outputs")).getLength() > 0) {
            Element outputsElement = (Element)nl.item(0);
            nl = outputsElement.getElementsByTagName("output");
            i = 0;
            while (i < nl.getLength()) {
                Element outputElement = (Element)nl.item(i);
                varName = outputElement.getAttribute("name");
                String valueName = outputElement.getAttribute("value");
                this.outputs.add(new SubdialogOutput(varName, valueName));
                ++i;
            }
        }
        if ((nl = configuration.getElementsByTagName("params")).getLength() > 0) {
            Element paramsElement = (Element)nl.item(0);
            nl = paramsElement.getElementsByTagName("param");
            i = 0;
            while (i < nl.getLength()) {
                Element paramElement = (Element)nl.item(i);
                varName = paramElement.getAttribute("name");
                inputType = Integer.parseInt(paramElement.getAttribute("type"));
                String valueName = paramElement.getAttribute("value");
                this.urlParameters.add(new SubdialogParameter(varName, inputType, valueName));
                ++i;
            }
        }
    }

    public List<SubdialogInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<SubdialogInput> inputs) {
        this.inputs = inputs;
    }

    public List<SubdialogOutput> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<SubdialogOutput> outputs) {
        this.outputs = outputs;
    }

    public List<SubdialogParameter> getURLParameters() {
        return this.urlParameters;
    }

    public void setURLParameters(List<SubdialogParameter> urlParameters) {
        this.urlParameters = urlParameters;
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public boolean hasConnectors() {
        return true;
    }

    public class SubdialogInput {
        public String name = "";
        public int type = 0;
        public String value = "";

        public SubdialogInput(String name, int type, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }
    }

    public class SubdialogOutput {
        public String varName = "";
        public String valueName = "";

        public SubdialogOutput(String varName, String valueName) {
            this.varName = varName;
            this.valueName = valueName;
        }
    }

    public class SubdialogParameter {
        public String name = "";
        public int type = 0;
        public String value = "";

        public SubdialogParameter(String name, int type, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }
    }
}

