/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.modules.standard.ui.BeginInformationProvider;

public class ApplicationStartLanguagePropertyPanel
extends DesignElementPropertiesPanel {
    private Combo defaultLanguageCombo = null;
    private List<String> languages = null;

    public ApplicationStartLanguagePropertyPanel(String name, IDesignElement element) {
        super(name, element);
        IInteractiveWorkflowProject iwp = (IInteractiveWorkflowProject)this.getElement().getDesign().getDocument().getProject();
        this.languages = iwp.getSupportedLanguages("org.eclipse.vtp.framework.interactions.voice.interaction");
    }

    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setBackgroundMode(1);
        Composite nameComp = new Composite(parent, 0);
        nameComp.setBackground(parent.getBackground());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        nameComp.setLayoutData((Object)gd);
        nameComp.setLayout((Layout)new GridLayout(2, false));
        Label defaultLanguageLabel = new Label(nameComp, 0);
        defaultLanguageLabel.setText("Default Language");
        defaultLanguageLabel.setLayoutData((Object)new GridData());
        this.defaultLanguageCombo = new Combo(nameComp, 12);
        this.defaultLanguageCombo.setLayoutData((Object)new GridData(768));
        for (String lang : this.languages) {
            this.defaultLanguageCombo.add(lang);
        }
        String currentDefault = ((BeginInformationProvider)((PrimitiveElement)this.getElement()).getInformationProvider()).getDefaultLanguage();
        int i = 0;
        while (i < this.languages.size()) {
            if (this.languages.get(i).equals(currentDefault)) {
                this.defaultLanguageCombo.select(i);
                break;
            }
            ++i;
        }
        if (this.defaultLanguageCombo.getSelectionIndex() == -1) {
            this.defaultLanguageCombo.select(0);
        }
    }

    public void save() {
        ((BeginInformationProvider)((PrimitiveElement)this.getElement()).getInformationProvider()).setDefaultLanguage(this.languages.get(this.defaultLanguageCombo.getSelectionIndex()));
    }

    public void cancel() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
        Object object = values.get("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext");
        this.defaultLanguageCombo.setEnabled("org.eclipse.vtp.framework.interactions.voice.interaction".equals(((InteractionType)object).getId()));
    }

    public List<String> getApplicableContexts() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext");
        return ret;
    }

    public int getRanking() {
        return 10;
    }
}

