/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui.properties;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenContainer;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenManager;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ISecurableElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;

public class CombinedMediaPropertiesPanel
extends DesignElementPropertiesPanel
implements MediaConfigurationScreenContainer {
    StackLayout stackLayout = null;
    Map<String, MediaConfigurationScreen> screensByType;
    Composite comp = null;
    FormToolkit toolkit = null;
    Text nameField = null;
    Button secureElementButton = null;

    public CombinedMediaPropertiesPanel(String name, IDesignElement element) {
        super(name, element);
        PrimitiveElement pe = (PrimitiveElement)element;
        this.screensByType = MediaConfigurationScreenManager.getInstance().getIndexedMediaConfigurationScreens(pe.getSubTypeId(), (MediaConfigurationScreenContainer)this);
    }

    public void createControls(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setBackground(parent.getBackground());
        mainComp.setLayout((Layout)new GridLayout(2, false));
        this.toolkit = new FormToolkit(parent.getDisplay());
        Section contentSection = this.toolkit.createSection(mainComp, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("General");
        Label nameLabel = new Label(mainComp, 0);
        nameLabel.setBackground(mainComp.getBackground());
        nameLabel.setText("Name");
        nameLabel.setLayoutData((Object)new GridData());
        this.nameField = new Text(mainComp, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(768));
        PrimitiveElement pe = (PrimitiveElement)this.getElement();
        if (ISecurableElement.class.isAssignableFrom(pe.getInformationProvider().getClass())) {
            this.secureElementButton = new Button(mainComp, 32);
            this.secureElementButton.setText("This element may contain sensitive data and should be secured");
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.secureElementButton.setLayoutData((Object)gridData);
            this.secureElementButton.setSelection(((ISecurableElement)pe.getInformationProvider()).isSecured());
        }
        this.comp = new Composite(mainComp, 0);
        this.comp.setBackground(parent.getBackground());
        gridData = new GridData(1808);
        gridData.verticalIndent = 20;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        this.comp.setLayoutData((Object)gridData);
        this.stackLayout = new StackLayout();
        this.comp.setLayout((Layout)this.stackLayout);
        for (Map.Entry<String, MediaConfigurationScreen> entry : this.screensByType.entrySet()) {
            MediaConfigurationScreen mcs = entry.getValue();
            mcs.createControls(this.comp);
            this.stackLayout.topControl = mcs.getControl();
        }
        this.setControl((Control)mainComp);
    }

    public void save() {
        PrimitiveElement pe = (PrimitiveElement)this.getElement();
        this.getElement().setName(this.nameField.getText());
        if (ISecurableElement.class.isAssignableFrom(pe.getInformationProvider().getClass())) {
            ((ISecurableElement)pe.getInformationProvider()).setSecured(this.secureElementButton.getSelection());
        }
        for (Map.Entry<String, MediaConfigurationScreen> entry : this.screensByType.entrySet()) {
            MediaConfigurationScreen mcs = entry.getValue();
            mcs.save();
        }
    }

    public void cancel() {
        for (Map.Entry<String, MediaConfigurationScreen> entry : this.screensByType.entrySet()) {
            MediaConfigurationScreen mcs = entry.getValue();
            mcs.cancel();
        }
    }

    public void setConfigurationContext(Map<String, Object> values) {
        IBrand brand = (IBrand)values.get("org.eclipse.vtp.desktop.model.core.brandcontext");
        String language = (String)values.get("org.eclipse.vtp.desktop.model.interactive.core.languagecontext");
        Object object = values.get("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext");
        if (brand == null || language == null || object == null) {
            IWorkflowProject project = this.getElement().getDesign().getDocument().getProject();
            System.out.println("project: " + project);
            final IProject uproject = project.getUnderlyingProject();
            final Shell shell = this.getContainer().getParentShell();
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox mb = new MessageBox(shell, 289);
                    mb.setText("Configuration Problems");
                    mb.setMessage("The interaction and language configuration for this project is incomplete.  You will not be able edit the applications effectively until this is resolved.  Would you like to configure this now?");
                    if (mb.open() == 32) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PropertyDialog pd = PropertyDialog.createDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.vtp.desktop.projects.core.appproperties", (Object)uproject);
                                pd.open();
                            }
                        });
                    }
                    CombinedMediaPropertiesPanel.this.getContainer().cancelDialog();
                }
            });
            return;
        }
        String interactionType = ((InteractionType)object).getId();
        MediaConfigurationScreen mcs = this.screensByType.get(interactionType);
        if (mcs != null) {
            mcs.setBrand(brand);
            mcs.setLanguage(language);
            this.stackLayout.topControl = mcs.getControl();
            this.comp.layout(true, true);
        }
    }

    public List<String> getApplicableContexts() {
        List ret = super.getApplicableContexts();
        ret.add("org.eclipse.vtp.desktop.model.interactive.core.languagecontext");
        ret.add("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext");
        return ret;
    }

    public void cancelMediaConfiguration() {
        IWorkflowProject project = this.getElement().getDesign().getDocument().getProject();
        final IProject uproject = project.getUnderlyingProject();
        final Shell shell = this.getContainer().getParentShell();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox mb = new MessageBox(shell, 289);
                mb.setText("Configuration Problems");
                mb.setMessage("The selected language does not have an associated Voice project.  You will not be able to configure interactive modules until this is resolved.  Would you like to configure this now?");
                if (mb.open() == 32) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PropertyDialog pd = PropertyDialog.createDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.vtp.desktop.projects.core.appproperties", (Object)uproject);
                            pd.open();
                        }
                    });
                    CombinedMediaPropertiesPanel.this.getContainer().cancelDialog();
                }
            }
        });
    }

    public IDesignElement getDesignElement() {
        return this.getElement();
    }
}

