/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.core.dialogs.FramedDialog;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.framework.util.QuickSort;
import org.eclipse.vtp.framework.util.VariableNameValidator;
import org.eclipse.vtp.modules.interactive.ui.SubdialogInformationProvider;

public class SubdialogPropertiesPanel
extends DesignElementPropertiesPanel {
    List<SubdialogInformationProvider.SubdialogParameter> urlParameters = new ArrayList<SubdialogInformationProvider.SubdialogParameter>();
    List<SubdialogInformationProvider.SubdialogInput> inputs = new ArrayList<SubdialogInformationProvider.SubdialogInput>();
    List<SubdialogInformationProvider.SubdialogOutput> outputs = new ArrayList<SubdialogInformationProvider.SubdialogOutput>();
    Text nameField = null;
    Label nameLabel = null;
    Text urlField = null;
    TableViewer inputTable = null;
    TableViewer outputTable = null;
    TableViewer urlParamTable = null;
    private SubdialogInformationProvider info = null;

    public SubdialogPropertiesPanel(String name, IDesignElement subdialogElement) {
        super(name, subdialogElement);
        PrimitiveElement pe = (PrimitiveElement)subdialogElement;
        this.info = (SubdialogInformationProvider)pe.getInformationProvider();
        this.inputs.addAll(this.info.getInputs());
        this.outputs.addAll(this.info.getOutputs());
        this.urlParameters.addAll(this.info.getURLParameters());
    }

    public void createControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        container.setLayout((Layout)new GridLayout(2, false));
        this.nameLabel = new Label(container, 0);
        this.nameLabel.setText("Name");
        this.nameLabel.setBackground(container.getBackground());
        this.nameLabel.setLayoutData((Object)new GridData());
        this.nameField = new Text(container, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(768));
        this.nameField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String currentName = String.valueOf(SubdialogPropertiesPanel.this.nameField.getText().substring(0, e.start)) + e.text + SubdialogPropertiesPanel.this.nameField.getText(e.end, SubdialogPropertiesPanel.this.nameField.getText().length() - 1);
                if (VariableNameValidator.followsVtpNamingRules((String)currentName).booleanValue()) {
                    SubdialogPropertiesPanel.this.nameLabel.setForeground(SubdialogPropertiesPanel.this.nameLabel.getDisplay().getSystemColor(2));
                    SubdialogPropertiesPanel.this.nameField.setForeground(SubdialogPropertiesPanel.this.nameField.getDisplay().getSystemColor(2));
                    SubdialogPropertiesPanel.this.getContainer().setCanFinish(true);
                } else {
                    SubdialogPropertiesPanel.this.nameLabel.setForeground(SubdialogPropertiesPanel.this.nameLabel.getDisplay().getSystemColor(3));
                    SubdialogPropertiesPanel.this.nameField.setForeground(SubdialogPropertiesPanel.this.nameField.getDisplay().getSystemColor(3));
                    SubdialogPropertiesPanel.this.getContainer().setCanFinish(false);
                }
            }
        });
        if (VariableNameValidator.followsVtpNamingRules((String)this.nameField.getText()).booleanValue()) {
            this.nameLabel.setForeground(this.nameLabel.getDisplay().getSystemColor(2));
            this.nameField.setForeground(this.nameField.getDisplay().getSystemColor(2));
            this.getContainer().setCanFinish(true);
        } else {
            this.nameLabel.setForeground(this.nameLabel.getDisplay().getSystemColor(3));
            this.nameField.setForeground(this.nameField.getDisplay().getSystemColor(3));
            this.getContainer().setCanFinish(false);
        }
        Label urlLabel = new Label(container, 0);
        urlLabel.setText("URL");
        urlLabel.setBackground(container.getBackground());
        urlLabel.setLayoutData((Object)new GridData());
        this.urlField = new Text(container, 2052);
        this.urlField.setText(this.info.getURL());
        this.urlField.setLayoutData((Object)new GridData(768));
        Group paramsGroup = new Group(container, 0);
        paramsGroup.setBackground(container.getBackground());
        paramsGroup.setText("URL Settings");
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        paramsGroup.setLayoutData((Object)gd);
        paramsGroup.setLayout((Layout)new GridLayout(2, true));
        this.urlParamTable = new TableViewer((Composite)paramsGroup, 68100);
        this.urlParamTable.getTable().setHeaderVisible(true);
        this.urlParamTable.getTable().setLinesVisible(true);
        TableColumn paramNameColumn = new TableColumn(this.urlParamTable.getTable(), 0);
        paramNameColumn.setText("Name");
        paramNameColumn.setWidth(150);
        TableColumn paramValueColumn = new TableColumn(this.urlParamTable.getTable(), 0);
        paramValueColumn.setText("Value");
        paramValueColumn.setWidth(150);
        this.urlParamTable.setContentProvider((IContentProvider)new ParamTableContentProvider());
        this.urlParamTable.setLabelProvider((IBaseLabelProvider)new ParamTableLabelProvider());
        this.urlParamTable.setInput((Object)this);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 90;
        gd.widthHint = 300;
        this.urlParamTable.getTable().setLayoutData((Object)gd);
        this.urlParamTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!SubdialogPropertiesPanel.this.urlParamTable.getSelection().isEmpty()) {
                    ParameterValueDialog vd = new ParameterValueDialog(Display.getCurrent().getActiveShell());
                    SubdialogInformationProvider.SubdialogParameter si = (SubdialogInformationProvider.SubdialogParameter)((IStructuredSelection)SubdialogPropertiesPanel.this.urlParamTable.getSelection()).getFirstElement();
                    vd.setValue(si);
                    if (vd.open() == 32) {
                        SubdialogPropertiesPanel.this.urlParamTable.refresh();
                    }
                }
            }
        });
        this.urlParamTable.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && !SubdialogPropertiesPanel.this.urlParamTable.getSelection().isEmpty()) {
                    SubdialogInformationProvider.SubdialogParameter si = (SubdialogInformationProvider.SubdialogParameter)((IStructuredSelection)SubdialogPropertiesPanel.this.urlParamTable.getSelection()).getFirstElement();
                    SubdialogPropertiesPanel.this.urlParameters.remove(si);
                    SubdialogPropertiesPanel.this.urlParamTable.refresh();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Button addButton = new Button((Composite)paramsGroup, 8);
        addButton.setText("Add Parameter");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ParameterValueDialog vd = new ParameterValueDialog(Display.getCurrent().getActiveShell());
                SubdialogInformationProvider subdialogInformationProvider = SubdialogPropertiesPanel.this.info;
                ((Object)((Object)subdialogInformationProvider)).getClass();
                SubdialogInformationProvider.SubdialogParameter si = subdialogInformationProvider.new SubdialogInformationProvider.SubdialogParameter("", 0, "");
                vd.setValue(si);
                if (vd.open() == 32) {
                    SubdialogPropertiesPanel.this.urlParameters.add(si);
                    SubdialogPropertiesPanel.this.urlParamTable.refresh();
                }
            }
        });
        Button deleteButton = new Button((Composite)paramsGroup, 8);
        deleteButton.setText("Delete Parameter");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!SubdialogPropertiesPanel.this.urlParamTable.getSelection().isEmpty()) {
                    SubdialogInformationProvider.SubdialogParameter si = (SubdialogInformationProvider.SubdialogParameter)((IStructuredSelection)SubdialogPropertiesPanel.this.urlParamTable.getSelection()).getFirstElement();
                    SubdialogPropertiesPanel.this.urlParameters.remove(si);
                    SubdialogPropertiesPanel.this.urlParamTable.refresh();
                }
            }
        });
        gd = new GridData();
        deleteButton.setLayoutData((Object)gd);
        Group inputsGroup = new Group(container, 0);
        inputsGroup.setBackground(container.getBackground());
        inputsGroup.setText("Inputs");
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        inputsGroup.setLayoutData((Object)gd);
        inputsGroup.setLayout((Layout)new GridLayout(2, true));
        this.inputTable = new TableViewer((Composite)inputsGroup, 68100);
        this.inputTable.getTable().setHeaderVisible(true);
        this.inputTable.getTable().setLinesVisible(true);
        TableColumn inputNameColumn = new TableColumn(this.inputTable.getTable(), 0);
        inputNameColumn.setText("Name");
        inputNameColumn.setWidth(150);
        TableColumn inputValueColumn = new TableColumn(this.inputTable.getTable(), 0);
        inputValueColumn.setText("Value");
        inputValueColumn.setWidth(150);
        this.inputTable.setContentProvider((IContentProvider)new InputTableContentProvider());
        this.inputTable.setLabelProvider((IBaseLabelProvider)new InputTableLabelProvider());
        this.inputTable.setInput((Object)this);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 90;
        gd.widthHint = 300;
        this.inputTable.getTable().setLayoutData((Object)gd);
        this.inputTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!SubdialogPropertiesPanel.this.inputTable.getSelection().isEmpty()) {
                    InputValueDialog vd = new InputValueDialog(Display.getCurrent().getActiveShell());
                    SubdialogInformationProvider.SubdialogInput si = (SubdialogInformationProvider.SubdialogInput)((IStructuredSelection)SubdialogPropertiesPanel.this.inputTable.getSelection()).getFirstElement();
                    vd.setValue(si);
                    if (vd.open() == 32) {
                        SubdialogPropertiesPanel.this.inputTable.refresh();
                    }
                }
            }
        });
        this.inputTable.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && !SubdialogPropertiesPanel.this.inputTable.getSelection().isEmpty()) {
                    SubdialogInformationProvider.SubdialogInput si = (SubdialogInformationProvider.SubdialogInput)((IStructuredSelection)SubdialogPropertiesPanel.this.inputTable.getSelection()).getFirstElement();
                    SubdialogPropertiesPanel.this.inputs.remove(si);
                    SubdialogPropertiesPanel.this.inputTable.refresh();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        addButton = new Button((Composite)inputsGroup, 8);
        addButton.setText("Add Input");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                InputValueDialog vd = new InputValueDialog(Display.getCurrent().getActiveShell());
                SubdialogInformationProvider subdialogInformationProvider = SubdialogPropertiesPanel.this.info;
                ((Object)((Object)subdialogInformationProvider)).getClass();
                SubdialogInformationProvider.SubdialogInput si = subdialogInformationProvider.new SubdialogInformationProvider.SubdialogInput("", 0, "");
                vd.setValue(si);
                if (vd.open() == 32) {
                    SubdialogPropertiesPanel.this.inputs.add(si);
                    SubdialogPropertiesPanel.this.inputTable.refresh();
                }
            }
        });
        deleteButton = new Button((Composite)inputsGroup, 8);
        deleteButton.setText("Delete Input");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!SubdialogPropertiesPanel.this.inputTable.getSelection().isEmpty()) {
                    SubdialogInformationProvider.SubdialogInput si = (SubdialogInformationProvider.SubdialogInput)((IStructuredSelection)SubdialogPropertiesPanel.this.inputTable.getSelection()).getFirstElement();
                    SubdialogPropertiesPanel.this.inputs.remove(si);
                    SubdialogPropertiesPanel.this.inputTable.refresh();
                }
            }
        });
        gd = new GridData();
        deleteButton.setLayoutData((Object)gd);
        Group outputsGroup = new Group(container, 0);
        outputsGroup.setBackground(container.getBackground());
        outputsGroup.setText("Outputs");
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        outputsGroup.setLayoutData((Object)gd);
        outputsGroup.setLayout((Layout)new GridLayout(2, true));
        this.outputTable = new TableViewer((Composite)outputsGroup, 68100);
        this.outputTable.getTable().setHeaderVisible(true);
        this.outputTable.getTable().setLinesVisible(true);
        TableColumn outputNameColumn = new TableColumn(this.outputTable.getTable(), 0);
        outputNameColumn.setText("Name");
        outputNameColumn.setWidth(150);
        TableColumn outputValueColumn = new TableColumn(this.outputTable.getTable(), 0);
        outputValueColumn.setText("Value");
        outputValueColumn.setWidth(150);
        this.outputTable.setContentProvider((IContentProvider)new OutputTableContentProvider());
        this.outputTable.setLabelProvider((IBaseLabelProvider)new OutputTableLabelProvider());
        this.outputTable.setInput((Object)this);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 90;
        gd.widthHint = 300;
        this.outputTable.getTable().setLayoutData((Object)gd);
        this.outputTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!SubdialogPropertiesPanel.this.outputTable.getSelection().isEmpty()) {
                    OutputValueDialog vd = new OutputValueDialog(Display.getCurrent().getActiveShell());
                    SubdialogInformationProvider.SubdialogOutput so = (SubdialogInformationProvider.SubdialogOutput)((IStructuredSelection)SubdialogPropertiesPanel.this.outputTable.getSelection()).getFirstElement();
                    vd.setValue(so);
                    if (vd.open() == 32) {
                        SubdialogPropertiesPanel.this.outputTable.refresh();
                    }
                }
            }
        });
        this.outputTable.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && !SubdialogPropertiesPanel.this.outputTable.getSelection().isEmpty()) {
                    SubdialogInformationProvider.SubdialogOutput so = (SubdialogInformationProvider.SubdialogOutput)((IStructuredSelection)SubdialogPropertiesPanel.this.outputTable.getSelection()).getFirstElement();
                    SubdialogPropertiesPanel.this.outputs.remove(so);
                    SubdialogPropertiesPanel.this.outputTable.refresh();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        addButton = new Button((Composite)outputsGroup, 8);
        addButton.setText("Add Ouput");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OutputValueDialog vd = new OutputValueDialog(Display.getCurrent().getActiveShell());
                SubdialogInformationProvider subdialogInformationProvider = SubdialogPropertiesPanel.this.info;
                ((Object)((Object)subdialogInformationProvider)).getClass();
                SubdialogInformationProvider.SubdialogOutput so = subdialogInformationProvider.new SubdialogInformationProvider.SubdialogOutput("", "");
                vd.setValue(so);
                if (vd.open() == 32) {
                    SubdialogPropertiesPanel.this.outputs.add(so);
                    SubdialogPropertiesPanel.this.outputTable.refresh();
                }
            }
        });
        deleteButton = new Button((Composite)outputsGroup, 8);
        deleteButton.setText("Delete Output");
        gd = new GridData();
        deleteButton.setLayoutData((Object)gd);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!SubdialogPropertiesPanel.this.outputTable.getSelection().isEmpty()) {
                    SubdialogInformationProvider.SubdialogOutput so = (SubdialogInformationProvider.SubdialogOutput)((IStructuredSelection)SubdialogPropertiesPanel.this.outputTable.getSelection()).getFirstElement();
                    SubdialogPropertiesPanel.this.outputs.remove(so);
                    SubdialogPropertiesPanel.this.outputTable.refresh();
                }
            }
        });
    }

    public void save() {
        this.getElement().setName(this.nameField.getText());
        this.info.setURL(this.urlField.getText());
        this.info.setInputs(this.inputs);
        this.info.setOutputs(this.outputs);
        this.info.setURLParameters(this.urlParameters);
    }

    public void cancel() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    private class Comparer
    implements Comparable<Comparer> {
        ObjectDefinition od = null;

        public Comparer(ObjectDefinition od) {
            this.od = od;
        }

        @Override
        public int compareTo(Comparer arg0) {
            return this.od.getName().compareToIgnoreCase(arg0.od.getName());
        }
    }

    public class InputTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return SubdialogPropertiesPanel.this.inputs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class InputTableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SubdialogInformationProvider.SubdialogInput si = (SubdialogInformationProvider.SubdialogInput)element;
            if (columnIndex == 0) {
                return si.name;
            }
            return si.value;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class InputValueDialog
    extends FramedDialog {
        Text variableNameField;
        TreeViewer variableViewer;
        Text staticValueField;
        SubdialogInformationProvider.SubdialogInput value;
        Color darkBlue;
        Color lightBlue;
        List<ObjectDefinition> vars;
        Composite staticValueComp;
        Composite variableTreeComp;
        Composite valueComp;
        StackLayout valueLayout;
        Combo valueType;
        Label nameLabel;
        Button okButton;

        public InputValueDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("Select a value");
            List unsortedVars = SubdialogPropertiesPanel.this.getElement().getDesign().getVariablesFor(SubdialogPropertiesPanel.this.getElement());
            if (unsortedVars == null) {
                this.vars = null;
            } else {
                Comparable[] comp = new Comparable[unsortedVars.size()];
                int b = 0;
                while (b < unsortedVars.size()) {
                    Object obj = unsortedVars.get(b);
                    Comparer compr = new Comparer((ObjectDefinition)obj);
                    comp[b] = compr;
                    ++b;
                }
                comp = QuickSort.comparableSort((Comparable[])comp);
                this.vars = new ArrayList<ObjectDefinition>();
                b = 0;
                while (b < comp.length) {
                    this.vars.add(((Comparer)comp[b]).od);
                    ++b;
                }
            }
        }

        public void setValue(SubdialogInformationProvider.SubdialogInput value) {
            this.value = value;
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            this.okButton = new Button(buttons, 8);
            this.okButton.setText("Ok");
            this.okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    InputValueDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 8);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    InputValueDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (Display.getCurrent().getDismissalAlignment() == 131072) {
                cancelButton.moveAbove((Control)this.okButton);
            }
            this.getShell().setDefaultButton(this.okButton);
        }

        public void okPressed() {
            this.value.name = this.variableNameField.getText();
            if (this.valueType.getSelectionIndex() == 1) {
                this.value.type = 1;
                this.value.value = !this.variableViewer.getSelection().isEmpty() ? ((ObjectDefinition)((IStructuredSelection)this.variableViewer.getSelection()).getFirstElement()).getPath() : "";
            } else {
                this.value.type = 0;
                this.value.value = this.staticValueField.getText();
            }
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    InputValueDialog.this.darkBlue.dispose();
                    InputValueDialog.this.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            parent.setLayout((Layout)new GridLayout(2, false));
            this.nameLabel = new Label(parent, 0);
            this.nameLabel.setText("Input Name");
            this.nameLabel.setBackground(parent.getBackground());
            GridData gd = new GridData();
            this.nameLabel.setLayoutData((Object)gd);
            this.variableNameField = new Text(parent, 2052);
            this.variableNameField.setText(this.value.name);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.variableNameField.setLayoutData((Object)gd);
            this.variableNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String currentName = String.valueOf(InputValueDialog.this.variableNameField.getText().substring(0, e.start)) + e.text + InputValueDialog.this.variableNameField.getText(e.end, InputValueDialog.this.variableNameField.getText().length() - 1);
                    if (VariableNameValidator.followsEcmaNamingRules((String)currentName).booleanValue()) {
                        InputValueDialog.this.nameLabel.setForeground(InputValueDialog.this.nameLabel.getDisplay().getSystemColor(2));
                        InputValueDialog.this.variableNameField.setForeground(InputValueDialog.this.variableNameField.getDisplay().getSystemColor(2));
                        InputValueDialog.this.okButton.setEnabled(true);
                    } else {
                        InputValueDialog.this.nameLabel.setForeground(InputValueDialog.this.nameLabel.getDisplay().getSystemColor(3));
                        InputValueDialog.this.variableNameField.setForeground(InputValueDialog.this.variableNameField.getDisplay().getSystemColor(3));
                        InputValueDialog.this.okButton.setEnabled(false);
                    }
                }
            });
            this.okButton.setEnabled(VariableNameValidator.followsEcmaNamingRules((String)this.variableNameField.getText()).booleanValue());
            this.valueType = new Combo(parent, 12);
            GridData valueTypeGridData = new GridData();
            valueTypeGridData.verticalAlignment = 128;
            this.valueType.setLayoutData((Object)valueTypeGridData);
            this.valueType.add("Value");
            this.valueType.add("Variable");
            this.valueType.select(this.value.type == 1 ? 1 : 0);
            this.valueType.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    InputValueDialog.this.valueTypeChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.valueComp = new Composite(parent, 0);
            this.valueComp.setBackground(parent.getBackground());
            this.valueLayout = new StackLayout();
            this.valueComp.setLayout((Layout)this.valueLayout);
            this.valueComp.setLayoutData((Object)new GridData(768));
            this.staticValueComp = new Composite(this.valueComp, 0);
            this.staticValueComp.setBackground(this.valueComp.getBackground());
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.staticValueComp.setLayout((Layout)layout);
            this.variableTreeComp = new Composite(this.valueComp, 0);
            this.variableTreeComp.setBackground(this.valueComp.getBackground());
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.variableTreeComp.setLayout((Layout)layout);
            Tree variableTree = new Tree(this.variableTreeComp, 67588);
            gd = new GridData(1808);
            gd.horizontalIndent = 10;
            gd.horizontalSpan = 2;
            variableTree.setLayoutData((Object)gd);
            this.variableViewer = new TreeViewer(variableTree);
            this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
            this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
            this.variableViewer.setInput((Object)this);
            this.staticValueField = new Text(this.staticValueComp, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            if (this.value.type == 1) {
                int i = 0;
                while (i < this.vars.size()) {
                    Variable v = (Variable)this.vars.get(i);
                    if (v.getName().equals(this.value.value)) {
                        this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                    } else if (this.value.value != null && this.value.value.startsWith(v.getName())) {
                        List objectFields = v.getFields();
                        int f = 0;
                        while (f < objectFields.size()) {
                            ObjectField of = (ObjectField)objectFields.get(f);
                            if (of.getPath().equals(this.value.value)) {
                                this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)of));
                            }
                            ++f;
                        }
                    }
                    ++i;
                }
            }
            this.staticValueField.setLayoutData((Object)gd);
            if (this.value.type == 1) {
                this.valueLayout.topControl = this.variableTreeComp;
            } else {
                this.staticValueField.setText(this.value.value == null ? "" : this.value.value);
                this.valueLayout.topControl = this.staticValueComp;
            }
        }

        private void valueTypeChanged() {
            switch (this.valueType.getSelectionIndex()) {
                case 1: {
                    this.valueLayout.topControl = this.variableTreeComp;
                    break;
                }
                default: {
                    this.valueLayout.topControl = this.staticValueComp;
                }
            }
            this.valueComp.layout();
        }

        public class VariableContentProvider
        implements ITreeContentProvider {
            public Object[] getElements(Object inputElement) {
                return InputValueDialog.this.vars.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return ((ObjectDefinition)parentElement).getFields().toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof Variable) {
                    return null;
                }
                return ((ObjectField)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return true;
            }
        }

        public class VariableLabelProvider
        extends LabelProvider {
            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }

            public String getText(Object element) {
                return ((ObjectDefinition)element).getName();
            }
        }
    }

    public class OutputTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return SubdialogPropertiesPanel.this.outputs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class OutputTableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SubdialogInformationProvider.SubdialogOutput so = (SubdialogInformationProvider.SubdialogOutput)element;
            if (columnIndex == 0) {
                return so.varName;
            }
            return so.valueName;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class OutputValueDialog
    extends FramedDialog {
        Text variableNameField;
        Text staticValueField;
        SubdialogInformationProvider.SubdialogOutput value;
        Color darkBlue;
        Color lightBlue;
        Button okButton;
        Label nameLabel;
        Label valueLabel;

        public OutputValueDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("Select a value");
        }

        public void setValue(SubdialogInformationProvider.SubdialogOutput value) {
            this.value = value;
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            this.okButton = new Button(buttons, 8);
            this.okButton.setText("Ok");
            this.okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OutputValueDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 8);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OutputValueDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (Display.getCurrent().getDismissalAlignment() == 131072) {
                cancelButton.moveAbove((Control)this.okButton);
            }
            this.getShell().setDefaultButton(this.okButton);
        }

        public void okPressed() {
            this.value.varName = this.variableNameField.getText();
            this.value.valueName = this.staticValueField.getText();
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    OutputValueDialog.this.darkBlue.dispose();
                    OutputValueDialog.this.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            parent.setLayout((Layout)new GridLayout(2, false));
            this.nameLabel = new Label(parent, 0);
            this.nameLabel.setText("Target Variable Name");
            this.nameLabel.setBackground(parent.getBackground());
            GridData gd = new GridData();
            this.nameLabel.setLayoutData((Object)gd);
            this.variableNameField = new Text(parent, 2052);
            this.variableNameField.setText(this.value.varName);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.variableNameField.setLayoutData((Object)gd);
            this.variableNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String currentName = String.valueOf(OutputValueDialog.this.variableNameField.getText().substring(0, e.start)) + e.text + OutputValueDialog.this.variableNameField.getText(e.end, OutputValueDialog.this.variableNameField.getText().length() - 1);
                    if (VariableNameValidator.followsEcmaNamingRules((String)currentName).booleanValue()) {
                        OutputValueDialog.this.nameLabel.setForeground(OutputValueDialog.this.nameLabel.getDisplay().getSystemColor(2));
                        OutputValueDialog.this.variableNameField.setForeground(OutputValueDialog.this.variableNameField.getDisplay().getSystemColor(2));
                        if (VariableNameValidator.followsEcmaNamingRules((String)OutputValueDialog.this.staticValueField.getText()).booleanValue()) {
                            OutputValueDialog.this.okButton.setEnabled(true);
                        }
                    } else {
                        OutputValueDialog.this.nameLabel.setForeground(OutputValueDialog.this.nameLabel.getDisplay().getSystemColor(3));
                        OutputValueDialog.this.variableNameField.setForeground(OutputValueDialog.this.variableNameField.getDisplay().getSystemColor(3));
                        OutputValueDialog.this.okButton.setEnabled(false);
                    }
                }
            });
            this.valueLabel = new Label(parent, 0);
            this.valueLabel.setText("Subdialog Return Value");
            this.valueLabel.setBackground(parent.getBackground());
            gd = new GridData();
            this.valueLabel.setLayoutData((Object)gd);
            this.staticValueField = new Text(parent, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.staticValueField.setLayoutData((Object)gd);
            this.staticValueField.setText(this.value.valueName == null ? "" : this.value.valueName);
            this.staticValueField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String currentName = String.valueOf(OutputValueDialog.this.staticValueField.getText().substring(0, e.start)) + e.text + OutputValueDialog.this.staticValueField.getText(e.end, OutputValueDialog.this.staticValueField.getText().length() - 1);
                    if (VariableNameValidator.followsEcmaNamingRules((String)currentName).booleanValue()) {
                        OutputValueDialog.this.valueLabel.setForeground(OutputValueDialog.this.valueLabel.getDisplay().getSystemColor(2));
                        OutputValueDialog.this.staticValueField.setForeground(OutputValueDialog.this.staticValueField.getDisplay().getSystemColor(2));
                        if (VariableNameValidator.followsEcmaNamingRules((String)OutputValueDialog.this.variableNameField.getText()).booleanValue()) {
                            OutputValueDialog.this.okButton.setEnabled(true);
                        }
                    } else {
                        OutputValueDialog.this.valueLabel.setForeground(OutputValueDialog.this.valueLabel.getDisplay().getSystemColor(3));
                        OutputValueDialog.this.staticValueField.setForeground(OutputValueDialog.this.staticValueField.getDisplay().getSystemColor(3));
                        OutputValueDialog.this.okButton.setEnabled(false);
                    }
                }
            });
            this.okButton.setEnabled(VariableNameValidator.followsEcmaNamingRules((String)this.variableNameField.getText()) != false && VariableNameValidator.followsEcmaNamingRules((String)this.staticValueField.getText()) != false);
        }
    }

    public class ParamTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return SubdialogPropertiesPanel.this.urlParameters.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ParamTableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SubdialogInformationProvider.SubdialogParameter si = (SubdialogInformationProvider.SubdialogParameter)element;
            if (columnIndex == 0) {
                return si.name;
            }
            return si.value;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ParameterValueDialog
    extends FramedDialog {
        Text variableNameField;
        TreeViewer variableViewer;
        Text staticValueField;
        SubdialogInformationProvider.SubdialogParameter value;
        Color darkBlue;
        Color lightBlue;
        List<ObjectDefinition> vars;
        Composite staticValueComp;
        Composite variableTreeComp;
        Composite valueComp;
        StackLayout valueLayout;
        Combo valueType;
        Label nameLabel;
        Button okButton;

        public ParameterValueDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("Select a value");
            List unsortedVars = SubdialogPropertiesPanel.this.getElement().getDesign().getVariablesFor(SubdialogPropertiesPanel.this.getElement());
            if (unsortedVars == null) {
                this.vars = null;
            } else {
                Comparable[] comp = new Comparable[unsortedVars.size()];
                int b = 0;
                while (b < unsortedVars.size()) {
                    Comparer compr = new Comparer((ObjectDefinition)unsortedVars.get(b));
                    comp[b] = compr;
                    ++b;
                }
                comp = QuickSort.comparableSort((Comparable[])comp);
                this.vars = new ArrayList<ObjectDefinition>();
                b = 0;
                while (b < comp.length) {
                    this.vars.add(((Comparer)comp[b]).od);
                    ++b;
                }
            }
        }

        public void setValue(SubdialogInformationProvider.SubdialogParameter value) {
            this.value = value;
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            this.okButton = new Button(buttons, 8);
            this.okButton.setText("Ok");
            this.okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterValueDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 8);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterValueDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (Display.getCurrent().getDismissalAlignment() == 131072) {
                cancelButton.moveAbove((Control)this.okButton);
            }
            this.getShell().setDefaultButton(this.okButton);
        }

        public void okPressed() {
            this.value.name = this.variableNameField.getText();
            if (this.valueType.getSelectionIndex() == 1) {
                this.value.type = 1;
                this.value.value = !this.variableViewer.getSelection().isEmpty() ? ((ObjectDefinition)((IStructuredSelection)this.variableViewer.getSelection()).getFirstElement()).getPath() : "";
            } else {
                this.value.type = 0;
                this.value.value = this.staticValueField.getText();
            }
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ParameterValueDialog.this.darkBlue.dispose();
                    ParameterValueDialog.this.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            parent.setLayout((Layout)new GridLayout(2, false));
            this.nameLabel = new Label(parent, 0);
            this.nameLabel.setText("Parameter Name");
            this.nameLabel.setBackground(parent.getBackground());
            GridData gd = new GridData();
            this.nameLabel.setLayoutData((Object)gd);
            this.variableNameField = new Text(parent, 2052);
            this.variableNameField.setText(this.value.name);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.variableNameField.setLayoutData((Object)gd);
            this.variableNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String currentName = String.valueOf(ParameterValueDialog.this.variableNameField.getText().substring(0, e.start)) + e.text + ParameterValueDialog.this.variableNameField.getText(e.end, ParameterValueDialog.this.variableNameField.getText().length() - 1);
                    if (VariableNameValidator.followsEcmaNamingRules((String)currentName).booleanValue()) {
                        ParameterValueDialog.this.nameLabel.setForeground(ParameterValueDialog.this.nameLabel.getDisplay().getSystemColor(2));
                        ParameterValueDialog.this.variableNameField.setForeground(ParameterValueDialog.this.variableNameField.getDisplay().getSystemColor(2));
                        ParameterValueDialog.this.okButton.setEnabled(true);
                    } else {
                        ParameterValueDialog.this.nameLabel.setForeground(ParameterValueDialog.this.nameLabel.getDisplay().getSystemColor(3));
                        ParameterValueDialog.this.variableNameField.setForeground(ParameterValueDialog.this.variableNameField.getDisplay().getSystemColor(3));
                        ParameterValueDialog.this.okButton.setEnabled(false);
                    }
                }
            });
            this.okButton.setEnabled(VariableNameValidator.followsEcmaNamingRules((String)this.variableNameField.getText()).booleanValue());
            this.valueType = new Combo(parent, 12);
            GridData valueTypeGridData = new GridData();
            valueTypeGridData.verticalAlignment = 128;
            this.valueType.setLayoutData((Object)valueTypeGridData);
            this.valueType.add("Value");
            this.valueType.add("Variable");
            this.valueType.select(this.value.type == 1 ? 1 : 0);
            this.valueType.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterValueDialog.this.valueTypeChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.valueComp = new Composite(parent, 0);
            this.valueComp.setBackground(parent.getBackground());
            this.valueLayout = new StackLayout();
            this.valueComp.setLayout((Layout)this.valueLayout);
            this.valueComp.setLayoutData((Object)new GridData(768));
            this.staticValueComp = new Composite(this.valueComp, 0);
            this.staticValueComp.setBackground(this.valueComp.getBackground());
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.staticValueComp.setLayout((Layout)layout);
            this.variableTreeComp = new Composite(this.valueComp, 0);
            this.variableTreeComp.setBackground(this.valueComp.getBackground());
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.variableTreeComp.setLayout((Layout)layout);
            Tree variableTree = new Tree(this.variableTreeComp, 67588);
            gd = new GridData(1808);
            gd.horizontalIndent = 10;
            gd.horizontalSpan = 2;
            variableTree.setLayoutData((Object)gd);
            this.variableViewer = new TreeViewer(variableTree);
            this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
            this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
            this.variableViewer.setInput((Object)this);
            this.staticValueField = new Text(this.staticValueComp, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            if (this.value.type == 1) {
                int i = 0;
                while (i < this.vars.size()) {
                    Variable v = (Variable)this.vars.get(i);
                    if (v.getName().equals(this.value.value)) {
                        this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                    } else if (this.value.value != null && this.value.value.startsWith(v.getName())) {
                        List objectFields = v.getFields();
                        int f = 0;
                        while (f < objectFields.size()) {
                            ObjectField of = (ObjectField)objectFields.get(f);
                            if (of.getPath().equals(this.value.value)) {
                                this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)of));
                            }
                            ++f;
                        }
                    }
                    ++i;
                }
            }
            this.staticValueField.setLayoutData((Object)gd);
            if (this.value.type == 1) {
                this.valueLayout.topControl = this.variableTreeComp;
            } else {
                this.staticValueField.setText(this.value.value == null ? "" : this.value.value);
                this.valueLayout.topControl = this.staticValueComp;
            }
        }

        private void valueTypeChanged() {
            switch (this.valueType.getSelectionIndex()) {
                case 1: {
                    this.valueLayout.topControl = this.variableTreeComp;
                    break;
                }
                default: {
                    this.valueLayout.topControl = this.staticValueComp;
                }
            }
            this.valueComp.layout();
        }

        public class VariableContentProvider
        implements ITreeContentProvider {
            public Object[] getElements(Object inputElement) {
                return ParameterValueDialog.this.vars.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return ((ObjectDefinition)parentElement).getFields().toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof Variable) {
                    return null;
                }
                return ((ObjectField)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return true;
            }
        }

        public class VariableLabelProvider
        extends LabelProvider {
            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }

            public String getText(Object element) {
                return ((ObjectDefinition)element).getName();
            }
        }
    }
}

