/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.InteractionBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.LanguageBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PropertyBindingItem;

public class TransferGeneralPropertiesPanel
extends DesignElementPropertiesPanel {
    GenericBindingManager bindingManager;
    IBrand currentBrand;
    String currentLanguage;
    String interactionType;
    Label nameLabel;
    Text nameField;
    Combo destinationType;
    Composite destinationComp;
    StackLayout destinationLayout;
    Composite destinationValueComp;
    Text destinationValue;
    Composite destinationExprComp;
    Text destinationExpr;
    Composite destinationTreeComp;
    TreeViewer destinationTree;
    List<Variable> variables = new ArrayList<Variable>();

    public TransferGeneralPropertiesPanel(String name, IDesignElement designElement) {
        super(name, designElement);
        this.bindingManager = (GenericBindingManager)designElement.getConfigurationManager("org.eclipse.vtp.configuration.generic");
        List vars = designElement.getDesign().getVariablesFor(designElement);
        block0: for (Variable v : vars) {
            int i = 0;
            while (i < this.variables.size()) {
                if (this.variables.get(i).getName().compareToIgnoreCase(v.getName()) > 0) {
                    this.variables.add(i, v);
                    continue block0;
                }
                ++i;
            }
            this.variables.add(v);
        }
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(3, false));
        this.nameLabel = new Label(comp, 0);
        this.nameLabel.setText("Name: ");
        this.nameLabel.setBackground(comp.getBackground());
        this.nameLabel.setLayoutData((Object)new GridData(4));
        this.nameField = new Text(comp, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label valueLabel = new Label(comp, 0);
        valueLabel.setText("Destination: ");
        valueLabel.setBackground(comp.getBackground());
        valueLabel.setLayoutData((Object)new GridData(4));
        this.destinationType = new Combo(comp, 12);
        this.destinationType.setLayoutData((Object)new GridData(4));
        this.destinationType.add("Value");
        this.destinationType.add("Expression");
        this.destinationType.add("Variable");
        this.destinationType.select(0);
        this.destinationType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransferGeneralPropertiesPanel.this.destinationTypeChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.destinationComp = new Composite(comp, 0);
        this.destinationComp.setBackground(comp.getBackground());
        this.destinationLayout = new StackLayout();
        this.destinationComp.setLayout((Layout)this.destinationLayout);
        this.destinationComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.destinationValueComp = new Composite(this.destinationComp, 0);
        this.destinationValueComp.setBackground(this.destinationComp.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.destinationValueComp.setLayout((Layout)layout);
        this.destinationValue = new Text(this.destinationValueComp, 2052);
        this.destinationValue.setLayoutData((Object)new GridData(4, 1, true, false));
        this.destinationExprComp = new Composite(this.destinationComp, 0);
        this.destinationExprComp.setBackground(this.destinationComp.getBackground());
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.destinationExprComp.setLayout((Layout)layout);
        this.destinationExpr = new Text(this.destinationExprComp, 2052);
        this.destinationExpr.setLayoutData((Object)new GridData(4, 1, true, false));
        this.destinationTreeComp = new Composite(this.destinationComp, 0);
        this.destinationTreeComp.setBackground(this.destinationComp.getBackground());
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.destinationTreeComp.setLayout((Layout)layout);
        this.destinationTree = new TreeViewer(this.destinationTreeComp, 2820);
        this.destinationTree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.destinationTree.setContentProvider((IContentProvider)new VariableContentProvider());
        this.destinationTree.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.destinationTree.setInput((Object)this);
        this.destinationLayout.topControl = this.destinationValueComp;
        this.destinationComp.layout();
        new Label(comp, 0);
        new Label(comp, 0);
        this.setControl((Control)comp);
    }

    private void destinationTypeChanged() {
        switch (this.destinationType.getSelectionIndex()) {
            case 2: {
                this.destinationLayout.topControl = this.destinationTreeComp;
                break;
            }
            case 1: {
                this.destinationLayout.topControl = this.destinationExprComp;
                break;
            }
            default: {
                this.destinationLayout.topControl = this.destinationValueComp;
            }
        }
        this.destinationComp.layout();
    }

    public void setConfigurationContext(Map<String, Object> values) {
        this.currentBrand = (IBrand)values.get("org.eclipse.vtp.desktop.model.core.brandcontext");
        this.currentLanguage = (String)values.get("org.eclipse.vtp.desktop.model.interactive.core.languagecontext");
        Object object = values.get("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext");
        if (this.currentBrand == null || this.currentLanguage == null || object == null) {
            IWorkflowProject project = this.getElement().getDesign().getDocument().getProject();
            System.out.println("project: " + project);
            final IProject uproject = project.getUnderlyingProject();
            final Shell shell = this.getContainer().getParentShell();
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox mb = new MessageBox(shell, 289);
                    mb.setText("Configuration Problems");
                    mb.setMessage("The interaction and language configuration for this project is incomplete.  You will not be able edit the applications effectively until this is resolved.  Would you like to configure this now?");
                    if (mb.open() == 32) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PropertyDialog pd = PropertyDialog.createDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.vtp.desktop.projects.core.appproperties", (Object)uproject);
                                pd.open();
                            }
                        });
                    }
                    TransferGeneralPropertiesPanel.this.getContainer().cancelDialog();
                }
            });
            return;
        }
        this.interactionType = ((InteractionType)object).getId();
        int typeIndex = 0;
        InteractionBinding interactionBinding = this.bindingManager.getInteractionBinding(this.interactionType);
        NamedBinding namedBinding = interactionBinding.getNamedBinding("type");
        LanguageBinding languageBinding = namedBinding.getLanguageBinding("");
        BrandBinding brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        PropertyBindingItem typePropertyItem = (PropertyBindingItem)brandBinding.getBindingItem();
        if (typePropertyItem == null) {
            typePropertyItem = new PropertyBindingItem();
        }
        if ("variable".equalsIgnoreCase(typePropertyItem.getValue())) {
            typeIndex = 2;
        } else if ("expression".equalsIgnoreCase(typePropertyItem.getValue())) {
            typeIndex = 1;
        }
        this.destinationType.select(typeIndex);
        namedBinding = interactionBinding.getNamedBinding("destination");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        PropertyBindingItem valuePropertyItem = (PropertyBindingItem)brandBinding.getBindingItem();
        if (valuePropertyItem == null) {
            valuePropertyItem = new PropertyBindingItem();
        }
        if (valuePropertyItem.getValue() != null) {
            switch (typeIndex) {
                case 2: {
                    ObjectDefinition od = this.getObjectDefinitionFromVariables(valuePropertyItem.getValue());
                    StructuredSelection ss = od == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)od);
                    this.destinationTree.setSelection((ISelection)ss);
                    break;
                }
                case 1: {
                    this.destinationExpr.setText(valuePropertyItem.getValue());
                    break;
                }
                default: {
                    this.destinationValue.setText(valuePropertyItem.getValue());
                }
            }
        }
        this.destinationTypeChanged();
    }

    public void save() {
        try {
            InteractionBinding interactionBinding;
            NamedBinding namedBinding;
            LanguageBinding languageBinding;
            BrandBinding brandBinding;
            PropertyBindingItem typePropertyItem;
            String value;
            String type;
            this.getElement().setName(this.nameField.getText());
            switch (this.destinationType.getSelectionIndex()) {
                case 2: {
                    Object selObj;
                    type = "variable";
                    value = "";
                    ISelection selection = this.destinationTree.getSelection();
                    if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection) || !((selObj = ((IStructuredSelection)selection).getFirstElement()) instanceof ObjectDefinition)) break;
                    value = ((ObjectDefinition)selObj).getPath();
                    break;
                }
                case 1: {
                    type = "expression";
                    value = this.destinationExpr.getText();
                    break;
                }
                default: {
                    type = "value";
                    value = this.destinationValue.getText();
                }
            }
            typePropertyItem = (typePropertyItem = (PropertyBindingItem)(brandBinding = (languageBinding = (namedBinding = (interactionBinding = this.bindingManager.getInteractionBinding(this.interactionType)).getNamedBinding("type")).getLanguageBinding("")).getBrandBinding(this.currentBrand)).getBindingItem()) == null ? new PropertyBindingItem() : (PropertyBindingItem)typePropertyItem.clone();
            typePropertyItem.setValue(type);
            brandBinding.setBindingItem((BindingItem)typePropertyItem);
            namedBinding = interactionBinding.getNamedBinding("destination");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            PropertyBindingItem valuePropertyItem = (PropertyBindingItem)brandBinding.getBindingItem();
            valuePropertyItem = valuePropertyItem == null ? new PropertyBindingItem() : (PropertyBindingItem)valuePropertyItem.clone();
            valuePropertyItem.setValue(value);
            brandBinding.setBindingItem((BindingItem)valuePropertyItem);
            this.getElement().commitConfigurationChanges((ConfigurationManager)this.bindingManager);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public ObjectDefinition getObjectDefinitionFromVariables(String name) {
        Variable ret = null;
        List vars = this.getElement().getDesign().getVariablesFor(this.getElement());
        int i = 0;
        while (i < vars.size()) {
            Variable v;
            String varName = name;
            boolean sub = false;
            if (name.indexOf(".") != -1) {
                varName = name.substring(0, name.indexOf("."));
                sub = true;
            }
            if ((v = (Variable)vars.get(i)).getName().equals(varName)) {
                if (sub) {
                    ret = this.getObjectDefinitionFromFields(name.substring(name.indexOf(".") + 1), (ObjectDefinition)v);
                } else {
                    ret = v;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public ObjectDefinition getObjectDefinitionFromFields(String name, ObjectDefinition parent) {
        ObjectField ret = null;
        List fields = parent.getFields();
        int i = 0;
        while (i < fields.size()) {
            ObjectField of;
            String varName = name;
            boolean sub = false;
            if (name.indexOf(46) != -1) {
                varName = name.substring(0, name.indexOf("."));
                sub = true;
            }
            if ((of = (ObjectField)fields.get(i)).getName().equals(varName)) {
                if (sub) {
                    ret = this.getObjectDefinitionFromFields(name.substring(name.indexOf(".") + 1), (ObjectDefinition)of);
                } else {
                    ret = of;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public List<String> getApplicableContexts() {
        List ret = super.getApplicableContexts();
        ret.add("org.eclipse.vtp.desktop.model.interactive.core.languagecontext");
        ret.add("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext");
        return ret;
    }

    public class VariableContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ObjectDefinition) {
                ObjectDefinition v = (ObjectDefinition)parentElement;
                return v.getFields().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Variable) {
                return null;
            }
            return ((ObjectField)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((ObjectDefinition)element).getFields().size() > 0;
        }

        public Object[] getElements(Object inputElement) {
            return TransferGeneralPropertiesPanel.this.variables.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((ObjectDefinition)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

