/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.elements.core.IDialogExit;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.w3c.dom.Element;

public class ExitInformationProvider
extends PrimitiveInformationProvider
implements IDialogExit {
    String exitType = "Normal";

    public ExitInformationProvider(PrimitiveElement element) {
        super(element);
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return Collections.emptyList();
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        return Collections.emptyList();
    }

    public void readConfiguration(Element configuration) {
        this.exitType = configuration.getAttribute("exit-type");
        if (!this.exitType.equals("Normal") && !this.exitType.equals("Error")) {
            this.exitType = "Normal";
        }
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("exit-type", this.exitType);
    }

    public String getExitType() {
        return this.exitType;
    }

    public void setExitType(String text) {
        String oldType = this.exitType;
        this.exitType = text;
        this.getElement().firePropertyChange("PROP_EXIT_TYPE", (Object)oldType, (Object)text);
    }

    public boolean hasConnectors() {
        return false;
    }

    public IDesignElementConnectionPoint.ConnectionPointType getType() {
        return this.exitType.equals("Error") ? IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT : IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT;
    }
}

