/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.ISecurableElement;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ScriptInformationProvider
extends PrimitiveInformationProvider
implements ISecurableElement {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    String scriptText = "";
    boolean secured = false;

    public ScriptInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.script", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList nl = configuration.getElementsByTagName("script");
        if (nl.getLength() > 0) {
            Element scriptElement = (Element)nl.item(0);
            this.secured = Boolean.parseBoolean(scriptElement.getAttribute("secured"));
            this.scriptText = XMLUtilities.getElementTextDataNoEx((Element)scriptElement, (boolean)true);
            if (this.scriptText == null) {
                this.scriptText = "";
            }
        }
    }

    public void writeConfiguration(Element configuration) {
        Element scriptElement = configuration.getOwnerDocument().createElement("script");
        configuration.appendChild(scriptElement);
        scriptElement.setAttribute("secured", Boolean.toString(this.secured));
        scriptElement.setTextContent(this.scriptText);
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String text) {
        this.scriptText = text;
    }

    public boolean hasConnectors() {
        return true;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }
}

