/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.BeginInformationProvider;
import org.eclipse.vtp.modules.standard.ui.VariableDeclaration;
import org.eclipse.vtp.modules.standard.ui.properties.NewVariableDialog;

public class ApplicationStartVariablesPropertyPanel
extends DesignElementPropertiesPanel {
    List<VariableDeclaration> declarations;
    TableViewer variableViewer;
    Button addButton;
    Button removeButton;
    TextCellEditor valueEditor;
    CheckboxCellEditor secureEditor;
    private Text nameText = null;
    private Combo defaultBrandCombo = null;
    private List<IBrand> brands = new ArrayList<IBrand>();

    public ApplicationStartVariablesPropertyPanel(String name, IDesignElement element) {
        super(name, element);
        IWorkflowProject wp = this.getElement().getDesign().getDocument().getProject();
        this.declarations = ((BeginInformationProvider)((PrimitiveElement)element).getInformationProvider()).getDeclarations();
        BrandManager bm = wp.getBrandManager();
        IBrand b = bm.getDefaultBrand();
        this.addBrand(b);
    }

    private void addBrand(IBrand b) {
        this.brands.add(b);
        for (IBrand c : b.getChildBrands()) {
            this.addBrand(c);
        }
    }

    private String getLabel(IBrand b) {
        StringBuilder sb = new StringBuilder();
        IBrand parent = b.getParent();
        while (parent != null) {
            sb.append("  ");
            parent = parent.getParent();
        }
        sb.append(b.getName());
        return sb.toString();
    }

    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setBackgroundMode(1);
        Composite nameComp = new Composite(parent, 0);
        nameComp.setBackground(parent.getBackground());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        nameComp.setLayoutData((Object)gd);
        nameComp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(nameComp, 0);
        nameLabel.setText("Entry Name:");
        nameLabel.setLayoutData((Object)new GridData());
        this.nameText = new Text(nameComp, 2052);
        this.nameText.setText(this.getElement().getName());
        this.nameText.setLayoutData((Object)new GridData(768));
        Label defaultBrandLabel = new Label(nameComp, 0);
        defaultBrandLabel.setText("Default Brand");
        defaultBrandLabel.setLayoutData((Object)new GridData());
        this.defaultBrandCombo = new Combo(nameComp, 12);
        this.defaultBrandCombo.setLayoutData((Object)new GridData(768));
        for (IBrand b : this.brands) {
            this.defaultBrandCombo.add(this.getLabel(b));
        }
        String currentDefault = ((BeginInformationProvider)((PrimitiveElement)this.getElement()).getInformationProvider()).getDefaultBrand();
        int i = 0;
        while (i < this.brands.size()) {
            if (this.brands.get(i).getId().equals(currentDefault)) {
                this.defaultBrandCombo.select(i);
                break;
            }
            ++i;
        }
        if (this.defaultBrandCombo.getSelectionIndex() == -1) {
            this.defaultBrandCombo.select(0);
        }
        Table variableTable = new Table(parent, 67588);
        variableTable.setHeaderVisible(true);
        TableColumn secureColumn = new TableColumn(variableTable, 0);
        secureColumn.setImage(Activator.getDefault().getImageRegistry().get("ICON_LOCK"));
        secureColumn.setAlignment(0x1000000);
        secureColumn.setWidth(23);
        TableColumn nameColumn = new TableColumn(variableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(150);
        TableColumn typeColumn = new TableColumn(variableTable, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(variableTable, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        gd = new GridData(1808);
        gd.verticalSpan = 2;
        gd.widthHint = 505;
        gd.heightHint = 200;
        variableTable.setLayoutData((Object)gd);
        this.valueEditor = new TextCellEditor((Composite)variableTable);
        this.secureEditor = new CheckboxCellEditor((Composite)variableTable);
        this.variableViewer = new TableViewer(variableTable);
        this.variableViewer.setColumnProperties(new String[]{"Secure", "Name", "Type", "Value"});
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[0] = this.secureEditor;
        cellEditorArray[3] = this.valueEditor;
        this.variableViewer.setCellEditors(cellEditorArray);
        this.variableViewer.setCellModifier((ICellModifier)new ValueCellModifier());
        this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.variableViewer.setInput((Object)this);
        this.variableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                VariableDeclaration v1 = (VariableDeclaration)e1;
                VariableDeclaration v2 = (VariableDeclaration)e2;
                return v1.getName().compareTo(v2.getName());
            }
        });
        this.variableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ApplicationStartVariablesPropertyPanel.this.removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.variableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    ApplicationStartVariablesPropertyPanel.this.removeVariable();
                }
            }
        });
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        buttonComp.setLayoutData((Object)new GridData());
        this.addButton = new Button(buttonComp, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<String> reservedNames = new ArrayList<String>();
                for (VariableDeclaration vd : ApplicationStartVariablesPropertyPanel.this.declarations) {
                    reservedNames.add(vd.getName());
                }
                NewVariableDialog nvd = new NewVariableDialog(ApplicationStartVariablesPropertyPanel.this.addButton.getShell(), reservedNames, ApplicationStartVariablesPropertyPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet());
                if (nvd.open() == 32) {
                    ApplicationStartVariablesPropertyPanel.this.declarations.add(new VariableDeclaration(nvd.name, nvd.type, 0, null, nvd.secure));
                    ApplicationStartVariablesPropertyPanel.this.updateVariables();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = new Button(buttonComp, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData());
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationStartVariablesPropertyPanel.this.removeVariable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void removeVariable() {
        this.declarations.remove(((IStructuredSelection)this.variableViewer.getSelection()).getFirstElement());
        this.updateVariables();
    }

    public void save() {
        this.getElement().setName(this.nameText.getText());
        BeginInformationProvider ip = (BeginInformationProvider)((PrimitiveElement)this.getElement()).getInformationProvider();
        ip.setDeclarations(this.declarations);
        ip.setDefaultBrand(this.brands.get(this.defaultBrandCombo.getSelectionIndex()).getId());
    }

    public void cancel() {
    }

    private void updateVariables() {
        this.variableViewer.refresh();
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    public class ValueCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            VariableDeclaration vd = (VariableDeclaration)element;
            if (property.equals("Value") && vd.getType().hasValue()) {
                return true;
            }
            return property.equals("Secure");
        }

        public Object getValue(Object element, String property) {
            VariableDeclaration vd = (VariableDeclaration)element;
            if (property.equals("Value")) {
                return vd.getValue() == null ? "" : vd.getValue();
            }
            if (property.equals("Secure")) {
                return new Boolean(vd.isSecure());
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem ti = (TableItem)element;
            VariableDeclaration vd = (VariableDeclaration)ti.getData();
            if (property.equals("Value")) {
                vd.setValueType(0);
                vd.setValue((String)value);
                ApplicationStartVariablesPropertyPanel.this.variableViewer.refresh(true);
            } else if (property.equals("Secure")) {
                vd.setSecure((Boolean)value);
                ApplicationStartVariablesPropertyPanel.this.variableViewer.refresh(true);
            }
        }
    }

    public class VariableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return ApplicationStartVariablesPropertyPanel.this.declarations.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            VariableDeclaration vd = (VariableDeclaration)element;
            if (columnIndex == 0 && vd.isSecure()) {
                return Activator.getDefault().getImageRegistry().get("ICON_LOCK");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            VariableDeclaration vd = (VariableDeclaration)element;
            if (columnIndex == 0) {
                return "";
            }
            if (columnIndex == 1) {
                return vd.getName();
            }
            if (columnIndex == 2) {
                String ret = vd.getType().getName();
                if (vd.getType().hasBaseType()) {
                    ret = String.valueOf(ret) + " Of ";
                    ret = vd.getType().isObjectBaseType() ? String.valueOf(ret) + vd.getType().getObjectBaseType().getName() : String.valueOf(ret) + vd.getType().getPrimitiveBaseType().getName();
                }
                return ret;
            }
            if (columnIndex == 3 && vd.getType().hasValue()) {
                return vd.getValue();
            }
            return "N/A";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

