/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.dialogs.FramedDialog;
import org.eclipse.vtp.modules.standard.ui.properties.Branch;

public class BranchConfigurationDialog
extends FramedDialog {
    Text variableNameField;
    Text staticValueField;
    Branch branch;
    Color darkBlue;
    Color lightBlue;
    Button okButton;
    Label nameLabel;
    Label valueLabel;
    Button secureButton;
    List<Branch> branches = new ArrayList<Branch>();

    public BranchConfigurationDialog(Shell shell, List<Branch> branches) {
        super(shell);
        this.setSideBarSize(40);
        this.setTitle("Select a value");
        this.branches = branches;
    }

    public void setValue(Branch branch) {
        this.branch = branch;
    }

    protected void createButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite buttons = new Composite(parent, 0);
        buttons.setBackground(parent.getBackground());
        GridData buttonsData = new GridData(1808);
        buttonsData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)buttonsData);
        RowLayout rl = new RowLayout();
        rl.pack = false;
        rl.spacing = 5;
        buttons.setLayout((Layout)rl);
        this.okButton = new Button(buttons, 8);
        this.okButton.setText("Ok");
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BranchConfigurationDialog.this.okPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button cancelButton = new Button(buttons, 8);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BranchConfigurationDialog.this.cancelPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (Display.getCurrent().getDismissalAlignment() == 131072) {
            cancelButton.moveAbove((Control)this.okButton);
        }
        this.getShell().setDefaultButton(this.okButton);
    }

    public void okPressed() {
        this.branch.setName(this.variableNameField.getText());
        this.branch.setExpression(this.staticValueField.getText());
        this.branch.setSecure(this.secureButton.getSelection());
        this.branch.setNumber(this.branches.size());
        this.setReturnCode(32);
        this.close();
    }

    public void cancelPressed() {
        this.setReturnCode(256);
        this.close();
    }

    protected void createDialogContents(Composite parent) {
        this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
        this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BranchConfigurationDialog.this.darkBlue.dispose();
                BranchConfigurationDialog.this.lightBlue.dispose();
            }
        });
        this.setFrameColor(this.darkBlue);
        this.setSideBarColor(this.lightBlue);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText("Exit Path Name");
        this.nameLabel.setToolTipText("This will be the name given to a \r\nnew connector exiting the \r\nbranch module.");
        this.nameLabel.setBackground(parent.getBackground());
        GridData gd = new GridData();
        this.nameLabel.setLayoutData((Object)gd);
        this.variableNameField = new Text(parent, 2052);
        this.variableNameField.setText(this.branch.getName());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.variableNameField.setLayoutData((Object)gd);
        this.variableNameField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String currentName = String.valueOf(BranchConfigurationDialog.this.variableNameField.getText().substring(0, e.start)) + e.text + BranchConfigurationDialog.this.variableNameField.getText(e.end, BranchConfigurationDialog.this.variableNameField.getText().length() - 1);
                BranchConfigurationDialog.this.nameLabel.setForeground(BranchConfigurationDialog.this.nameLabel.getDisplay().getSystemColor(2));
                BranchConfigurationDialog.this.variableNameField.setForeground(BranchConfigurationDialog.this.variableNameField.getDisplay().getSystemColor(2));
                BranchConfigurationDialog.this.okButton.setEnabled(true);
                for (Branch br : BranchConfigurationDialog.this.branches) {
                    if ((!currentName.equals(br.getName()) || currentName.equals(BranchConfigurationDialog.this.branch.getName())) && !"".equals(currentName)) continue;
                    BranchConfigurationDialog.this.nameLabel.setForeground(BranchConfigurationDialog.this.nameLabel.getDisplay().getSystemColor(3));
                    BranchConfigurationDialog.this.variableNameField.setForeground(BranchConfigurationDialog.this.variableNameField.getDisplay().getSystemColor(3));
                    BranchConfigurationDialog.this.okButton.setEnabled(false);
                }
            }
        });
        if ("".equals(this.variableNameField.getText())) {
            this.nameLabel.setForeground(this.nameLabel.getDisplay().getSystemColor(3));
            this.variableNameField.setForeground(this.variableNameField.getDisplay().getSystemColor(3));
            this.okButton.setEnabled(false);
        }
        this.valueLabel = new Label(parent, 0);
        this.valueLabel.setText("Expression");
        this.valueLabel.setToolTipText("If this expression evaluates to true, \r\nthen the branch module will use \r\nthis exit path.");
        this.valueLabel.setBackground(parent.getBackground());
        gd = new GridData();
        this.valueLabel.setLayoutData((Object)gd);
        this.staticValueField = new Text(parent, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.staticValueField.setLayoutData((Object)gd);
        this.staticValueField.setText(this.branch.getExpression() == null ? "" : this.branch.getExpression());
        this.secureButton = new Button(parent, 32);
        this.secureButton.setText("Secure Expression");
        GridData gridData = new GridData(768);
        this.secureButton.setLayoutData((Object)gridData);
        this.secureButton.setSelection(this.branch.isSecure());
    }
}

