/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.BranchInformationProvider;
import org.eclipse.vtp.modules.standard.ui.properties.Branch;
import org.eclipse.vtp.modules.standard.ui.properties.BranchConfigurationDialog;

public class BranchPropertiesPanel
extends DesignElementPropertiesPanel {
    BranchInformationProvider info = null;
    List<Branch> branches = new ArrayList<Branch>();
    Label nameLabel = null;
    Text nameField = null;

    public BranchPropertiesPanel(String name, IDesignElement ppe) {
        super(name, ppe);
        this.info = (BranchInformationProvider)((PrimitiveElement)ppe).getInformationProvider();
        this.branches = this.info.getBranches();
    }

    public void save() {
        this.getElement().setName(this.nameField.getText());
        this.info.setBranches(this.branches);
    }

    public void cancel() {
    }

    public void createControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        container.setLayout((Layout)new GridLayout(2, false));
        Composite nameComp = new Composite(container, 0);
        nameComp.setBackground(container.getBackground());
        nameComp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        nameComp.setLayoutData((Object)gd);
        this.nameLabel = new Label(nameComp, 0);
        this.nameLabel.setText("Name");
        this.nameLabel.setBackground(nameComp.getBackground());
        this.nameLabel.setLayoutData((Object)new GridData());
        this.nameField = new Text(nameComp, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(768));
        Composite tableComp = new Composite(container, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        final TableViewer branchTableViewer = new TableViewer(tableComp, 68100);
        branchTableViewer.getTable().setHeaderVisible(true);
        branchTableViewer.getTable().setLinesVisible(true);
        TableViewerColumn secureViewerColumn = new TableViewerColumn(branchTableViewer, 0);
        TableColumn secureColumn = secureViewerColumn.getColumn();
        secureColumn.setImage(Activator.getDefault().getImageRegistry().get("ICON_LOCK"));
        layout.setColumnData((Widget)secureColumn, (ColumnLayoutData)new ColumnPixelData(23, false, false));
        TableViewerColumn branchNameViewerColumn = new TableViewerColumn(branchTableViewer, 0);
        TableColumn branchNameColumn = branchNameViewerColumn.getColumn();
        branchNameColumn.setText("Exit Path Name");
        branchNameColumn.setToolTipText("This will be the name given to a \r\nnew connector exiting the \r\nbranch module.");
        layout.setColumnData((Widget)branchNameColumn, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        TableViewerColumn branchValueViewerColumn = new TableViewerColumn(branchTableViewer, 0);
        TableColumn branchValueColumn = branchValueViewerColumn.getColumn();
        branchValueColumn.setText("Expression");
        branchValueColumn.setToolTipText("If this expression evaluates to true, \r\nthen the branch module will use \r\nthis exit path.");
        layout.setColumnData((Widget)branchValueColumn, (ColumnLayoutData)new ColumnWeightData(7, 20, true));
        branchTableViewer.setContentProvider((IContentProvider)new BranchTableContentProvider());
        branchTableViewer.setLabelProvider((IBaseLabelProvider)new BranchTableLabelProvider());
        branchTableViewer.setInput((Object)this);
        branchTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!branchTableViewer.getSelection().isEmpty()) {
                    BranchConfigurationDialog bcd = new BranchConfigurationDialog(Display.getCurrent().getActiveShell(), BranchPropertiesPanel.this.branches);
                    Branch br = (Branch)((IStructuredSelection)branchTableViewer.getSelection()).getFirstElement();
                    bcd.setValue(br);
                    if (bcd.open() == 32) {
                        branchTableViewer.refresh();
                    }
                }
            }
        });
        branchTableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && !branchTableViewer.getSelection().isEmpty()) {
                    Branch br = (Branch)((IStructuredSelection)branchTableViewer.getSelection()).getFirstElement();
                    BranchPropertiesPanel.this.branches.remove(br);
                    branchTableViewer.refresh();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Composite buttonComp = new Composite(container, 0);
        buttonComp.setBackground(container.getBackground());
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        Button addButton = new Button(buttonComp, 8);
        addButton.setText("Add Branch");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BranchConfigurationDialog bcd = new BranchConfigurationDialog(Display.getCurrent().getActiveShell(), BranchPropertiesPanel.this.branches);
                Branch br = new Branch("", "", false, BranchPropertiesPanel.this.branches.size());
                bcd.setValue(br);
                if (bcd.open() == 32) {
                    BranchPropertiesPanel.this.branches.add(br);
                    branchTableViewer.refresh();
                }
            }
        });
        Button deleteButton = new Button(buttonComp, 8);
        deleteButton.setText("Delete Branch");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        deleteButton.setLayoutData((Object)gd);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!branchTableViewer.getSelection().isEmpty()) {
                    Branch br = (Branch)((IStructuredSelection)branchTableViewer.getSelection()).getFirstElement();
                    BranchPropertiesPanel.this.branches.remove(br);
                    branchTableViewer.refresh();
                }
            }
        });
        final Button upButton = new Button(buttonComp, 8);
        upButton.setText("Move Up");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        upButton.setLayoutData((Object)gd);
        upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!branchTableViewer.getSelection().isEmpty()) {
                    Branch branch = (Branch)((IStructuredSelection)branchTableViewer.getSelection()).getFirstElement();
                    BranchPropertiesPanel.moveBranchUp(branch, BranchPropertiesPanel.this.branches);
                    branchTableViewer.refresh();
                }
            }
        });
        final Button downButton = new Button(buttonComp, 8);
        downButton.setText("Move Down");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        downButton.setLayoutData((Object)gd);
        downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!branchTableViewer.getSelection().isEmpty()) {
                    Branch branch = (Branch)((IStructuredSelection)branchTableViewer.getSelection()).getFirstElement();
                    BranchPropertiesPanel.moveBranchDown(branch, BranchPropertiesPanel.this.branches);
                    branchTableViewer.refresh();
                }
            }
        });
        branchTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                upButton.setEnabled(true);
                downButton.setEnabled(true);
                ISelection selection = event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    upButton.setEnabled(false);
                    downButton.setEnabled(false);
                } else {
                    if (BranchPropertiesPanel.this.branches.indexOf(((IStructuredSelection)selection).getFirstElement()) == 0) {
                        upButton.setEnabled(false);
                    }
                    if (BranchPropertiesPanel.this.branches.indexOf(((IStructuredSelection)selection).getFirstElement()) == BranchPropertiesPanel.this.branches.size() - 1) {
                        downButton.setEnabled(false);
                    }
                }
            }
        });
        upButton.setEnabled(true);
        downButton.setEnabled(true);
        ISelection selection = branchTableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            upButton.setEnabled(false);
            downButton.setEnabled(false);
        } else {
            if (this.branches.indexOf(((IStructuredSelection)selection).getFirstElement()) == 0) {
                upButton.setEnabled(false);
            }
            if (this.branches.indexOf(((IStructuredSelection)selection).getFirstElement()) == this.branches.size() - 1) {
                downButton.setEnabled(false);
            }
        }
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public static void moveBranchUp(Branch branch, List<Branch> branches) {
        BranchPropertiesPanel.moveBranch(branch, branches, -1);
    }

    public static void moveBranchDown(Branch branch, List<Branch> branches) {
        BranchPropertiesPanel.moveBranch(branch, branches, 1);
    }

    public static void moveBranch(Branch branch, List<Branch> branches, int distance) {
        int sourceIndex = branches.indexOf(branch);
        int destinationIndex = sourceIndex + distance;
        if (sourceIndex < branches.size() && sourceIndex >= 0 && destinationIndex < branches.size() && destinationIndex >= 0) {
            branches.set(sourceIndex, branches.set(destinationIndex, branch));
        }
    }

    public class BranchTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return BranchPropertiesPanel.this.branches.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class BranchTableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Branch branch = (Branch)element;
            if (columnIndex == 0 && branch.isSecure()) {
                return Activator.getDefault().getImageRegistry().get("ICON_LOCK");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Branch br = (Branch)element;
            if (columnIndex == 0) {
                return "";
            }
            if (columnIndex == 1) {
                return br.getName();
            }
            return br.getExpression();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

