/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.ComparisonInformationProvider;

public class ComparisonPropertiesPanel
extends DesignElementPropertiesPanel {
    static final String lastString = "LastResult";
    ComparisonInformationProvider info = null;
    Text nameField;
    Combo lType;
    TreeViewer lVarTree;
    Text lExprField;
    Combo cType;
    Combo rType;
    TreeViewer rVarTree;
    Text rExprField;
    Button secureLeftButton = null;
    Button secureRightButton = null;
    List<Object> variables = new ArrayList<Object>();

    public ComparisonPropertiesPanel(String name, IDesignElement ppe) {
        super(name, ppe);
        this.info = (ComparisonInformationProvider)((PrimitiveElement)ppe).getInformationProvider();
        List vars = ppe.getDesign().getVariablesFor(ppe);
        block0: for (Variable v : vars) {
            int i = 0;
            while (i < this.variables.size()) {
                Variable cur = (Variable)this.variables.get(i);
                if (cur.getName().compareToIgnoreCase(v.getName()) > 0) {
                    this.variables.add(i, v);
                    continue block0;
                }
                ++i;
            }
            this.variables.add(v);
        }
        int i = 0;
        while (i < this.variables.size()) {
            Variable cur = (Variable)this.variables.get(i);
            if (cur.getName().compareToIgnoreCase(lastString) > 0) {
                this.variables.add(i, lastString);
                break;
            }
            ++i;
        }
    }

    public void createControls(Composite parent) {
        StructuredSelection ss;
        ObjectDefinition od;
        parent.setLayout((Layout)new FillLayout());
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText("Name: ");
        nameLabel.setBackground(comp.getBackground());
        nameLabel.setLayoutData((Object)new GridData(4));
        this.nameField = new Text(comp, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(772));
        Composite builderComp = new Composite(comp, 0);
        builderComp.setBackground(comp.getBackground());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        builderComp.setLayout((Layout)new GridLayout(3, false));
        builderComp.setLayoutData((Object)gd);
        Group lGroup = new Group(builderComp, 32);
        lGroup.setBackground(builderComp.getBackground());
        lGroup.setText("Left-hand Value");
        lGroup.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(1808);
        lGroup.setLayoutData((Object)gd);
        Label lTypeLabel = new Label((Composite)lGroup, 0);
        lTypeLabel.setText("Type:");
        lTypeLabel.setBackground(lGroup.getBackground());
        this.lType = new Combo((Composite)lGroup, 12);
        this.lType.add("Variable");
        this.lType.add("Expression");
        this.lType.select(0);
        final Composite stackComp1 = new Composite((Composite)lGroup, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        stackComp1.setLayoutData((Object)gd);
        final StackLayout sl1 = new StackLayout();
        stackComp1.setLayout((Layout)sl1);
        stackComp1.setBackground(lGroup.getBackground());
        this.lVarTree = new TreeViewer(stackComp1, 2820);
        this.lVarTree.setContentProvider((IContentProvider)new VariableContentProvider());
        this.lVarTree.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.lVarTree.setInput((Object)this);
        sl1.topControl = this.lVarTree.getControl();
        final Composite lEFComp = new Composite(stackComp1, 0);
        lEFComp.setBackground(stackComp1.getBackground());
        lEFComp.setLayout((Layout)new GridLayout(1, false));
        this.lExprField = new Text(lEFComp, 2052);
        this.lExprField.setLayoutData((Object)new GridData(768));
        this.secureLeftButton = new Button(lEFComp, 32);
        this.secureLeftButton.setText("Secure Expression");
        GridData gridData = new GridData(768);
        this.secureLeftButton.setLayoutData((Object)gridData);
        this.secureLeftButton.setSelection(this.info.isLeftSecured());
        this.lType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                sl1.topControl = ComparisonPropertiesPanel.this.lType.getSelectionIndex() == 0 ? ComparisonPropertiesPanel.this.lVarTree.getControl() : lEFComp;
                stackComp1.layout(true, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group cGroup = new Group(builderComp, 0);
        cGroup.setBackground(builderComp.getBackground());
        cGroup.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData();
        gd.verticalAlignment = 128;
        cGroup.setLayoutData((Object)gd);
        Label cTypeLabel = new Label((Composite)cGroup, 0);
        cTypeLabel.setText("Comparison");
        cTypeLabel.setBackground(cGroup.getBackground());
        this.cType = new Combo((Composite)cGroup, 12);
        this.cType.add("Equals (=)");
        this.cType.add("Less Than (<)");
        this.cType.add("Less Than or Equal (<=)");
        this.cType.add("Greater Than (>)");
        this.cType.add("Greater Than or Equal (>=)");
        this.cType.add("Not Equal (!=)");
        this.cType.select(0);
        Group rGroup = new Group(builderComp, 32);
        rGroup.setBackground(builderComp.getBackground());
        rGroup.setText("Right-hand Value");
        rGroup.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(1808);
        rGroup.setLayoutData((Object)gd);
        Label rTypeLabel = new Label((Composite)rGroup, 0);
        rTypeLabel.setText("Type:");
        rTypeLabel.setBackground(rGroup.getBackground());
        this.rType = new Combo((Composite)rGroup, 12);
        this.rType.add("Variable");
        this.rType.add("Expression");
        this.rType.select(0);
        final Composite stackComp2 = new Composite((Composite)rGroup, 0);
        stackComp2.setBackground(rGroup.getBackground());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        stackComp2.setLayoutData((Object)gd);
        final StackLayout sl2 = new StackLayout();
        stackComp2.setLayout((Layout)sl2);
        this.rVarTree = new TreeViewer(stackComp2, 2820);
        this.rVarTree.setContentProvider((IContentProvider)new VariableContentProvider());
        this.rVarTree.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.rVarTree.setInput((Object)this);
        sl2.topControl = this.rVarTree.getControl();
        final Composite rEFComp = new Composite(stackComp2, 0);
        rEFComp.setBackground(stackComp2.getBackground());
        rEFComp.setLayout((Layout)new GridLayout(1, false));
        this.rExprField = new Text(rEFComp, 2052);
        this.rExprField.setLayoutData((Object)new GridData(768));
        this.secureRightButton = new Button(rEFComp, 32);
        this.secureRightButton.setText("Secure Expression");
        gridData = new GridData(768);
        this.secureRightButton.setLayoutData((Object)gridData);
        this.secureRightButton.setSelection(this.info.isRightSecured());
        this.rType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                sl2.topControl = ComparisonPropertiesPanel.this.rType.getSelectionIndex() == 0 ? ComparisonPropertiesPanel.this.rVarTree.getControl() : rEFComp;
                stackComp2.layout(true, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lType.select(this.info.getLType());
        if (this.info.getLType() == 0) {
            if (this.info.getLValue().startsWith(lastString)) {
                if (this.info.getLValue().equals(lastString)) {
                    this.lVarTree.setSelection((ISelection)new StructuredSelection((Object)this.info.getLValue()));
                } else {
                    this.lVarTree.setSelection((ISelection)new StructuredSelection((Object)this.info.getLValue().substring(11)));
                }
            } else {
                od = this.getObjectDefinitionFromVariables(this.info.getLValue());
                ss = od == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)od);
                this.lVarTree.setSelection((ISelection)ss);
            }
        } else {
            this.lExprField.setText(this.info.getLValue());
            sl1.topControl = lEFComp;
            stackComp1.layout(true, true);
        }
        this.cType.select(this.info.getCompType());
        this.rType.select(this.info.getRType());
        if (this.info.getRType() == 0) {
            if (this.info.getRValue().startsWith(lastString)) {
                if (this.info.getRValue().equals(lastString)) {
                    this.rVarTree.setSelection((ISelection)new StructuredSelection((Object)this.info.getRValue()));
                } else {
                    this.rVarTree.setSelection((ISelection)new StructuredSelection((Object)this.info.getRValue().substring(11)));
                }
            } else {
                od = this.getObjectDefinitionFromVariables(this.info.getRValue());
                ss = od == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)od);
                this.rVarTree.setSelection((ISelection)ss);
            }
        } else {
            this.rExprField.setText(this.info.getRValue());
            sl2.topControl = rEFComp;
            stackComp2.layout(true, true);
        }
    }

    public void save() {
        String selString;
        ObjectDefinition objDef;
        Object selObj;
        IStructuredSelection ss;
        ISelection selection;
        this.getElement().setName(this.nameField.getText());
        this.info.setLType(this.lType.getSelectionIndex());
        if (this.info.getLType() == 0) {
            selection = this.lVarTree.getSelection();
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                ss = (IStructuredSelection)selection;
                selObj = ss.getFirstElement();
                if (selObj instanceof ObjectDefinition) {
                    objDef = (ObjectDefinition)selObj;
                    this.info.setLValue(objDef.getPath());
                } else if (selObj instanceof String) {
                    selString = (String)selObj;
                    if (!selString.equals(lastString)) {
                        this.info.setLValue("LastResult." + selString);
                    } else {
                        this.info.setLValue(selString);
                    }
                } else {
                    this.info.setLValue("");
                }
            } else {
                this.info.setLValue("");
            }
        } else {
            this.info.setLValue(this.lExprField.getText());
            this.info.setLeftSecured(this.secureLeftButton.getSelection());
        }
        this.info.setCompType(this.cType.getSelectionIndex());
        this.info.setRType(this.rType.getSelectionIndex());
        if (this.info.getRType() == 0) {
            selection = this.rVarTree.getSelection();
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                ss = (IStructuredSelection)selection;
                selObj = ss.getFirstElement();
                if (selObj instanceof ObjectDefinition) {
                    objDef = (ObjectDefinition)selObj;
                    this.info.setRValue(objDef.getPath());
                } else if (selObj instanceof String) {
                    selString = (String)selObj;
                    if (!selString.equals(lastString)) {
                        this.info.setRValue("LastResult." + selString);
                    } else {
                        this.info.setRValue(selString);
                    }
                } else {
                    this.info.setRValue("");
                }
            } else {
                this.info.setRValue("");
            }
        } else {
            this.info.setRValue(this.rExprField.getText());
            this.info.setRightSecured(this.secureRightButton.getSelection());
        }
    }

    public void cancel() {
    }

    public ObjectDefinition getObjectDefinitionFromVariables(String name) {
        Variable ret = null;
        List vars = this.getElement().getDesign().getVariablesFor(this.getElement());
        int i = 0;
        while (i < vars.size()) {
            Variable v;
            String varName = name;
            boolean sub = false;
            if (name.indexOf(".") != -1) {
                varName = name.substring(0, name.indexOf("."));
                sub = true;
            }
            if ((v = (Variable)vars.get(i)).getName().equals(varName)) {
                if (sub) {
                    ret = this.getObjectDefinitionFromFields(name.substring(name.indexOf(".") + 1), (ObjectDefinition)v);
                } else {
                    ret = v;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public ObjectDefinition getObjectDefinitionFromFields(String name, ObjectDefinition parent) {
        ObjectField ret = null;
        List fields = parent.getFields();
        int i = 0;
        while (i < fields.size()) {
            ObjectField of;
            String varName = name;
            boolean sub = false;
            if (name.indexOf(46) != -1) {
                varName = name.substring(0, name.indexOf("."));
                sub = true;
            }
            if ((of = (ObjectField)fields.get(i)).getName().equals(varName)) {
                if (sub) {
                    ret = this.getObjectDefinitionFromFields(name.substring(name.indexOf(".") + 1), (ObjectDefinition)of);
                } else {
                    ret = of;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    public class VariableContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ObjectDefinition) {
                ObjectDefinition v = (ObjectDefinition)parentElement;
                return v.getFields().toArray();
            }
            if (parentElement instanceof String && ((String)parentElement).equals(ComparisonPropertiesPanel.lastString)) {
                return new String[]{"markname", "marktime", "confidence", "inputmode", "interpretation", "utterance"};
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Variable) {
                return null;
            }
            if (element instanceof String) {
                if (((String)element).equals(ComparisonPropertiesPanel.lastString)) {
                    return null;
                }
                return ComparisonPropertiesPanel.lastString;
            }
            return ((ObjectField)element).getParent();
        }

        public boolean hasChildren(Object element) {
            if (element instanceof String) {
                return ((String)element).equals(ComparisonPropertiesPanel.lastString);
            }
            return ((ObjectDefinition)element).getFields().size() > 0;
        }

        public Object[] getElements(Object inputElement) {
            return ComparisonPropertiesPanel.this.variables.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((ObjectDefinition)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

