/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.IWorkflowExit;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowTraversalHelper;
import org.eclipse.vtp.desktop.model.elements.core.configuration.ExitBinding;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationListener;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.configuration.OutputBinding;
import org.eclipse.vtp.desktop.model.elements.core.configuration.OutputBrandBinding;
import org.eclipse.vtp.desktop.model.elements.core.configuration.OutputItem;
import org.eclipse.vtp.desktop.model.elements.core.internal.ApplicationFragmentElement;

public class FragmentOutputMappingPanel
extends DesignElementPropertiesPanel
implements FragmentConfigurationListener {
    private static final String NOT_USED = "Not Used";
    private static final String INHERIT = "Inherit From Parent";
    private List<IWorkflowExit> returnElements = Collections.emptyList();
    private TableViewer mappingViewer = null;
    private ComboViewer exitCombo = null;
    private List<Variable> vars = null;
    private FragmentConfigurationManager manager = null;
    private IBrand currentBrand = null;
    private ComboBoxViewerCellEditor comboEditor = null;

    public FragmentOutputMappingPanel(String name, IDesignElement element) {
        super(name, element);
        this.manager = (FragmentConfigurationManager)element.getConfigurationManager("org.eclipse.vtp.configuration.include");
        this.manager.addListener((FragmentConfigurationListener)this);
        List inc = element.getDesign().getVariablesFor(element);
        this.vars = new ArrayList<Variable>();
        block0: for (Variable var : inc) {
            if (var.getType().isObject() || var.getType().hasBaseType() && var.getType().isObjectBaseType()) continue;
            int i = 0;
            while (i < this.vars.size()) {
                if (this.vars.get(i).getName().compareToIgnoreCase(var.getName()) > 0) {
                    this.vars.add(i, var);
                    continue block0;
                }
                ++i;
            }
            this.vars.add(var);
        }
        this.entryChanged(this.manager);
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label exitLabel = new Label(comp, 0);
        exitLabel.setText("Exit Point:");
        exitLabel.setLayoutData((Object)new GridData());
        this.exitCombo = new ComboViewer(comp, 12);
        this.exitCombo.setContentProvider((IContentProvider)new ExitContentProvider());
        this.exitCombo.setLabelProvider((IBaseLabelProvider)new ExitLabelProvider());
        this.exitCombo.setInput((Object)this);
        if (this.returnElements.size() > 0) {
            this.exitCombo.setSelection((ISelection)new StructuredSelection((Object)this.returnElements.get(0)));
        }
        this.exitCombo.getControl().setLayoutData((Object)new GridData(768));
        Table mappingTable = new Table(comp, 2052);
        TableColumn outputColumn = new TableColumn(mappingTable, 0);
        outputColumn.setText("Workflow Variable");
        outputColumn.setWidth(150);
        TableColumn targetColumn = new TableColumn(mappingTable, 0);
        targetColumn.setText("Put into the variable");
        targetColumn.setWidth(200);
        mappingTable.setHeaderVisible(true);
        this.mappingViewer = new TableViewer(mappingTable);
        this.mappingViewer.setColumnProperties(new String[]{"Field", "Value"});
        this.mappingViewer.setCellModifier((ICellModifier)new MappingCellModifier());
        this.comboEditor = new ComboBoxViewerCellEditor((Composite)mappingTable);
        this.comboEditor.setContentProvider((IStructuredContentProvider)new VariableContentProvider());
        this.comboEditor.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.comboEditor.setInput((Object)this);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.comboEditor;
        this.mappingViewer.setCellEditors(cellEditorArray);
        this.mappingViewer.setContentProvider((IContentProvider)new MappingContentProvider());
        this.mappingViewer.setLabelProvider((IBaseLabelProvider)new MappingLabelProvider());
        this.mappingViewer.setInput((Object)this);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.mappingViewer.getTable().setLayoutData((Object)gd);
        this.exitCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                FragmentOutputMappingPanel.this.mappingViewer.refresh();
            }
        });
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void save() {
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void setConfigurationContext(Map<String, Object> values) {
        Object obj = values.get("org.eclipse.vtp.desktop.model.core.brandcontext");
        if (obj != null) {
            this.currentBrand = (IBrand)obj;
            this.comboEditor.getViewer().refresh();
            this.mappingViewer.refresh();
        }
    }

    public void entryChanged(FragmentConfigurationManager manager) {
        IWorkflowEntry entry;
        String entryId;
        ApplicationFragmentElement applicationFragmentElement = (ApplicationFragmentElement)this.getElement();
        if (applicationFragmentElement.isModelPresent() && (entryId = manager.getEntryId()) != null && !entryId.equals("") && (entry = applicationFragmentElement.getReferencedModel().getWorkflowEntry(entryId)) != null) {
            ArrayList workingCopies = new ArrayList();
            WorkflowTraversalHelper wth = new WorkflowTraversalHelper(applicationFragmentElement.getReferencedModel(), workingCopies);
            this.returnElements = wth.getDownStreamWorkflowExits(entry);
        }
        LinkedList oldBindings = new LinkedList(manager.getExitBindings());
        for (IWorkflowExit exit : this.returnElements) {
            ExitBinding binding = manager.addExitBinding(exit.getName());
            List oldOutputBindings = binding.getOutputBindings();
            List evs = exit.getExportedVariables();
            for (Variable v : evs) {
                binding.addOutputBinding(v.getName());
            }
            block2: for (OutputBinding outputBinding : oldOutputBindings) {
                for (Variable v : evs) {
                    if (v.getName().equals(outputBinding.getOutput())) continue block2;
                }
                binding.removeOutputBinding(outputBinding);
            }
        }
        block4: for (ExitBinding binding : oldBindings) {
            for (IWorkflowExit exit : this.returnElements) {
                if (exit.getName().equals(binding.getName())) continue block4;
            }
            manager.removeExitBinding(binding.getName());
        }
        if (this.exitCombo != null) {
            this.exitCombo.refresh();
            this.exitCombo.setSelection((ISelection)(this.returnElements.isEmpty() ? null : new StructuredSelection((Object)this.returnElements.get(0))));
        }
    }

    public class ExitContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return FragmentOutputMappingPanel.this.returnElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ExitLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((IWorkflowExit)element).getName();
        }
    }

    public class MappingCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            OutputBinding outputBinding = (OutputBinding)element;
            OutputBrandBinding brandBinding = outputBinding.getBrandBinding(FragmentOutputMappingPanel.this.currentBrand);
            if (brandBinding.isInherited()) {
                if (brandBinding.getBrand().getParent() != null) {
                    return FragmentOutputMappingPanel.INHERIT;
                }
                return FragmentOutputMappingPanel.NOT_USED;
            }
            if (brandBinding.getValue().getValue() == null) {
                return FragmentOutputMappingPanel.NOT_USED;
            }
            int i = 0;
            while (i < FragmentOutputMappingPanel.this.vars.size()) {
                if (((Variable)FragmentOutputMappingPanel.this.vars.get(i)).getName().equals(brandBinding.getValue().getValue())) {
                    return FragmentOutputMappingPanel.this.vars.get(i);
                }
                ++i;
            }
            return 0;
        }

        public void modify(Object element, String property, Object value) {
            OutputBinding outputBinding = (OutputBinding)((TableItem)element).getData();
            OutputBrandBinding brandBinding = outputBinding.getBrandBinding(FragmentOutputMappingPanel.this.currentBrand);
            OutputItem outputItem = brandBinding.getValue();
            if (outputItem == null) {
                outputItem = new OutputItem(null);
            }
            if (value instanceof String) {
                if (value.equals(FragmentOutputMappingPanel.NOT_USED)) {
                    outputItem.setValue(null);
                } else if (value.equals(FragmentOutputMappingPanel.INHERIT)) {
                    outputItem = null;
                }
            } else {
                outputItem.setValue(((Variable)value).getName());
            }
            brandBinding.setValue(outputItem);
            FragmentOutputMappingPanel.this.mappingViewer.refresh();
        }
    }

    public class MappingContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (FragmentOutputMappingPanel.this.returnElements.isEmpty() || FragmentOutputMappingPanel.this.exitCombo.getSelection().isEmpty()) {
                return new Object[0];
            }
            IWorkflowExit retElement = (IWorkflowExit)((IStructuredSelection)FragmentOutputMappingPanel.this.exitCombo.getSelection()).getFirstElement();
            ExitBinding exitBinding = FragmentOutputMappingPanel.this.manager.getExitBinding(retElement.getName());
            List outputBindings = exitBinding.getOutputBindings();
            return outputBindings.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class MappingLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            OutputBinding outputBinding = (OutputBinding)element;
            if (columnIndex == 0) {
                return outputBinding.getOutput();
            }
            if (columnIndex == 1) {
                if (FragmentOutputMappingPanel.this.currentBrand == null) {
                    return "Unknown";
                }
                OutputBrandBinding brandBinding = outputBinding.getBrandBinding(FragmentOutputMappingPanel.this.currentBrand);
                if (brandBinding.isInherited() && brandBinding.getBrand().getParent() != null) {
                    return FragmentOutputMappingPanel.INHERIT;
                }
                if (brandBinding.getValue() == null || brandBinding.getValue().getValue() == null) {
                    return FragmentOutputMappingPanel.NOT_USED;
                }
                return brandBinding.getValue().getValue();
            }
            return "Unknown";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class VariableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (FragmentOutputMappingPanel.this.currentBrand == null) {
                return new Object[0];
            }
            if (FragmentOutputMappingPanel.this.currentBrand.getParent() == null) {
                Object[] ret = new Object[FragmentOutputMappingPanel.this.vars.size() + 1];
                ret[0] = FragmentOutputMappingPanel.NOT_USED;
                int i = 0;
                while (i < FragmentOutputMappingPanel.this.vars.size()) {
                    ret[i + 1] = FragmentOutputMappingPanel.this.vars.get(i);
                    ++i;
                }
                return ret;
            }
            Object[] ret = new Object[FragmentOutputMappingPanel.this.vars.size() + 2];
            ret[0] = FragmentOutputMappingPanel.INHERIT;
            ret[1] = FragmentOutputMappingPanel.NOT_USED;
            int i = 0;
            while (i < FragmentOutputMappingPanel.this.vars.size()) {
                ret[i + 2] = FragmentOutputMappingPanel.this.vars.get(i);
                ++i;
            }
            return ret;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Variable) {
                return ((Variable)element).getName();
            }
            return element.toString();
        }
    }
}

