/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignFolder;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IDesignRootFolder;
import org.eclipse.vtp.desktop.model.core.IWorkflowExit;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.ReturnInformationProvider;

public class ReturnGeneralPropertiesPanel
extends DesignElementPropertiesPanel {
    Label errorField;
    Label nameLabel;
    Text nameField;
    Combo exitTypeCombo;
    List<IWorkflowExit> returnElements = new ArrayList<IWorkflowExit>();
    private ReturnInformationProvider info = null;

    public ReturnGeneralPropertiesPanel(String name, IDesignElement ppe) {
        super(name, ppe);
        this.info = (ReturnInformationProvider)((PrimitiveElement)ppe).getInformationProvider();
        this.returnElements.addAll(ppe.getDesign().getDocument().getWorkflowExits());
        IDesignItemContainer container = ppe.getDesign().getDocument().getParentDesignContainer();
        while (!(container instanceof IDesignRootFolder)) {
            container = (IDesignItemContainer)container.getParent();
        }
        this.traverseDesigns(container);
    }

    private void traverseDesigns(IDesignItemContainer container) {
        List documents = container.getDesignDocuments();
        for (IDesignDocument document : documents) {
            if (document.equals(this.getElement().getDesign().getDocument())) continue;
            this.returnElements.addAll(document.getWorkflowExits());
        }
        List folders = container.getDesignFolders();
        for (IDesignFolder folder : folders) {
            this.traverseDesigns((IDesignItemContainer)folder);
        }
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(2, false));
        this.nameLabel = new Label(comp, 0);
        this.nameLabel.setText("Name: ");
        this.nameLabel.setBackground(comp.getBackground());
        this.nameLabel.setLayoutData((Object)new GridData(4));
        this.nameField = new Text(comp, 2052);
        this.nameField.setLayoutData((Object)new GridData(772));
        this.errorField = new Label(comp, 4);
        this.errorField.setBackground(comp.getBackground());
        this.errorField.setForeground(comp.getDisplay().getSystemColor(3));
        GridData gd = new GridData(832);
        gd.horizontalSpan = 2;
        this.errorField.setLayoutData((Object)gd);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (IWorkflowExit exit : ReturnGeneralPropertiesPanel.this.returnElements) {
                    if (exit.getId().equals(ReturnGeneralPropertiesPanel.this.getElement().getId()) || !exit.getName().equals(ReturnGeneralPropertiesPanel.this.nameField.getText())) continue;
                    ReturnGeneralPropertiesPanel.this.errorField.setText("There is already a Return with that name.");
                    ReturnGeneralPropertiesPanel.this.getContainer().setCanFinish(false);
                    return;
                }
                ReturnGeneralPropertiesPanel.this.errorField.setText("");
                ReturnGeneralPropertiesPanel.this.getContainer().setCanFinish(true);
            }
        });
        this.nameField.setText(this.getElement().getName());
        this.errorField.setText("");
        this.getContainer().setCanFinish(true);
        for (IWorkflowExit exit : this.returnElements) {
            if (exit.getId().equals(this.getElement().getId()) || !exit.getName().equals(this.nameField.getText())) continue;
            this.errorField.setText("There is already a Return with that name.");
            this.getContainer().setCanFinish(false);
            break;
        }
        Label exitTypeLabel = new Label(comp, 0);
        exitTypeLabel.setBackground(comp.getBackground());
        exitTypeLabel.setText("Exit Type:");
        exitTypeLabel.setLayoutData((Object)new GridData());
        this.exitTypeCombo = new Combo(comp, 12);
        this.exitTypeCombo.add("Normal");
        this.exitTypeCombo.add("Error");
        if (this.info.getExitType() != null && this.info.getExitType().equals("Error")) {
            this.exitTypeCombo.select(1);
        } else {
            this.exitTypeCombo.select(0);
        }
        this.setControl((Control)comp);
    }

    public void save() {
        try {
            this.getElement().setName(this.nameField.getText());
            this.info.setExitType(this.exitTypeCombo.getItem(this.exitTypeCombo.getSelectionIndex()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void cancel() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }
}

