/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.automata;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.modules.webservice.ui.automata.Acceptor;
import org.eclipse.vtp.modules.webservice.ui.automata.GraphContext;
import org.eclipse.vtp.modules.webservice.ui.automata.SuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.Suggestor;
import org.eclipse.vtp.modules.webservice.ui.automata.TerminalNode;
import org.eclipse.vtp.modules.webservice.ui.automata.Transition;

public class Node {
    private Acceptor acceptor = null;
    private SuggestionCommand suggestion = null;
    private Transition terminalTransition = null;
    private List<Transition> transitions = new ArrayList<Transition>();

    public Node(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public boolean accept(GraphContext context, Object obj) {
        return this.acceptor == null || this.acceptor.accept(context, obj);
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void addTransition(Transition transition) {
        if (transition.getDestination() instanceof TerminalNode) {
            this.terminalTransition = transition;
        } else {
            this.transitions.add(transition);
        }
    }

    public Transition getTerminalTransition() {
        return this.terminalTransition;
    }

    public void setSuggestion(SuggestionCommand suggestion) {
        this.suggestion = suggestion;
    }

    public void suggest(List<Node> visited, Suggestor suggestor) {
        if (!visited.contains(this)) {
            visited.add(this);
            if (this.suggestion != null) {
                suggestor.suggest(this.suggestion);
            }
        }
    }
}

