/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.automata;

import java.util.List;
import org.eclipse.vtp.modules.webservice.ui.automata.ContainerNode;
import org.eclipse.vtp.modules.webservice.ui.automata.Graph;
import org.eclipse.vtp.modules.webservice.ui.automata.InitialNode;
import org.eclipse.vtp.modules.webservice.ui.automata.Node;
import org.eclipse.vtp.modules.webservice.ui.automata.Realized;
import org.eclipse.vtp.modules.webservice.ui.automata.Suggestor;
import org.eclipse.vtp.modules.webservice.ui.automata.Transition;

public class NonRealizedContainerNode
extends ContainerNode {
    public NonRealizedContainerNode(Graph subGraph) {
        super(null, subGraph);
    }

    @Override
    public void suggest(List<Node> visited, Suggestor suggestor) {
        super.suggest(visited, suggestor);
        if (!visited.contains(this)) {
            InitialNode initialNode = this.getSubGraph().getInitialNode();
            this.traverseSuggestions(visited, initialNode, suggestor);
        }
    }

    private void traverseSuggestions(List<Node> visited, Node node, Suggestor suggestor) {
        List<Transition> subTransitions = node.getTransitions();
        for (Transition t : subTransitions) {
            if (visited.contains(t.getDestination())) continue;
            t.getDestination().suggest(visited, suggestor);
            if (t.getDestination() instanceof Realized) continue;
            this.traverseSuggestions(visited, t.getDestination(), suggestor);
        }
    }
}

