/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.automata;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.schema.AbstractElementObject;
import org.eclipse.vtp.desktop.model.core.schema.ComplexContentModel;
import org.eclipse.vtp.desktop.model.core.schema.ComplexType;
import org.eclipse.vtp.desktop.model.core.schema.ContentModel;
import org.eclipse.vtp.desktop.model.core.schema.ElementGroup;
import org.eclipse.vtp.desktop.model.core.schema.ElementItem;
import org.eclipse.vtp.desktop.model.core.schema.SimpleContentModel;
import org.eclipse.vtp.desktop.model.core.schema.SimpleType;
import org.eclipse.vtp.desktop.model.core.schema.Type;
import org.eclipse.vtp.modules.webservice.ui.automata.Acceptor;
import org.eclipse.vtp.modules.webservice.ui.automata.CCSSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.Command;
import org.eclipse.vtp.modules.webservice.ui.automata.CommandListener;
import org.eclipse.vtp.modules.webservice.ui.automata.ContainerBoundary;
import org.eclipse.vtp.modules.webservice.ui.automata.ContainerBoundaryAcceptor;
import org.eclipse.vtp.modules.webservice.ui.automata.ContainerBoundaryCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.ContainerNode;
import org.eclipse.vtp.modules.webservice.ui.automata.ElementSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.ElseIfSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.ElseSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.ForLoopSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.Graph;
import org.eclipse.vtp.modules.webservice.ui.automata.GraphContext;
import org.eclipse.vtp.modules.webservice.ui.automata.GraphFactory;
import org.eclipse.vtp.modules.webservice.ui.automata.InitialNode;
import org.eclipse.vtp.modules.webservice.ui.automata.Node;
import org.eclipse.vtp.modules.webservice.ui.automata.NonRealizedContainerNode;
import org.eclipse.vtp.modules.webservice.ui.automata.RealizeDocumentItemCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.RealizeElementItemCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.Realized;
import org.eclipse.vtp.modules.webservice.ui.automata.RealizedContainerNode;
import org.eclipse.vtp.modules.webservice.ui.automata.RealizedNode;
import org.eclipse.vtp.modules.webservice.ui.automata.SuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.Suggestor;
import org.eclipse.vtp.modules.webservice.ui.automata.TextSuggestionCommand;
import org.eclipse.vtp.modules.webservice.ui.automata.Transition;
import org.eclipse.vtp.modules.webservice.ui.configuration.InputDocumentStructure;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ConditionalContainerSet;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ConditionalDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.DocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.DocumentItemContainer;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ElementDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ElseDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ForLoopDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.TextDocumentItem;

public class SchemaEngine {
    private Graph baseGraph = null;
    private Type baseType = null;
    private List<EngineContext> contexts = new LinkedList<EngineContext>();
    private List<CommandListener> listeners = new LinkedList<CommandListener>();

    public SchemaEngine(Type type) {
        this.baseType = type;
        this.baseGraph = new TypeGraphFactory(this.baseType).createGraph();
        this.contexts.add(new EngineContext());
    }

    public void processDocumentStructure(InputDocumentStructure structure) {
        this.processDocumentItemContainer(structure);
        System.out.println(this.contexts.size());
        if (this.contexts.size() > 0) {
            ArrayList<Iterator<Command>> contextPointers2 = new ArrayList<Iterator<Command>>(this.contexts.size());
            for (EngineContext context : this.contexts) {
                contextPointers2.add(context.getCommands().iterator());
            }
            while (((Iterator)contextPointers2.get(0)).hasNext()) {
                int i = 0;
                while (i < contextPointers2.size()) {
                    Iterator cp = (Iterator)contextPointers2.get(i);
                    Command cmd = null;
                    while (cp.hasNext() && (cmd = (Command)cp.next()) instanceof SuggestionCommand) {
                        this.postCommand(cmd);
                    }
                    if (i == contextPointers2.size() - 1) {
                        this.postCommand(cmd);
                    }
                    ++i;
                }
            }
        }
    }

    private void processDocumentItemContainer(DocumentItemContainer container) {
        if (container instanceof ConditionalContainerSet) {
            this.processContainerContainerSet((ConditionalContainerSet)container);
            this.postContainerBoundary();
            return;
        }
        List<DocumentItem> items = container.getItems();
        for (DocumentItem item : items) {
            this.postDocumentItem(item);
            if (!(item instanceof DocumentItemContainer)) continue;
            this.processDocumentItemContainer((DocumentItemContainer)item);
        }
        this.postContainerBoundary();
    }

    private void processContainerContainerSet(ConditionalContainerSet container) {
        if (container.getIf() != null) {
            this.postDocumentItem(container.getIf());
            this.processDocumentItemContainer(container.getIf());
            List<ConditionalDocumentItem> elseIfs = container.getElseIfs();
            for (ConditionalDocumentItem elseIf : elseIfs) {
                this.postDocumentItem(elseIf);
                this.processDocumentItemContainer(elseIf);
            }
            if (container.getElse() != null) {
                this.postDocumentItem(container.getElse());
                this.processDocumentItemContainer(container.getElse());
            }
        }
    }

    public void postDocumentItem(DocumentItem item) {
        LinkedList<EngineContext> cs = new LinkedList<EngineContext>(this.contexts);
        this.contexts.clear();
        System.out.println("posting: " + item + " to " + cs.size() + " contexts");
        for (EngineContext context : cs) {
            this.internalPostDocumentItem(context, item);
        }
        if (this.contexts.size() > 0) {
            ArrayList<RealizedCommandIterator> contextPointers = new ArrayList<RealizedCommandIterator>(this.contexts.size());
            for (EngineContext context : this.contexts) {
                contextPointers.add(new RealizedCommandIterator(context.getCommands().iterator()));
            }
            while (((RealizedCommandIterator)contextPointers.get(0)).hasNext()) {
                boolean[] validity = new boolean[contextPointers.size()];
                int i = 0;
                while (i < contextPointers.size()) {
                    RealizeDocumentItemCommand cmd = ((RealizedCommandIterator)contextPointers.get(i)).next();
                    validity[i] = cmd.isValid();
                    ++i;
                }
                boolean allValid = true;
                boolean allInvalid = true;
                int i2 = 0;
                while (i2 < validity.length) {
                    allValid &= validity[i2];
                    allInvalid &= !validity[i2];
                    ++i2;
                }
                if (allValid || allInvalid) continue;
                cs = new LinkedList<EngineContext>(this.contexts);
                ArrayList cps = new ArrayList(contextPointers);
                this.contexts.clear();
                contextPointers.clear();
                int i3 = 0;
                while (i3 < validity.length) {
                    if (validity[i3]) {
                        this.contexts.add((EngineContext)cs.get(i3));
                        contextPointers.add((RealizedCommandIterator)cps.get(i3));
                    }
                    ++i3;
                }
            }
        }
    }

    private void internalPostDocumentItem(EngineContext context, Object item) {
        boolean transitioned = false;
        Node node = context.getCurrentGraphContext().getCurrentNode();
        List<Transition> transitions = node.getTransitions();
        for (Transition transition : transitions) {
            Node destination;
            EngineContext copy = context.clone();
            GraphContext gc = copy.getCurrentGraphContext();
            if (gc.getTransitionCount(transition) >= transition.getMaxTraversals() || !(destination = transition.getDestination()).accept(gc, item)) continue;
            transitioned = true;
            gc.performTransition(transition);
            if (transition.hasSuggestion()) {
                this.performSuggestions(copy, transition);
            }
            if (destination instanceof Realized) {
                RealizeDocumentItemCommand command = null;
                if (item instanceof ElementDocumentItem) {
                    RealizeElementItemCommand elementCommand = new RealizeElementItemCommand((DocumentItem)item, true);
                    ElementAcceptor acceptor = (ElementAcceptor)destination.getAcceptor();
                    elementCommand.setTextOnly(acceptor.isTextOnly());
                    command = elementCommand;
                } else {
                    command = new RealizeDocumentItemCommand((DocumentItem)item, true);
                }
                copy.command(command);
            }
            if (destination instanceof ContainerNode) {
                ContainerNode cn = (ContainerNode)destination;
                GraphContext subContext = new GraphContext(cn.getSubGraph());
                copy.pushGraphContext(subContext);
                if (!(destination instanceof Realized)) {
                    this.internalPostDocumentItem(copy, item);
                    continue;
                }
                this.contexts.add(copy);
                continue;
            }
            this.contexts.add(copy);
        }
        if (!transitioned) {
            Transition transition;
            transition = node.getTerminalTransition();
            Node destination = transition.getDestination();
            if (destination.accept(context.getCurrentGraphContext(), item)) {
                if (transition.hasSuggestion() && !context.getCurrentGraphContext().hasMadeFinalSuggestions()) {
                    this.performSuggestions(context, transition);
                }
                context.popGraphContext();
                if (item instanceof ContainerBoundary && destination.getAcceptor() instanceof ContainerBoundaryAcceptor) {
                    context.command(new ContainerBoundaryCommand());
                }
                if (context.getCurrentGraphContext() != null) {
                    if (!(destination.getAcceptor() instanceof ContainerBoundaryAcceptor)) {
                        this.internalPostDocumentItem(context, item);
                    } else {
                        this.contexts.add(context);
                    }
                } else {
                    this.contexts.add(context);
                }
            } else if (item instanceof ContainerBoundary) {
                context.command(new ContainerBoundaryCommand());
                this.contexts.add(context);
            } else {
                if (!context.getCurrentGraphContext().hasMadeFinalSuggestions()) {
                    context.getCurrentGraphContext().madeFinalSuggestions(true);
                    if (transition.hasSuggestion()) {
                        this.performSuggestions(context, transition);
                    }
                }
                RealizeDocumentItemCommand rdic = null;
                if (item instanceof ElementDocumentItem) {
                    RealizeElementItemCommand elementCommand = new RealizeElementItemCommand((DocumentItem)item, false);
                    rdic = elementCommand;
                } else {
                    rdic = new RealizeDocumentItemCommand((DocumentItem)item, false);
                }
                System.out.println("invalid realized command: " + rdic.getDocumentItem());
                if (item instanceof DocumentItemContainer) {
                    ((ContainerBoundaryAcceptor)destination.getAcceptor()).newContainer(context.getCurrentGraphContext());
                }
                context.command(rdic);
                this.contexts.add(context);
            }
        }
    }

    public void postContainerBoundary() {
        LinkedList<EngineContext> cs = new LinkedList<EngineContext>(this.contexts);
        this.contexts.clear();
        System.out.println("posting container boundary to " + cs.size() + " contexts");
        for (EngineContext context : cs) {
            if (context.getCurrentGraphContext() == null) continue;
            this.internalPostDocumentItem(context, new ContainerBoundary());
        }
    }

    private void performSuggestions(EngineContext context, Transition transition) {
        GraphContext currentContext = context.getCurrentGraphContext();
        Node origin = transition.getOrigin();
        LinkedList<Node> visited = new LinkedList<Node>();
        visited.add(transition.getDestination());
        List<Transition> subTransitions = origin.getTransitions();
        for (Transition t : subTransitions) {
            if (currentContext.getTransitionCount(t) >= t.getMaxTraversals()) continue;
            t.getDestination().suggest(visited, context);
            if (t.getDestination() instanceof Realized) continue;
            this.traverseSuggestions(context, visited, t.getDestination());
        }
    }

    private void traverseSuggestions(Suggestor suggestor, List<Node> visited, Node node) {
        List<Transition> subTransitions = node.getTransitions();
        for (Transition t : subTransitions) {
            t.getDestination().suggest(visited, suggestor);
            if (t.getDestination() instanceof Realized) continue;
            this.traverseSuggestions(suggestor, visited, t.getDestination());
        }
    }

    public void addCommandListener(CommandListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removeCommandListener(CommandListener l) {
        this.listeners.remove(l);
    }

    private void postCommand(Command command) {
        for (CommandListener l : this.listeners) {
            l.proccess(command);
        }
    }

    public class CCSContainerAcceptor
    implements Acceptor {
        @Override
        public boolean accept(GraphContext context, Object obj) {
            return obj instanceof ConditionalContainerSet;
        }
    }

    public class CCSGraphFactory
    implements GraphFactory {
        private GraphFactory contentFactory = null;

        public CCSGraphFactory(GraphFactory contentFactory) {
            this.contentFactory = contentFactory;
        }

        @Override
        public Graph createGraph() {
            Graph ret = new Graph();
            Transition terminalTransition = new Transition(ret.getInitialNode(), ret.getTerminalNode(), true);
            terminalTransition.setValid(false);
            RealizedContainerNode ifContainer = new RealizedContainerNode((Acceptor)new ConditionalContainerAcceptor(), this.contentFactory);
            new Transition(ret.getInitialNode(), ifContainer);
            new Transition(ifContainer, ret.getTerminalNode(), true);
            RealizedContainerNode elseIfContainer = new RealizedContainerNode((Acceptor)new ConditionalContainerAcceptor(), this.contentFactory);
            elseIfContainer.setSuggestion(new ElseIfSuggestionCommand());
            new Transition(ifContainer, elseIfContainer);
            Transition elseIfReentryTransition = new Transition(elseIfContainer, elseIfContainer);
            elseIfReentryTransition.setMaxTraversals(Integer.MAX_VALUE);
            new Transition(elseIfContainer, ret.getTerminalNode(), true);
            RealizedContainerNode elseContainer = new RealizedContainerNode((Acceptor)new ElseContainerAcceptor(), this.contentFactory);
            elseContainer.setSuggestion(new ElseSuggestionCommand());
            new Transition(ifContainer, elseContainer, true);
            new Transition(elseIfContainer, elseContainer, true);
            new Transition(elseContainer, ret.getTerminalNode());
            return ret;
        }
    }

    public class ChoiceContentsGraphFactory
    implements GraphFactory {
        private ElementGroup group = null;

        public ChoiceContentsGraphFactory(ElementGroup group) {
            this.group = group;
        }

        @Override
        public Graph createGraph() {
            Graph ret = new Graph();
            Transition terminalTransition = new Transition(ret.getInitialNode(), ret.getTerminalNode(), true);
            InitialNode originNode = ret.getInitialNode();
            List children = this.group.getElementObjects();
            for (AbstractElementObject child : children) {
                if (child instanceof ElementItem) {
                    NonRealizedContainerNode elementNode = new NonRealizedContainerNode(new ElementGraphFactory((ElementItem)child).createGraph());
                    new Transition(originNode, elementNode);
                    terminalTransition = new Transition(elementNode, ret.getTerminalNode(), true);
                    terminalTransition.setValid(true);
                    continue;
                }
                if (!(child instanceof ElementGroup)) continue;
                NonRealizedContainerNode elementGroupNode = null;
                ElementGroup childGroup = (ElementGroup)child;
                if (childGroup.getType().equals("sequence")) {
                    elementGroupNode = new NonRealizedContainerNode(new SequenceGraphFactory(childGroup).createGraph());
                } else if (childGroup.getType().equals("choice")) {
                    elementGroupNode = new NonRealizedContainerNode(new ChoiceGraphFactory(childGroup).createGraph());
                }
                new Transition(originNode, elementGroupNode);
                terminalTransition = new Transition(elementGroupNode, ret.getTerminalNode(), true);
                terminalTransition.setValid(true);
            }
            return ret;
        }
    }

    public class ChoiceGraphFactory
    implements GraphFactory {
        private ElementGroup group = null;
        private int minOccurs = 1;
        private int maxOccurs = 1;

        public ChoiceGraphFactory(ElementGroup group) {
            this.group = group;
            this.minOccurs = group.getMinOccurs();
            this.maxOccurs = group.getMaxOccurs();
        }

        @Override
        public Graph createGraph() {
            Graph ret = new Graph();
            Transition terminalTransition = new Transition(ret.getInitialNode(), ret.getTerminalNode(), true);
            if (this.minOccurs > 0) {
                terminalTransition.setValid(false);
            }
            if (this.maxOccurs > 1) {
                RealizedContainerNode forContainer = new RealizedContainerNode((Acceptor)new ForContainerAcceptor(), new ChoiceContentsGraphFactory(this.group));
                forContainer.setSuggestion(new ForLoopSuggestionCommand());
                new Transition(ret.getInitialNode(), forContainer);
                new Transition(forContainer, ret.getTerminalNode());
            }
            RealizedContainerNode ccsContainer = new RealizedContainerNode((Acceptor)new CCSContainerAcceptor(), new CCSGraphFactory(this));
            ccsContainer.setSuggestion(new CCSSuggestionCommand());
            new Transition(ret.getInitialNode(), ccsContainer);
            new Transition(ccsContainer, ret.getTerminalNode());
            Node originNode = ret.getInitialNode();
            int i = 0;
            while (i < this.minOccurs - 1) {
                NonRealizedContainerNode elementNode = new NonRealizedContainerNode(new ChoiceContentsGraphFactory(this.group).createGraph());
                new Transition(originNode, elementNode);
                terminalTransition = new Transition(elementNode, ret.getTerminalNode(), true);
                terminalTransition.setValid(false);
                originNode = elementNode;
                ++i;
            }
            NonRealizedContainerNode finalElementNode = new NonRealizedContainerNode(new ChoiceContentsGraphFactory(this.group).createGraph());
            new Transition(originNode, finalElementNode);
            if (this.maxOccurs - this.minOccurs > 1) {
                Transition loopTransition = new Transition(finalElementNode, finalElementNode);
                loopTransition.setMaxTraversals(this.maxOccurs - Math.max(this.minOccurs, 1));
            }
            new Transition(finalElementNode, ret.getTerminalNode(), true);
            return ret;
        }
    }

    public class ConditionalContainerAcceptor
    implements Acceptor {
        @Override
        public boolean accept(GraphContext context, Object obj) {
            return obj instanceof ConditionalDocumentItem;
        }
    }

    public class ElementAcceptor
    implements Acceptor {
        private ElementItem element = null;

        public ElementAcceptor(ElementItem element) {
            this.element = element;
        }

        @Override
        public boolean accept(GraphContext context, Object obj) {
            if (obj instanceof ElementDocumentItem) {
                return ((ElementDocumentItem)obj).getName().equals(this.element.getName());
            }
            return false;
        }

        public boolean isTextOnly() {
            Type type = this.element.getType();
            if (type instanceof SimpleType) {
                return true;
            }
            ComplexType complexType = (ComplexType)type;
            return complexType.getContentModel() instanceof SimpleContentModel;
        }
    }

    public class ElementGraphFactory
    implements GraphFactory {
        private ElementItem element = null;
        private int minOccurs = 1;
        private int maxOccurs = 1;

        public ElementGraphFactory(ElementItem element) {
            this.element = element;
            this.minOccurs = element.getMinOccurs();
            this.maxOccurs = element.getMaxOccurs();
        }

        public ElementGraphFactory(ElementItem element, int overrideMinOccurs, int overrideMaxOccurs) {
            this.element = element;
            this.minOccurs = overrideMinOccurs;
            this.maxOccurs = overrideMaxOccurs;
        }

        @Override
        public Graph createGraph() {
            Graph ret = new Graph();
            Transition terminalTransition = new Transition(ret.getInitialNode(), ret.getTerminalNode(), true);
            if (this.minOccurs > 0) {
                terminalTransition.setValid(false);
            }
            if (this.maxOccurs > 1) {
                RealizedContainerNode forContainer = new RealizedContainerNode((Acceptor)new ForContainerAcceptor(), new ElementGraphFactory(this.element, 1, 1));
                forContainer.setSuggestion(new ForLoopSuggestionCommand());
                new Transition(ret.getInitialNode(), forContainer);
                new Transition(forContainer, ret.getTerminalNode());
            }
            RealizedContainerNode ccsContainer = new RealizedContainerNode((Acceptor)new CCSContainerAcceptor(), new CCSGraphFactory(this));
            ccsContainer.setSuggestion(new CCSSuggestionCommand());
            new Transition(ret.getInitialNode(), ccsContainer);
            new Transition(ccsContainer, ret.getTerminalNode());
            Node originNode = ret.getInitialNode();
            int i = 0;
            while (i < this.minOccurs - 1) {
                RealizedContainerNode elementNode = new RealizedContainerNode((Acceptor)new ElementAcceptor(this.element), new TypeGraphFactory(this.element.getType()));
                ElementSuggestionCommand suggestion = new ElementSuggestionCommand(this.element);
                suggestion.setRequired(true);
                elementNode.setSuggestion(suggestion);
                new Transition(originNode, elementNode);
                terminalTransition = new Transition(elementNode, ret.getTerminalNode(), true);
                terminalTransition.setValid(false);
                originNode = elementNode;
                ++i;
            }
            RealizedContainerNode finalElementNode = new RealizedContainerNode((Acceptor)new ElementAcceptor(this.element), new TypeGraphFactory(this.element.getType()));
            ElementSuggestionCommand suggestion = new ElementSuggestionCommand(this.element);
            suggestion.setRequired(this.minOccurs > 0);
            finalElementNode.setSuggestion(suggestion);
            new Transition(originNode, finalElementNode);
            if (this.maxOccurs - this.minOccurs > 1) {
                Transition loopTransition = new Transition(finalElementNode, finalElementNode);
                loopTransition.setMaxTraversals(this.maxOccurs - Math.max(this.minOccurs, 1));
            }
            new Transition(finalElementNode, ret.getTerminalNode(), true);
            return ret;
        }
    }

    public class ElseContainerAcceptor
    implements Acceptor {
        @Override
        public boolean accept(GraphContext context, Object obj) {
            return obj instanceof ElseDocumentItem;
        }
    }

    public class EngineContext
    implements Suggestor {
        private Deque<GraphContext> graphContexts = new ArrayDeque<GraphContext>();
        private List<Command> commands = new LinkedList<Command>();

        public EngineContext() {
            this.graphContexts.offerLast(new GraphContext(SchemaEngine.this.baseGraph));
        }

        public GraphContext getCurrentGraphContext() {
            return this.graphContexts.peekLast();
        }

        public void pushGraphContext(GraphContext context) {
            this.graphContexts.offerLast(context);
        }

        public void popGraphContext() {
            this.graphContexts.removeLast();
        }

        @Override
        public void suggest(SuggestionCommand suggestion) {
            this.commands.add(suggestion);
        }

        public void command(Command command) {
            this.commands.add(command);
        }

        public List<Command> getCommands() {
            return this.commands;
        }

        public EngineContext clone() {
            EngineContext copy = new EngineContext();
            copy.graphContexts.clear();
            for (GraphContext context : this.graphContexts) {
                copy.graphContexts.offerLast(context.clone());
            }
            copy.commands.addAll(this.commands);
            return copy;
        }
    }

    public class ForContainerAcceptor
    implements Acceptor {
        @Override
        public boolean accept(GraphContext context, Object obj) {
            return obj instanceof ForLoopDocumentItem;
        }
    }

    public class RealizedCommandIterator
    implements Iterator<RealizeDocumentItemCommand> {
        Iterator<Command> base = null;
        RealizeDocumentItemCommand next = null;

        public RealizedCommandIterator(Iterator<Command> base) {
            this.base = base;
            while (base.hasNext()) {
                Command cmd = base.next();
                if (!(cmd instanceof RealizeDocumentItemCommand)) continue;
                this.next = (RealizeDocumentItemCommand)cmd;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public RealizeDocumentItemCommand next() {
            RealizeDocumentItemCommand ret = this.next;
            this.next = null;
            while (this.base.hasNext()) {
                Command cmd = this.base.next();
                if (!(cmd instanceof RealizeDocumentItemCommand)) continue;
                this.next = (RealizeDocumentItemCommand)cmd;
                break;
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class SequenceContentsGraphFactory
    implements GraphFactory {
        private ElementGroup group = null;

        public SequenceContentsGraphFactory(ElementGroup group) {
            this.group = group;
        }

        @Override
        public Graph createGraph() {
            Graph ret = new Graph();
            Transition terminalTransition = new Transition(ret.getInitialNode(), ret.getTerminalNode(), true);
            Node originNode = ret.getInitialNode();
            List children = this.group.getElementObjects();
            for (AbstractElementObject child : children) {
                if (child instanceof ElementItem) {
                    NonRealizedContainerNode elementNode = new NonRealizedContainerNode(new ElementGraphFactory((ElementItem)child).createGraph());
                    new Transition(originNode, elementNode);
                    terminalTransition = new Transition(elementNode, ret.getTerminalNode(), true);
                    terminalTransition.setValid(false);
                    originNode = elementNode;
                    continue;
                }
                if (!(child instanceof ElementGroup)) continue;
                NonRealizedContainerNode elementGroupNode = null;
                ElementGroup childGroup = (ElementGroup)child;
                if (childGroup.getType().equals("sequence")) {
                    elementGroupNode = new NonRealizedContainerNode(new SequenceGraphFactory(childGroup).createGraph());
                } else if (childGroup.getType().equals("choice")) {
                    elementGroupNode = new NonRealizedContainerNode(new ChoiceGraphFactory(childGroup).createGraph());
                }
                new Transition(originNode, elementGroupNode);
                terminalTransition = new Transition(elementGroupNode, ret.getTerminalNode(), true);
                terminalTransition.setValid(false);
                originNode = elementGroupNode;
            }
            return ret;
        }
    }

    public class SequenceGraphFactory
    implements GraphFactory {
        private ElementGroup group = null;
        private int minOccurs = 1;
        private int maxOccurs = 1;

        public SequenceGraphFactory(ElementGroup group) {
            this.group = group;
            this.minOccurs = group.getMinOccurs();
            this.maxOccurs = group.getMaxOccurs();
        }

        @Override
        public Graph createGraph() {
            Graph ret = new Graph();
            Transition terminalTransition = new Transition(ret.getInitialNode(), ret.getTerminalNode(), true);
            if (this.minOccurs > 0) {
                terminalTransition.setValid(false);
            }
            if (this.maxOccurs > 1) {
                RealizedContainerNode forContainer = new RealizedContainerNode((Acceptor)new ForContainerAcceptor(), new SequenceContentsGraphFactory(this.group));
                forContainer.setSuggestion(new ForLoopSuggestionCommand());
                new Transition(ret.getInitialNode(), forContainer);
                new Transition(forContainer, ret.getTerminalNode());
            }
            RealizedContainerNode ccsContainer = new RealizedContainerNode((Acceptor)new CCSContainerAcceptor(), new CCSGraphFactory(this));
            ccsContainer.setSuggestion(new CCSSuggestionCommand());
            new Transition(ret.getInitialNode(), ccsContainer);
            new Transition(ccsContainer, ret.getTerminalNode());
            Node originNode = ret.getInitialNode();
            int i = 0;
            while (i < this.minOccurs - 1) {
                NonRealizedContainerNode elementNode = new NonRealizedContainerNode(new SequenceContentsGraphFactory(this.group).createGraph());
                new Transition(originNode, elementNode);
                terminalTransition = new Transition(elementNode, ret.getTerminalNode(), true);
                terminalTransition.setValid(false);
                originNode = elementNode;
                ++i;
            }
            NonRealizedContainerNode finalElementNode = new NonRealizedContainerNode(new SequenceContentsGraphFactory(this.group).createGraph());
            new Transition(originNode, finalElementNode);
            if (this.maxOccurs - this.minOccurs > 1) {
                Transition loopTransition = new Transition(finalElementNode, finalElementNode, true);
                loopTransition.setMaxTraversals(this.maxOccurs - Math.max(this.minOccurs, 1));
            }
            new Transition(finalElementNode, ret.getTerminalNode());
            return ret;
        }
    }

    public class TextContentAcceptor
    implements Acceptor {
        @Override
        public boolean accept(GraphContext context, Object obj) {
            return obj instanceof TextDocumentItem;
        }
    }

    public class TypeGraphFactory
    implements GraphFactory {
        private Type type = null;

        public TypeGraphFactory(Type type) {
            this.type = type;
        }

        @Override
        public Graph createGraph() {
            TextSuggestionCommand suggestion = new TextSuggestionCommand();
            suggestion.setRequired(true);
            if (this.type instanceof SimpleType) {
                Graph ret = new Graph();
                Transition terminalTransition = new Transition(ret.getInitialNode(), ret.getTerminalNode(), true);
                ret.getTerminalNode().setAcceptor(new ContainerBoundaryAcceptor());
                RealizedNode textNode = new RealizedNode(new TextContentAcceptor());
                textNode.setSuggestion(suggestion);
                new Transition(ret.getInitialNode(), textNode);
                new Transition(textNode, ret.getTerminalNode());
                return ret;
            }
            ComplexType complexType = (ComplexType)this.type;
            ContentModel contentModel = complexType.getContentModel();
            if (contentModel instanceof SimpleContentModel) {
                Graph ret = new Graph();
                Transition terminalTransition = new Transition(ret.getInitialNode(), ret.getTerminalNode(), true);
                ret.getTerminalNode().setAcceptor(new ContainerBoundaryAcceptor());
                RealizedNode textNode = new RealizedNode(new TextContentAcceptor());
                textNode.setSuggestion(suggestion);
                new Transition(ret.getInitialNode(), textNode);
                new Transition(textNode, ret.getTerminalNode());
                return ret;
            }
            Graph ret = null;
            ComplexContentModel ccm = (ComplexContentModel)contentModel;
            ElementGroup group = ccm.getElementGroup();
            if (group.getType().equals("sequence")) {
                ret = new SequenceGraphFactory(group).createGraph();
            } else if (group.getType().equals("choice")) {
                ret = new ChoiceGraphFactory(group).createGraph();
            }
            ret.getTerminalNode().setAcceptor(new ContainerBoundaryAcceptor());
            return ret;
        }
    }
}

