/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.configuration;

import java.io.PrintStream;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.modules.webservice.ui.configuration.BindingValue;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceBindingManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BrandBinding {
    private WebserviceBindingManager manager = null;
    private IBrand brand = null;
    private BindingValue bindingItem = null;
    private BrandBinding parentBinding = null;

    public BrandBinding(WebserviceBindingManager manager, IBrand brand) {
        this.manager = manager;
        this.brand = brand;
    }

    public WebserviceBindingManager getManager() {
        return this.manager;
    }

    public IBrand getBrand() {
        return this.brand;
    }

    public void setParent(BrandBinding parentBinding) {
        this.parentBinding = parentBinding;
    }

    public boolean hasParent() {
        return this.parentBinding != null;
    }

    public boolean isInherited() {
        return this.bindingItem == null;
    }

    public BindingValue getBindingItem() {
        if (this.bindingItem == null && this.parentBinding != null) {
            return this.parentBinding.getBindingItem();
        }
        return this.bindingItem;
    }

    public void setBindingItem(BindingValue bindingItem) {
        this.bindingItem = bindingItem;
    }

    public void readConfiguration(Element brandBindingElement) {
        NodeList bindingItemElementList = brandBindingElement.getElementsByTagName("binding-value");
        if (bindingItemElementList.getLength() > 0) {
            Element bindingItemElement = (Element)bindingItemElementList.item(0);
            BindingValue bindingItem = new BindingValue();
            bindingItem.readConfiguration(bindingItemElement);
            this.bindingItem = bindingItem;
        }
    }

    public void writeConfiguration(Element brandBindingElement) {
        if (this.bindingItem != null) {
            Element bindingItemElement = brandBindingElement.getOwnerDocument().createElement("binding-value");
            brandBindingElement.appendChild(bindingItemElement);
            this.bindingItem.writeConfiguration(bindingItemElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[IBrand Binding] " + this.brand.getName() + "(" + this.brand.getId() + ")");
        out.println("Binding Value " + this.bindingItem);
    }
}

