/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.configuration;

import java.util.List;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;

public class OutputBinding {
    private String variableName = "";
    private boolean process = true;
    private String scriptText = "";

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean shouldProcess() {
        return this.process;
    }

    public void setShouldProcess(boolean process) {
        this.process = process;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public void readConfiguration(Element configuration) {
        this.variableName = configuration.getAttribute("variable-name");
        String processString = configuration.getAttribute("should-process");
        this.process = !processString.equalsIgnoreCase("false");
        List scriptElementList = XMLUtilities.getElementsByTagName((Element)configuration, (String)"script", (boolean)true);
        if (scriptElementList.size() > 0) {
            this.scriptText = XMLUtilities.getElementTextDataNoEx((Element)((Element)scriptElementList.get(0)), (boolean)true);
            if (this.scriptText == null) {
                this.scriptText = "";
            }
        }
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("variable-name", this.variableName);
        configuration.setAttribute("should-process", Boolean.toString(this.process));
        Element scriptElement = configuration.getOwnerDocument().createElement("script");
        configuration.appendChild(scriptElement);
        scriptElement.setTextContent(this.scriptText);
    }
}

