/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.configuration;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationException;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.modules.webservice.ui.configuration.InputDocumentStructure;
import org.eclipse.vtp.modules.webservice.ui.configuration.OutputBinding;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceServiceBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebserviceBindingManager
implements ConfigurationManager {
    public static final String TYPE_ID = "org.eclipse.vtp.configuration.webservicecall";
    public static final String XML_VERSION = "1.0.0";
    private IDesign design = null;
    private WebserviceServiceBinding serviceBinding = null;
    private InputDocumentStructure documentStructure = null;
    private OutputBinding outputBinding = null;

    public WebserviceBindingManager(IDesign design) {
        this.design = design;
        this.serviceBinding = new WebserviceServiceBinding();
        this.documentStructure = new InputDocumentStructure(this);
        this.outputBinding = new OutputBinding();
    }

    public String getType() {
        return TYPE_ID;
    }

    public String getXMLVersion() {
        return XML_VERSION;
    }

    public BrandManager getBrandManager() {
        return this.design.getDocument().getProject().getBrandManager();
    }

    public WebserviceServiceBinding getServiceBinding() {
        return this.serviceBinding;
    }

    public InputDocumentStructure getInputDocumentStructure() {
        return this.documentStructure;
    }

    public OutputBinding getOutputBinding() {
        return this.outputBinding;
    }

    public void readConfiguration(Element configuration) throws ConfigurationException {
        List outputElementList;
        List documentStructureElementList;
        List serviceBindingElementList = XMLUtilities.getElementsByTagName((Element)configuration, (String)"service-binding", (boolean)true);
        if (serviceBindingElementList.size() > 0) {
            this.serviceBinding.readConfiguration((Element)serviceBindingElementList.get(0));
        }
        if ((documentStructureElementList = XMLUtilities.getElementsByTagName((Element)configuration, (String)"input-document-structure", (boolean)true)).size() > 0) {
            this.documentStructure.readConfiguration((Element)documentStructureElementList.get(0));
        }
        if ((outputElementList = XMLUtilities.getElementsByTagName((Element)configuration, (String)"output-binding", (boolean)true)).size() > 0) {
            this.outputBinding.readConfiguration((Element)outputElementList.get(0));
        }
    }

    public void writeConfiguration(Element configuration) {
        Element serviceBindingElement = configuration.getOwnerDocument().createElementNS(null, "service-binding");
        configuration.appendChild(serviceBindingElement);
        this.serviceBinding.writeConfiguration(serviceBindingElement);
        Element documentStructureElement = this.documentStructure.createConfigurationElement(configuration);
        this.documentStructure.writeConfiguration(documentStructureElement);
        Element outputBindingElement = configuration.getOwnerDocument().createElementNS(null, "output-binding");
        configuration.appendChild(outputBindingElement);
        this.outputBinding.writeConfiguration(outputBindingElement);
    }

    public Object clone() {
        WebserviceBindingManager copy = new WebserviceBindingManager(this.design);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            factory.setNamespaceAware(true);
            Document document = builder.getDOMImplementation().createDocument(null, "temporary-document", null);
            Element rootElement = document.getDocumentElement();
            rootElement.setAttribute("xml-version", XML_VERSION);
            this.writeConfiguration(rootElement);
            copy.readConfiguration(rootElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return copy;
    }
}

