/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.configuration.document;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.modules.webservice.ui.configuration.BrandBinding;
import org.eclipse.vtp.modules.webservice.ui.configuration.BrandedBinding;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceBindingManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ElementAttributeDocumentItem
implements BrandedBinding {
    private String name = null;
    private boolean optional = false;
    private boolean present = true;
    private WebserviceBindingManager manager = null;
    private Map<String, BrandBinding> brandBindings = new TreeMap<String, BrandBinding>();

    public ElementAttributeDocumentItem(WebserviceBindingManager manager) {
        this.manager = manager;
        BrandManager brandManager = manager.getBrandManager();
        IBrand defaultBrand = brandManager.getDefaultBrand();
        this.createBrandBinding(defaultBrand);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
        if (!optional) {
            this.present = true;
        }
    }

    public boolean isPresent() {
        return this.present;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    @Override
    public BrandBinding getBrandBinding(IBrand brand) {
        return this.brandBindings.get(brand.getId());
    }

    public void readConfiguration(Element attributeItemElement) {
        this.name = attributeItemElement.getAttribute("name");
        this.optional = attributeItemElement.getAttribute("optional").equals("true");
        this.present = !attributeItemElement.getAttribute("present").equals("false");
        NodeList brandBindingElementList = attributeItemElement.getElementsByTagName("brand-binding");
        int i = 0;
        while (i < brandBindingElementList.getLength()) {
            Element brandBindingElement = (Element)brandBindingElementList.item(i);
            String brandId = brandBindingElement.getAttribute("id");
            BrandBinding brandBinding = this.brandBindings.get(brandId);
            if (brandBinding != null) {
                brandBinding.readConfiguration(brandBindingElement);
            }
            ++i;
        }
    }

    public void writeConfiguration(Element attributeItemElement) {
        attributeItemElement.setAttribute("name", this.name);
        attributeItemElement.setAttribute("optional", this.optional ? "true" : "false");
        attributeItemElement.setAttribute("present", this.present ? "true" : "false");
        for (BrandBinding brandBinding : this.brandBindings.values()) {
            if (brandBinding.isInherited()) continue;
            Element brandBindingElement = attributeItemElement.getOwnerDocument().createElementNS(null, "brand-binding");
            attributeItemElement.appendChild(brandBindingElement);
            brandBindingElement.setAttribute("id", brandBinding.getBrand().getId());
            brandBindingElement.setAttribute("name", brandBinding.getBrand().getName());
            brandBinding.writeConfiguration(brandBindingElement);
        }
    }

    public void dumpContents(PrintStream out) {
        out.println("[Attribute Item] " + this.name);
        out.println("IBrand Bindings");
        for (BrandBinding brandBinding : this.brandBindings.values()) {
            brandBinding.dumpContents(out);
        }
    }

    private BrandBinding createBrandBinding(IBrand brand) {
        BrandBinding brandBinding = new BrandBinding(this.manager, brand);
        this.brandBindings.put(brand.getId(), brandBinding);
        List children = brand.getChildBrands();
        for (IBrand child : children) {
            BrandBinding bindingChild = this.createBrandBinding(child);
            bindingChild.setParent(brandBinding);
        }
        return brandBinding;
    }
}

