/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.configuration.document;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceBindingManager;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.DocumentItemContainer;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ElementAttributeDocumentItem;
import org.w3c.dom.Element;

public class ElementDocumentItem
extends DocumentItemContainer {
    private String name = null;
    private String namespace = null;
    private boolean simple = false;
    private List<ElementAttributeDocumentItem> attributes = new ArrayList<ElementAttributeDocumentItem>();

    public ElementDocumentItem(WebserviceBindingManager manager) {
        super(manager);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public List<ElementAttributeDocumentItem> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(ElementAttributeDocumentItem attribute) {
        this.attributes.remove(attribute);
        this.attributes.add(attribute);
    }

    public void removeAttribute(ElementAttributeDocumentItem attribute) {
        this.attributes.remove(attribute);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public Element createConfigurationElement(Element parentElement) {
        Element elementItemElement = parentElement.getOwnerDocument().createElementNS(null, "element-item");
        parentElement.appendChild(elementItemElement);
        return elementItemElement;
    }

    @Override
    public void readConfiguration(Element elementItemElement) {
        this.name = elementItemElement.getAttribute("name");
        this.namespace = elementItemElement.getAttribute("namespace");
        this.simple = elementItemElement.getAttribute("simple").equals("true");
        List attributeContainerElementList = XMLUtilities.getElementsByTagName((Element)elementItemElement, (String)"attributes", (boolean)true);
        if (attributeContainerElementList.size() > 0) {
            Element attributeContainerElement = (Element)attributeContainerElementList.get(0);
            List attributeElementList = XMLUtilities.getElementsByTagName((Element)attributeContainerElement, (String)"attribute", (boolean)true);
            for (Element attributeElement : attributeElementList) {
                ElementAttributeDocumentItem attribute = new ElementAttributeDocumentItem(this.getManager());
                attribute.readConfiguration(attributeElement);
                this.attributes.add(attribute);
            }
        }
        super.readConfiguration(elementItemElement);
    }

    @Override
    public void writeConfiguration(Element elementItemElement) {
        elementItemElement.setAttribute("name", this.name);
        elementItemElement.setAttribute("namespace", this.namespace);
        elementItemElement.setAttribute("simple", this.simple ? "true" : "false");
        Element attributesElement = elementItemElement.getOwnerDocument().createElementNS(null, "attributes");
        elementItemElement.appendChild(attributesElement);
        for (ElementAttributeDocumentItem attribute : this.attributes) {
            Element attributeElement = attributesElement.getOwnerDocument().createElementNS(null, "attribute");
            attributesElement.appendChild(attributeElement);
            attribute.writeConfiguration(attributeElement);
        }
        super.writeConfiguration(elementItemElement);
    }

    @Override
    public void dumpContents(PrintStream out) {
        out.println("[Element Item: " + this.name + "]");
        super.dumpContents(out);
    }
}

