/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.configuration.document;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.modules.webservice.ui.configuration.BrandBinding;
import org.eclipse.vtp.modules.webservice.ui.configuration.BrandedBinding;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceBindingManager;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.DocumentItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TextDocumentItem
extends DocumentItem
implements BrandedBinding {
    private Map<String, BrandBinding> brandBindings = new TreeMap<String, BrandBinding>();

    public TextDocumentItem(WebserviceBindingManager manager) {
        super(manager);
        BrandManager brandManager = manager.getBrandManager();
        IBrand defaultBrand = brandManager.getDefaultBrand();
        this.createBrandBinding(defaultBrand);
    }

    @Override
    public BrandBinding getBrandBinding(IBrand brand) {
        return this.brandBindings.get(brand.getId());
    }

    @Override
    public void readConfiguration(Element textItemElement) {
        NodeList brandBindingElementList = textItemElement.getElementsByTagName("brand-binding");
        int i = 0;
        while (i < brandBindingElementList.getLength()) {
            Element brandBindingElement = (Element)brandBindingElementList.item(i);
            String brandId = brandBindingElement.getAttribute("id");
            BrandBinding brandBinding = this.brandBindings.get(brandId);
            if (brandBinding != null) {
                brandBinding.readConfiguration(brandBindingElement);
            }
            ++i;
        }
    }

    @Override
    public void writeConfiguration(Element textItemElement) {
        for (BrandBinding brandBinding : this.brandBindings.values()) {
            if (brandBinding.isInherited()) continue;
            Element brandBindingElement = textItemElement.getOwnerDocument().createElementNS(null, "brand-binding");
            textItemElement.appendChild(brandBindingElement);
            brandBindingElement.setAttribute("id", brandBinding.getBrand().getId());
            brandBindingElement.setAttribute("name", brandBinding.getBrand().getName());
            brandBinding.writeConfiguration(brandBindingElement);
        }
    }

    @Override
    public void dumpContents(PrintStream out) {
        out.println("[Text Item]");
        out.println("IBrand Bindings");
        for (BrandBinding brandBinding : this.brandBindings.values()) {
            brandBinding.dumpContents(out);
        }
    }

    private BrandBinding createBrandBinding(IBrand brand) {
        BrandBinding brandBinding = new BrandBinding(this.getManager(), brand);
        this.brandBindings.put(brand.getId(), brandBinding);
        List children = brand.getChildBrands();
        for (IBrand child : children) {
            BrandBinding bindingChild = this.createBrandBinding(child);
            bindingChild.setParent(brandBinding);
        }
        return brandBinding;
    }

    @Override
    public Element createConfigurationElement(Element parentElement) {
        Element textElement = parentElement.getOwnerDocument().createElementNS(null, "text-item");
        parentElement.appendChild(textElement);
        return textElement;
    }
}

