/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.export;

import java.util.List;
import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IFlowElement;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceConfiguration;
import org.w3c.dom.Element;

public class WebserviceConfigurationExporter
implements IConfigurationExporter {
    public void exportConfiguration(IFlowElement flowElement, Element actionElement) {
        Element baseConfigurationElement = flowElement.getConfiguration();
        WebServiceConfiguration wsconfig = new WebServiceConfiguration();
        List managedConfigurationElementList = XMLUtilities.getElementsByTagName((Element)baseConfigurationElement, (String)"managed-config", (boolean)true);
        for (Element managedConfigurationElement : managedConfigurationElementList) {
            List outputElementList;
            List documentStructureElementList;
            if (!"org.eclipse.vtp.configuration.webservicecall".equals(managedConfigurationElement.getAttribute("type"))) continue;
            List serviceBindingElementList = XMLUtilities.getElementsByTagName((Element)managedConfigurationElement, (String)"service-binding", (boolean)true);
            if (serviceBindingElementList.size() > 0) {
                wsconfig.setServiceType("soap");
                Element serviceBindingElement = (Element)serviceBindingElementList.get(0);
                wsconfig.setURL("static", serviceBindingElement.getAttribute("url"));
                wsconfig.setSoapAction("static", serviceBindingElement.getAttribute("soap-action"));
            }
            if ((documentStructureElementList = XMLUtilities.getElementsByTagName((Element)managedConfigurationElement, (String)"input-document-structure", (boolean)true)).size() > 0) {
                Element inputStructureElement = (Element)documentStructureElementList.get(0);
                wsconfig.getInputStructure().readConfiguration(inputStructureElement);
            }
            if ((outputElementList = XMLUtilities.getElementsByTagName((Element)managedConfigurationElement, (String)"output-binding", (boolean)true)).size() <= 0) continue;
            Element outputElement = (Element)outputElementList.get(0);
            wsconfig.setVariableName(outputElement.getAttribute("variable-name"));
            wsconfig.setShouldProcess("true".equals(outputElement.getAttribute("should-process")));
            wsconfig.setOutputScriptText(XMLUtilities.getElementTextDataNoEx((Element)outputElement, (boolean)true));
        }
        Element configElement = actionElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/webservices/configurations", "webservice:call");
        wsconfig.save(configElement);
        actionElement.appendChild(configElement);
    }

    public String getActionId(IFlowElement flowElement) {
        return "org.eclipse.vtp.framework.webservices.actions.webservice-call";
    }

    public String getDefaultPath(IFlowElement flowElement) {
        return "Continue";
    }

    public String translatePath(IFlowElement flowElement, String uiPath) {
        return uiPath;
    }

    public String getTargetId(IFlowElement flowElement, Element afterTransitionElement) {
        return flowElement.getDefaultTargetId(afterTransitionElement);
    }

    public boolean isEntryPoint(IFlowElement flowElement) {
        return false;
    }
}

