/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.properties;

import java.util.ArrayList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RowColorPainter
implements PaintListener {
    private Color accentColor = null;

    public RowColorPainter(Color accentColor) {
        this.accentColor = accentColor;
    }

    public void paintControl(PaintEvent e) {
        Composite container;
        Object obj = e.getSource();
        if (obj instanceof Composite && (container = (Composite)obj).getLayout() instanceof GridLayout) {
            Control[] children;
            GridLayout layout = (GridLayout)container.getLayout();
            Control[] controlArray = children = container.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control.getLayoutData() instanceof GridData && ((GridData)control.getLayoutData()).verticalSpan > 1) {
                    System.err.println("Vertical spans not supported");
                    return;
                }
                ++n2;
            }
            ArrayList<Integer> rowHeights = new ArrayList<Integer>();
            int curX = 0;
            int rowTop = Integer.MAX_VALUE;
            int rowBottom = 0;
            Control[] controlArray2 = children;
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                Control control = controlArray2[n4];
                Point location = control.getLocation();
                Point size = control.getSize();
                if (location.x < curX) {
                    curX = location.x;
                    rowHeights.add(rowBottom - rowTop);
                    rowTop = Integer.MAX_VALUE;
                    rowBottom = 0;
                }
                if (location.y < rowTop) {
                    rowTop = location.y;
                }
                if (location.y + size.y > rowBottom) {
                    rowBottom = location.y + size.y;
                }
                ++n4;
            }
            if (rowBottom - rowTop > 0) {
                rowHeights.add(rowBottom - rowTop);
            }
            int curY = layout.marginHeight + layout.marginTop - layout.verticalSpacing / 2;
            GC g = e.gc;
            Color oldBackground = g.getBackground();
            g.setBackground(this.accentColor);
            int remainder = rowHeights.size() % 2;
            int i = 0;
            while (i < rowHeights.size()) {
                int totalHeight = (Integer)rowHeights.get(i) + layout.verticalSpacing;
                if ((i + 1) % 2 == remainder) {
                    g.fillRectangle(layout.marginWidth + layout.marginLeft, curY, container.getSize().x - layout.marginWidth - layout.marginLeft - layout.marginWidth - layout.marginRight, totalHeight);
                }
                curY += totalHeight;
                ++i;
            }
            g.setBackground(oldBackground);
        }
    }
}

