/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.catalog.registry;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.vtp.catalog.internal.CatalogPlugin;
import org.eclipse.vtp.catalog.registry.CatalogEntry;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;

public class CatalogDefaultResolver {
    public static final String CCXML_ID = "org.eclipse.vtp.editor.ccxml.core.ccxmlsource";
    public static final String SRGS_ID = "org.eclipse.vtp.editor.srgxml.core.srgxmlsource";
    public static final String VXML_ID = "org.eclipse.vtp.editor.vxml.core.vxmlsource";
    public static final String VERSION = "_version";

    public static String getVersionFromPublicIdentifier(String identifier) {
        int begin = -1;
        int end = -1;
        if (identifier == null || identifier.length() < 7) {
            return null;
        }
        begin = identifier.indexOf("//");
        if (begin == -1) {
            return null;
        }
        if ((begin = identifier.indexOf("//", begin + 1)) == -1) {
            return null;
        }
        end = identifier.indexOf("//", begin + 1);
        if (end == -1) {
            return null;
        }
        String display = identifier.substring(begin + "//".length(), end);
        StringTokenizer displayTokens = new StringTokenizer(display);
        while (displayTokens.hasMoreTokens()) {
            String token = displayTokens.nextToken();
            try {
                new Double(token);
                return token;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected static String loadPreferenceStoreDefault(String contentTypeId) {
        IPreferenceStore store = CatalogPlugin.getDefault().getPreferenceStore();
        if (contentTypeId == null || store == null) {
            return new String();
        }
        return store.getString(contentTypeId);
    }

    protected static String loadPreferenceStoreDefaultVersion(String contentTypeId) {
        IPreferenceStore store = CatalogPlugin.getDefault().getPreferenceStore();
        if (store == null) {
            return new String();
        }
        return store.getString(String.valueOf(contentTypeId) + VERSION);
    }

    public static String loadExtensionPointDefaultEntry(String id) {
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.vtp.catalog.language");
        if (iep == null) {
            return new String();
        }
        IExtension[] extensions = iep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String contentTypeId = elements[j].getAttribute("contentTypeId");
                String publicKey = elements[j].getAttribute("publicKey");
                if (contentTypeId.length() > 0 && contentTypeId.equals(id) && publicKey.length() > 0) {
                    return publicKey;
                }
                ++j;
            }
            ++i;
        }
        return new String();
    }

    public static String loadExtensionPointDefaultVersion(String id) {
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.vtp.catalog.language");
        if (iep == null) {
            return new String();
        }
        IExtension[] extensions = iep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String contentTypeId = elements[j].getAttribute("contentTypeId");
                String version = elements[j].getAttribute("version");
                if (contentTypeId.length() > 0 && contentTypeId.equals(id) && version != null && version.length() > 0) {
                    return version;
                }
                ++j;
            }
            ++i;
        }
        return new String();
    }

    public static final CatalogEntry getDefaultEntryForContentType(String id) {
        String publicKey = CatalogDefaultResolver.loadPreferenceStoreDefault(id);
        if (publicKey.length() == 0) {
            publicKey = CatalogDefaultResolver.loadExtensionPointDefaultEntry(id);
        }
        if (publicKey.length() == 0) {
            return null;
        }
        CatalogEntry result = new CatalogEntry();
        result.setKey(publicKey);
        String ver = CatalogDefaultResolver.loadPreferenceStoreDefaultVersion(id);
        if (ver.length() > 0) {
            result.setVersion(ver);
        } else {
            result.setVersion(CatalogDefaultResolver.getVersionFromPublicIdentifier(publicKey));
        }
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (xmlCatalog != null) {
            INextCatalog[] nextCatalogs = xmlCatalog.getNextCatalogs();
            if (nextCatalogs == null) {
                return null;
            }
            int i = 0;
            while (i < nextCatalogs.length) {
                INextCatalog catalog = nextCatalogs[i];
                ICatalog referencedCatalog = catalog.getReferencedCatalog();
                if (referencedCatalog != null) {
                    ICatalog foundCatalog = null;
                    if ("system_catalog".equals(referencedCatalog.getId())) {
                        foundCatalog = referencedCatalog;
                    } else if ("user_catalog".equals(referencedCatalog.getId())) {
                        foundCatalog = referencedCatalog;
                    }
                    ICatalogEntry[] entries = foundCatalog.getCatalogEntries();
                    if (entries != null) {
                        int j = 0;
                        while (j < entries.length) {
                            if (entries[j] != null && entries[j].getKey().equals(publicKey)) {
                                result.setURI(entries[j].getURI());
                                String webURL = entries[j].getAttributeValue("webURL");
                                if (webURL != null && webURL.length() > 0) {
                                    result.setWebURL(webURL);
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }
}

