/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.internal.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.vtp.launching.VoiceXMLBrowserProcess;
import org.eclipse.vtp.launching.VoiceXMLLogMessage;
import org.eclipse.vtp.launching.internal.tellme.CallLog;
import org.eclipse.vtp.launching.internal.tellme.DisplayActions;
import org.eclipse.vtp.launching.internal.tellme.Messages;
import org.eclipse.vtp.launching.internal.tellme.TellmePlugin;

public class CallState {
    private static boolean callWatchThreadDone = false;
    private static boolean logFetchThreadDone = false;
    private static boolean logListThreadDone = false;
    private static boolean callWatchSuccessful = true;
    private static boolean logFetchSuccessful = true;
    private static boolean logListSuccessful = true;
    private static String callWatchReason = "";
    private static String logFetchReason = "";
    private static String logListReason = "";
    private static String callID = null;
    private static CallLog log = null;
    private static boolean stopButtonPushed = false;
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private static final boolean DEBUGGING = TellmePlugin.getDefault().isDebugging();
    private static Object synchObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean launchDone() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.launchDone() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            return callWatchThreadDone && logListThreadDone && logFetchThreadDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCallWatch() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.initCallWatch() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            callWatchThreadDone = false;
            callWatchSuccessful = true;
            callWatchReason = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLogFetch() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.initLogFetch() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            logFetchThreadDone = false;
            logFetchSuccessful = true;
            logFetchReason = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLogList() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.initLogList() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            logListThreadDone = false;
            logListSuccessful = true;
            logListReason = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCallWatchDone() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.setCallWatchDone() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            callWatchThreadDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogFetchDone() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.setLogFetchDone() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            logFetchThreadDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogListDone() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.setLogListDone() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            logListThreadDone = true;
        }
    }

    public static Object getSynch() {
        return synchObj;
    }

    public static void setLog(CallLog loglist) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.setLogList() called");
            System.out.flush();
        }
        log = loglist;
    }

    public static CallLog getLog() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.getLogList() called");
            System.out.flush();
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportCallWatchFail(String reason) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.reportCallWatchFail() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            callWatchSuccessful = false;
            callWatchReason = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportCallWatchSucceed(String reason) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.reportCallWatchSucceed() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            callWatchSuccessful = true;
            callWatchReason = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportLogFetchFail(String reason) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.reportLogFetchFail() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            logFetchSuccessful = false;
            logFetchReason = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportLogFetchSucceed(String reason) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.reportLogFetchSucceed() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            logFetchSuccessful = true;
            logFetchReason = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportLogListFail(String reason) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.reportLogListFail() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            logListSuccessful = false;
            logListReason = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportLogListSucceed(String reason) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.reportLogListSucceed() called");
            System.out.flush();
        }
        Object object = synchObj;
        synchronized (object) {
            logListSuccessful = true;
            logListReason = reason;
        }
    }

    public static void setCallID(String callid) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.setCallID() called");
            System.out.flush();
        }
        callID = callid;
    }

    public static void endLaunch() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.endLaunch() called");
            StackTraceElement[] whereami = new Throwable().getStackTrace();
            int i = 1;
            while (i < Math.min(whereami.length, 2)) {
                System.out.println(whereami[i].toString());
                ++i;
            }
            System.out.flush();
        }
        VoiceXMLBrowserProcess activeBrowser = null;
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches != null) {
            int i = 0;
            while (i < launches.length) {
                IProcess[] threads = launches[i].getProcesses();
                if (threads != null && threads.length > 0 && threads[0] instanceof VoiceXMLBrowserProcess) {
                    activeBrowser = (VoiceXMLBrowserProcess)threads[0];
                }
                ++i;
            }
        }
        if (callWatchSuccessful && logFetchSuccessful && logListSuccessful) {
            String checkedID = "".equals(callID) ? Messages.DisplayActions_0 : callID;
            DebugEvent[] event = new DebugEvent[]{new DebugEvent((Object)activeBrowser.getVoiceXMLBrowser(), 32, 3)};
            event[0].setData((Object)new VoiceXMLLogMessage(new Date(), String.valueOf(Messages.DisplayActions_7) + checkedID + Messages.DisplayActions_8));
            DebugPlugin.getDefault().fireDebugEventSet(event);
        } else {
            DisplayActions.showError(String.valueOf("OK".equals(callWatchReason) ? "" : callWatchReason) + ("".equals(callWatchReason) || "OK".equals(callWatchReason) ? "" : "\n") + logListReason + ("".equals(logListReason) ? "" : "\n") + (logListReason.equals(logFetchReason) ? "" : logFetchReason));
        }
        if (activeBrowser.getVoiceXMLBrowser() != null) {
            activeBrowser.getVoiceXMLBrowser().stop();
        }
        activeBrowser.setTerminated(true);
        DebugEvent[] event = new DebugEvent[]{new DebugEvent((Object)activeBrowser, 8), new DebugEvent((Object)activeBrowser.getLaunch(), 16)};
        DebugPlugin.getDefault().fireDebugEventSet(event);
    }

    public static void setStopping(boolean state) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.setStopping() called");
            System.out.flush();
        }
        stopButtonPushed = state;
    }

    public static boolean isStopping() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallState.isStopping() called: value = " + stopButtonPushed);
            System.out.flush();
        }
        return stopButtonPushed;
    }
}

