/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.internal.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.vtp.internal.dialer.IVoipCall;
import org.eclipse.vtp.internal.dialer.IVoipConnection;
import org.eclipse.vtp.internal.dialer.IVoipDialer;
import org.eclipse.vtp.internal.dialer.IVoipDialerFactory;
import org.eclipse.vtp.internal.dialer.VoipDialerException;
import org.eclipse.vtp.launching.internal.tellme.CallState;
import org.eclipse.vtp.launching.internal.tellme.Messages;
import org.eclipse.vtp.launching.internal.tellme.TellmePlugin;

public class CallStudio {
    private static IVoipDialer dialer;
    private static final SimpleDateFormat time;
    private static final boolean DEBUGGING;

    static {
        time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
        DEBUGGING = TellmePlugin.getDefault().isDebugging();
    }

    private CallStudio() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallStudio create");
            System.out.flush();
        }
    }

    protected static void initializeCall() throws CoreException, VoipDialerException {
        IExtension[] extensions;
        IConfigurationElement[] elements;
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallStudio.initializeCall() called.");
            System.out.flush();
        }
        boolean dialerFound = false;
        CallState.setStopping(false);
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.vtp.launching.tellme.DialerImplementation");
        if (iep != null && (elements = (extensions = iep.getExtensions())[0].getConfigurationElements()) != null) {
            int j = 0;
            while (j < elements.length) {
                Object obj = elements[j].createExecutableExtension("class");
                if (obj instanceof IVoipDialerFactory) {
                    dialer = ((IVoipDialerFactory)obj).getDialer();
                    dialerFound = true;
                    break;
                }
                ++j;
            }
        }
        if (!dialerFound) {
            throw new VoipDialerException(null, Messages.CallStudio_0);
        }
    }

    public static IVoipCall startCall(String studioNumber, boolean noAutoLogin, String studioID, String studioPIN) throws VoipDialerException {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallStudio.startCall() called.");
            System.out.flush();
        }
        int callstatus = 0;
        IVoipCall callObj = null;
        IVoipConnection accessObj = dialer.connect();
        if (DEBUGGING) {
            System.out.println("ConnectionStatus=" + CallStudio.connectStatus(accessObj.status()));
        }
        if (accessObj.status() != 1) {
            throw new VoipDialerException(null, Messages.CallStudio_1);
        }
        callObj = accessObj.dial(studioNumber);
        callstatus = callObj.status();
        if (callstatus == 2) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, Messages.CallStudio_2, (Throwable)e));
            }
            String DTMFstring = "#" + studioID + "#" + studioPIN + "#";
            if (noAutoLogin) {
                callObj.sendDTMF(DTMFstring, 300);
            }
        }
        return callObj;
    }

    public static String finishCall(IVoipCall callObj) throws VoipDialerException {
        String retval = "OK";
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallStudio.finishCall() called.");
            System.out.flush();
        }
        int callstatus = callObj.status();
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": CallProgress=" + CallStudio.callStatus(callstatus));
            System.out.flush();
        }
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                DebugPlugin.log((IStatus)new Status(4, "org.eclipse.vtp.launching.tellme", 4, Messages.CallStudio_3, (Throwable)e));
            }
        } while ((callstatus = callObj.status()) != 4 && callstatus != 16 && !CallState.isStopping());
        if (CallState.isStopping()) {
            callstatus = 4;
            retval = CallStudio.callStatus(callstatus);
        }
        if (callstatus == 16) {
            retval = CallStudio.callStatus(callstatus);
        }
        return retval;
    }

    public static String connectStatus(int stat) {
        String result;
        switch (stat) {
            case 2: {
                result = "CONNECTION_DIALING";
                break;
            }
            case 4: {
                result = "CONNECTION_ERROR";
                break;
            }
            case 1: {
                result = "CONNECTION_OK";
                break;
            }
            default: {
                result = "????";
            }
        }
        return result;
    }

    public static String callStatus(int stat) {
        String result;
        switch (stat) {
            case 2: {
                result = "CALL_ACTIVE";
                break;
            }
            case 4: {
                result = "CALL_COMPLETED";
                break;
            }
            case 16: {
                result = "CALL_ERROR";
                break;
            }
            case 1: {
                result = "CALL_OK";
                break;
            }
            default: {
                result = stat == 32 ? "AWAIT_RESPONSE" : Integer.toString(stat);
            }
        }
        return result;
    }
}

