/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching.internal.tellme;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.vtp.internal.dialer.IVoipCall;
import org.eclipse.vtp.internal.dialer.VoipDialerException;
import org.eclipse.vtp.launching.IVoiceXMLBrowser;
import org.eclipse.vtp.launching.VoiceXMLBrowserInput;
import org.eclipse.vtp.launching.VoiceXMLBrowserProcess;
import org.eclipse.vtp.launching.internal.tellme.CallState;
import org.eclipse.vtp.launching.internal.tellme.CallStudio;
import org.eclipse.vtp.launching.internal.tellme.DisplayActions;
import org.eclipse.vtp.launching.internal.tellme.GetLogListChange;
import org.eclipse.vtp.launching.internal.tellme.Messages;
import org.eclipse.vtp.launching.internal.tellme.StudioInteractions;
import org.eclipse.vtp.launching.internal.tellme.TellmePlugin;

public class TellmeStudioBrowser
implements IVoiceXMLBrowser {
    private static final String PACKAGE_NAME = "org.eclipse.vtp.launching.tellme";
    IVoipCall callObject = null;
    private static final boolean DEBUGGING = TellmePlugin.getDefault().isDebugging();
    private static final SimpleDateFormat time = new SimpleDateFormat("mm:ss.SSS", Locale.getDefault());
    private VoiceXMLBrowserProcess holdThatProcess = null;
    private final Map localPropStore = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": TellmeStudioBrowser.start() called.");
            System.out.flush();
        }
        try {
            CallStudio.initializeCall();
        }
        catch (CoreException e) {
            DebugPlugin.log((IStatus)new Status(4, PACKAGE_NAME, 4, Messages.TellmeStudioBrowser_0, (Throwable)e));
        }
        catch (VoipDialerException e) {
            CallState.reportCallWatchFail(e.getMessage());
            CallState.reportLogFetchFail("");
            CallState.reportLogListFail("");
            CallState.setCallWatchDone();
            CallState.setLogFetchDone();
            CallState.setLogListDone();
            CallState.endLaunch();
            return;
        }
        String studioPhone = TellmePlugin.getDefault().getPluginPreferences().getString("org.eclipse.vtp.launching.tellme.studio_phone");
        String studioAppURL = (String)this.getProperty("org.eclipse.vtp.launching.url");
        String studioEMAIL = (String)this.getProperty("org.eclipse.vtp.launching.tellme.devEMAIL");
        String studioPSWD = (String)this.getProperty("org.eclipse.vtp.launching.tellme.devPSWD");
        String studioID = (String)this.getProperty("org.eclipse.vtp.launching.tellme.devID");
        String studioPIN = (String)this.getProperty("org.eclipse.vtp.launching.tellme.devPIN");
        boolean noAutoLogin = "true".equals(this.getProperty("org.eclipse.vtp.launching.tellme.devNoAutoLogin"));
        String loginString = "usr_id=" + studioEMAIL + "&usr_pin=" + studioPSWD;
        StudioInteractions.setLogin(loginString);
        StudioInteractions.studioScratchpadMode();
        StudioInteractions.sendApplicationURL(studioAppURL);
        Object object = CallState.getSynch();
        synchronized (object) {
            CallState.setCallWatchDone();
            CallState.setLogListDone();
            CallState.setLogFetchDone();
        }
        try {
            this.callObject = CallStudio.startCall(studioPhone, noAutoLogin, studioID, studioPIN);
        }
        catch (VoipDialerException vde) {
            CallState.reportCallWatchFail(String.valueOf(vde.getMessage()) + ": " + (vde.getCause() != null ? vde.getCause().getMessage() : ""));
            CallState.endLaunch();
            return;
        }
        new Thread((Runnable)new GetLogListChange(), "watchloglist").start();
        final IVoipCall localCall = this.callObject;
        Runnable watchCall = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CallState.initCallWatch();
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + ": TellmeStudioBrowser, thread watchcall started");
                    System.out.flush();
                }
                String callResult = "NOT OK";
                try {
                    callResult = CallStudio.finishCall(localCall);
                }
                catch (VoipDialerException vde) {
                    callResult = vde.getMessage();
                }
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + ": TellmeStudioBrowser, call is finished, ending watchcall thread");
                    System.out.flush();
                }
                if ("OK".equals(callResult)) {
                    CallState.reportCallWatchSucceed(callResult);
                } else {
                    CallState.reportCallWatchFail(callResult);
                }
                Object object = CallState.getSynch();
                synchronized (object) {
                    CallState.setCallWatchDone();
                    if (CallState.launchDone()) {
                        CallState.endLaunch();
                    }
                }
            }
        };
        new Thread(watchCall, "watchcall").start();
    }

    public void stop() {
        try {
            if (DEBUGGING) {
                System.out.println(String.valueOf(time.format(new Date())) + ": TellmeStudioBrowser.stop() called. callObject is " + (this.callObject == null ? "" : "not") + " null");
                StackTraceElement[] whereami = new Throwable().getStackTrace();
                int i = 1;
                while (i < Math.min(whereami.length, 2)) {
                    System.out.println(whereami[i].toString());
                    ++i;
                }
                System.out.flush();
            }
            if (this.callObject != null) {
                if (DEBUGGING) {
                    System.out.println(String.valueOf(time.format(new Date())) + ": TellmeStudioBrowser.stop() call status is " + (this.callObject == null ? "no call object" : CallStudio.callStatus(this.callObject.status())));
                    System.out.flush();
                }
                switch (this.callObject.status()) {
                    case 2: {
                        this.callObject.hangUp();
                    }
                    case 4: {
                        this.callObject.getConnection().disconnect();
                    }
                }
                this.callObject = null;
            }
            CallState.setStopping(true);
        }
        catch (VoipDialerException exc) {
            DebugPlugin.log((IStatus)new Status(4, PACKAGE_NAME, 4, Messages.TellmeStudioBrowser_4, (Throwable)exc));
        }
    }

    public void sendInput(VoiceXMLBrowserInput input) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": TellmeStudioBrowser.sendInput() called.");
            System.out.flush();
        }
        if (input.getInputType() == 1) {
            String dtmf = (String)input.getInput();
            try {
                this.callObject.sendDTMF(dtmf);
            }
            catch (VoipDialerException e) {
                DebugPlugin.log((IStatus)new Status(4, PACKAGE_NAME, 4, Messages.TellmeStudioBrowser_5, (Throwable)e));
                DisplayActions.showError(Messages.TellmeStudioBrowser_6, e.getMessage());
            }
        } else {
            DebugPlugin.log((IStatus)new Status(2, PACKAGE_NAME, 2, String.valueOf(Messages.TellmeStudioBrowser_7) + input.getInputType() + Messages.TellmeStudioBrowser_8, null));
        }
    }

    public void setProperty(String propertyname, Object value) {
        this.localPropStore.put(propertyname, value);
    }

    private Object getProperty(String propertyname) {
        return this.localPropStore.get(propertyname);
    }

    public void setProcess(VoiceXMLBrowserProcess process) {
        this.holdThatProcess = process;
    }

    public VoiceXMLBrowserProcess getProcess() {
        return this.holdThatProcess;
    }

    public boolean hasCapability(String capability) {
        if (DEBUGGING) {
            System.out.println(String.valueOf(time.format(new Date())) + ": TellmeStudioBrowser.hasCapability() called.");
            System.out.flush();
        }
        boolean hasCap = false;
        if (capability.equals("org.eclipse.vtp.launching.capability_interactive") || capability.equals("org.eclipse.vtp.launching.capability_dtmf") || capability.equals("org.eclipse.vtp.launching.capability_log_event")) {
            hasCap = true;
        }
        return hasCap;
    }
}

