package org.eclipse.vtp.catalog.internal.ui;
/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.vtp.catalog.internal.CatalogPlugin;
import org.eclipse.vtp.catalog.internal.nls.CatalogResourceHandler;
import org.eclipse.vtp.catalog.registry.CatalogDefaultResolver;
import org.eclipse.vtp.catalog.registry.CatalogEntry;


/**
 * Preference page to set default catalog entry to use for new VoiceXML, CCXML, and SRGS file wizards.
 * 
 * @author Brent D. Metz
 */
public class CatalogDefaultPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {
	protected Label vxmlDefaultCatalog;
	protected Label srgsDefaultCatalog;
	protected Label ccxmlDefaultCatalog;
	
	protected Text vxmlVersion;
	protected Text srgsVersion;
	protected Text ccxmlVersion;
	
	
	public boolean performOk() {
		IPreferenceStore store=CatalogPlugin.getDefault().getPreferenceStore();
		store.setValue(CatalogDefaultResolver.CCXML_ID, ccxmlDefaultCatalog.getText());
		store.setValue(CatalogDefaultResolver.CCXML_ID + CatalogDefaultResolver.VERSION, ccxmlVersion.getText());
		
		store.setValue(CatalogDefaultResolver.VXML_ID, vxmlDefaultCatalog.getText());
		store.setValue(CatalogDefaultResolver.VXML_ID + CatalogDefaultResolver.VERSION, vxmlVersion.getText());

		store.setValue(CatalogDefaultResolver.SRGS_ID, srgsDefaultCatalog.getText());
		store.setValue(CatalogDefaultResolver.SRGS_ID + CatalogDefaultResolver.VERSION, srgsVersion.getText());
		
		return super.performOk();
	}
	
	protected void performDefaults() {
		String entry;
		String version;
		
		entry = CatalogDefaultResolver.loadExtensionPointDefaultEntry(CatalogDefaultResolver.CCXML_ID);
		version = CatalogDefaultResolver.loadExtensionPointDefaultVersion(CatalogDefaultResolver.CCXML_ID);
		
		if (ccxmlDefaultCatalog != null) {
			ccxmlDefaultCatalog.setText(entry);
		}
		if (ccxmlVersion != null) {
			ccxmlVersion.setText(version);
		}
		
		entry = CatalogDefaultResolver.loadExtensionPointDefaultEntry(CatalogDefaultResolver.SRGS_ID);
		version = CatalogDefaultResolver.loadExtensionPointDefaultVersion(CatalogDefaultResolver.SRGS_ID);
		
		if (srgsDefaultCatalog != null) {
			srgsDefaultCatalog.setText(entry);
		}
		if (srgsVersion != null) {
			srgsVersion.setText(version);
		}
		
		entry = CatalogDefaultResolver.loadExtensionPointDefaultEntry(CatalogDefaultResolver.VXML_ID);
		version = CatalogDefaultResolver.loadExtensionPointDefaultVersion(CatalogDefaultResolver.VXML_ID);
		
		if (vxmlDefaultCatalog != null) {
			vxmlDefaultCatalog.setText(entry);
		}
		if (vxmlVersion != null) {
			vxmlVersion.setText(version);
		}
	}
	
	protected void initializeValues() {
		CatalogEntry entry = CatalogDefaultResolver.getDefaultEntryForContentType(CatalogDefaultResolver.CCXML_ID);
		if (entry != null) {
			if (ccxmlDefaultCatalog != null) {
				ccxmlDefaultCatalog.setText(entry.getKey());
			}
			if (ccxmlVersion != null) {
				ccxmlVersion.setText(entry.getVersion());
			}
		}
		
		entry = CatalogDefaultResolver.getDefaultEntryForContentType(CatalogDefaultResolver.SRGS_ID);
		if (entry != null) {
			if (srgsDefaultCatalog != null) {
				srgsDefaultCatalog.setText(entry.getKey());
			}
			if (srgsVersion != null) {
				srgsVersion.setText(entry.getVersion());
			}
		}
		
		entry = CatalogDefaultResolver.getDefaultEntryForContentType(CatalogDefaultResolver.VXML_ID);
		if (entry != null) {
			if (vxmlDefaultCatalog != null) {
				vxmlDefaultCatalog.setText(entry.getKey());
			}
			if (vxmlVersion != null) {
				vxmlVersion.setText(entry.getVersion());
			}
		}
	}
	
	/**
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent) {
	    Composite composite = new Composite(parent, SWT.NULL);
	    composite.setLayout(new GridLayout());
	    composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		Label l;
		Button b;
		Composite c;
		GridLayout gl;
		GridData gd;
		
		Group voiceXMLGroup = new Group(composite, SWT.NONE);
		voiceXMLGroup.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.0")); //$NON-NLS-1$
		gl = new GridLayout();
		gl.numColumns=2;
		voiceXMLGroup.setLayout(gl);
		voiceXMLGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		l = new Label(voiceXMLGroup, SWT.NONE);
		l.setLayoutData(new GridData());
		l.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.1")); //$NON-NLS-1$
		
		vxmlDefaultCatalog = new Label(voiceXMLGroup, SWT.NONE);
		vxmlDefaultCatalog.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		
		c = new Composite(voiceXMLGroup, SWT.NONE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan=2;
		gd.horizontalIndent=0;
		c.setLayoutData(gd);
		gl = new GridLayout();
		gl.numColumns=2;
		gl.marginLeft=0;
		c.setLayout(gl);
		
		l = new Label(c, SWT.NONE);
		gd = new GridData();
		gd.horizontalIndent=0;
		l.setLayoutData(gd);
		l.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.2")); //$NON-NLS-1$
		
		vxmlVersion = new Text(c, SWT.BORDER);
		gd = new GridData();
		gd.widthHint=20;
		vxmlVersion.setLayoutData(gd);
				
		b = new Button(voiceXMLGroup, SWT.PUSH);
		b.setLayoutData(new GridData());
		b.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.3")); //$NON-NLS-1$
		b.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				CatalogEntrySelectionDialog md = new CatalogEntrySelectionDialog(getShell(), CatalogResourceHandler.getString("CatalogDefaultPreferencePage.4"), vxmlDefaultCatalog.getText()); //$NON-NLS-1$
				if (md.open() == CatalogEntrySelectionDialog.OK) {
					vxmlDefaultCatalog.setText(md.getSelectedCatalogEntry());
					String version = CatalogDefaultResolver.getVersionFromPublicIdentifier(md.getSelectedCatalogEntry());
					if (version != null) {
						vxmlVersion.setText(version);						
					}
				}
			}
		});

		
		Group SRGSGroup = new Group(composite, SWT.NONE);
		SRGSGroup.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.5")); //$NON-NLS-1$
		gl = new GridLayout();
		gl.numColumns=2;
		SRGSGroup.setLayout(gl);
		SRGSGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		l = new Label(SRGSGroup, SWT.NONE);
		l.setLayoutData(new GridData());
		l.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.6")); //$NON-NLS-1$
		
		srgsDefaultCatalog = new Label(SRGSGroup, SWT.NONE);
		srgsDefaultCatalog.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		c = new Composite(SRGSGroup, SWT.NONE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan=2;
		gd.horizontalIndent=0;
		c.setLayoutData(gd);
		gl = new GridLayout();
		gl.numColumns=2;
		gl.marginLeft=0;
		c.setLayout(gl);
		
		l = new Label(c, SWT.NONE);
		gd = new GridData();
		gd.horizontalIndent=0;
		l.setLayoutData(gd);
		l.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.2")); //$NON-NLS-1$
		
		srgsVersion = new Text(c, SWT.BORDER);
		gd = new GridData();
		gd.widthHint=15;
		srgsVersion.setLayoutData(gd);
		
		b = new Button(SRGSGroup, SWT.PUSH);
		b.setLayoutData(new GridData());
		b.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.3")); //$NON-NLS-1$
		b.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				CatalogEntrySelectionDialog md = new CatalogEntrySelectionDialog(getShell(), CatalogResourceHandler.getString("CatalogDefaultPreferencePage.9"), srgsDefaultCatalog.getText()); //$NON-NLS-1$
				if (md.open() == CatalogEntrySelectionDialog.OK) {
					srgsDefaultCatalog.setText(md.getSelectedCatalogEntry());
					String version = CatalogDefaultResolver.getVersionFromPublicIdentifier(md.getSelectedCatalogEntry());
					if (version != null) {
						srgsVersion.setText(version);						
					}
				}
			}
		});
		
		Group CCXMLGroup = new Group(composite, SWT.NONE);
		CCXMLGroup.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.10")); //$NON-NLS-1$
		gl = new GridLayout();
		gl.numColumns=2;
		CCXMLGroup.setLayout(gl);
		CCXMLGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		l = new Label(CCXMLGroup, SWT.NONE);
		l.setLayoutData(new GridData());
		l.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.11")); //$NON-NLS-1$
		
		ccxmlDefaultCatalog = new Label(CCXMLGroup, SWT.NONE);
		ccxmlDefaultCatalog.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		c = new Composite(CCXMLGroup, SWT.NONE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan=2;
		gd.horizontalIndent=0;
		c.setLayoutData(gd);
		gl = new GridLayout();
		gl.numColumns=2;
		gl.marginLeft=0;
		c.setLayout(gl);
		
		l = new Label(c, SWT.NONE);
		gd = new GridData();
		gd.horizontalIndent=0;
		l.setLayoutData(gd);
		l.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.2")); //$NON-NLS-1$
		
		ccxmlVersion = new Text(c, SWT.BORDER);
		gd = new GridData();
		gd.widthHint=15;
		ccxmlVersion.setLayoutData(gd);
		
		b = new Button(CCXMLGroup, SWT.PUSH);
		b.setLayoutData(new GridData());
		b.setText(CatalogResourceHandler.getString("CatalogDefaultPreferencePage.3")); //$NON-NLS-1$
		b.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				CatalogEntrySelectionDialog md = new CatalogEntrySelectionDialog(getShell(), CatalogResourceHandler.getString("CatalogDefaultPreferencePage.14"), ccxmlDefaultCatalog.getText()); //$NON-NLS-1$
				if (md.open() == CatalogEntrySelectionDialog.OK) {
					ccxmlDefaultCatalog.setText(md.getSelectedCatalogEntry());
					String version = CatalogDefaultResolver.getVersionFromPublicIdentifier(md.getSelectedCatalogEntry());
					if (version != null) {
						ccxmlVersion.setText(version);						
					}
				}
			}
		});
		
		initializeValues();
		
		
		return composite;
	}

	public void init(IWorkbench workbench) {
	}
}
