package org.eclipse.vtp.catalog.registry;
/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/

/**
 * Represents an XML Catalog Entry.
 * 
 * @author Brent D. Metz
 */
public class CatalogEntry {
	/**
	 * The public identifier this catalog entry represents (ie, -//IETF//DTD HTML 2.0 Strict//EN).
	 */
	protected String key=null;
	
	/**
	 * The URL to the catalog entry (ie, http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd). May be null.
	 */
	protected String webUrl=null;
	
	/**
	 * The URI to the catalog entry. This may be either a local file cache of the entry or a remote URI.
	 */
	protected String uri=null;
	
	/**
	 * The version this catalog entry represents. Typically this is extracted automatically from
	 *   the public identifier. May be null.
	 */
	protected String version;
	
	/**
	 * Returns the version of this catalog entry.
	 * 
	 * @return The version if set or null if no version is set.
	 */
	public String getVersion() {
		return version;
	}
	
	/**
	 * Sets the version to associate with this catalog entry.
	 * 
	 * @param version The version to associate with this catalog entry.
	 */
	public void setVersion(String version) {
		this.version = version;
	}
	
	/**
	 * The public identifier associated with this catalog entry (ie, -//IETF//DTD HTML 2.0 Strict//EN).
	 * 
	 * @return The public identifier.
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * Sets the public identifier associated with this catalog entry (ie, -//IETF//DTD HTML 2.0 Strict//EN).
	 * 
	 * @param key The public identifier to set.
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * The URI which points to the DTD this catalog entry represents. Is typically a local cached copy
	 *   but may be a URI pointing to a remote server.
	 * 
	 * @return A string representing the URI which points to the DTD this catalog entry represents.
	 */
	public String getURI() {
		return uri;
	}
	
	/**
	 * Sets the URI pointing to the DTD this catalog entry represents.
	 * 
	 * @param uri The URI.
	 */
	public void setURI(String uri) {
		this.uri = uri;
	}
	
	/**
	 * Gets the URL pointing to the DTD being referenced by this catalog entry. This is the URL typically 
	 *   present in a DOCTYPE declaration.
	 *   
	 * @return The URL pointing to the DTD being referenced. May be null. 
	 */
	public String getWebURL() {
		return webUrl;
	}
	
	/**
	 * Sets the URL pointing to the DTD being referenced by this catalog entry.
	 * 
	 * @param webUrl The URL, or null if none is specified for this catalog entry.
	 */
	public void setWebURL(String webUrl) {
		this.webUrl = webUrl;
	}
	
}
