package org.eclipse.vtp.editor.internal.actions;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.vtp.editor.internal.nls.VoicetoolsResourceHandler;
import org.eclipse.wst.sse.ui.StructuredTextEditor;


/**
 * Edit Referenced File delegate for editors
 */
public class EditReferencedFileActionDelegate implements IEditorActionDelegate, IActionDelegate2, IViewActionDelegate {
	private IEditorPart fEditor;
	private String attrValueLoaded;
	StructuredTextEditor textEditor;	

	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		fEditor = targetEditor;
	}

	public void dispose() {
		// nulling out just in case
		fEditor = null;
	}

	public void init(IAction action) {
		if (action != null) {
			action.setText(VoicetoolsResourceHandler.getString("EditReferencedFile.label"));   //$NON-NLS-1$
			action.setToolTipText(VoicetoolsResourceHandler.getString("EditReferencedFile.tooltip"));   //$NON-NLS-1$
			action.setDescription(VoicetoolsResourceHandler.getString("EditReferencedFile.description"));   //$NON-NLS-1$
		}
	}

	public void runWithEvent(IAction action, Event event) {
		run(action);
	}

	public void init(IViewPart view) {
		// do nothing
	}

	/**
	 * Run is called and invoked when an action occurs.
	 */
	public void run(IAction action) {
		// find the first attribute representing a file reference
		if (fEditor instanceof ITextEditor) {
			textEditor = (StructuredTextEditor) fEditor;
		}	
		String[] attrs = getAttributeNames();
		for (int i = 0; i < attrs.length; i++) {
			attrValueLoaded = ActionSupport.currentPosGetAttributeValue(textEditor, attrs[i]);
			if (attrValueLoaded != null) {
				break;
			}
		}

		if (attrValueLoaded == null) {
			displayAttributeError2();
		} else {
			//Verify that the src value doesn't start with "/" (forwardslash),
			//"\\" (backslash), "file:", "http:", "https:", or "ftp:"

			if (attrValueLoaded.toLowerCase().startsWith("file:") //$NON-NLS-1$
					|| attrValueLoaded.toLowerCase().startsWith("http:") //$NON-NLS-1$
					|| attrValueLoaded.toLowerCase().startsWith("https:") //$NON-NLS-1$
					|| attrValueLoaded.toLowerCase().startsWith("ftp:") //$NON-NLS-1$
					|| attrValueLoaded.startsWith("/") //$NON-NLS-1$
					|| attrValueLoaded.startsWith("\\")) { //$NON-NLS-1$
				displayPathError();
			} else {

				/* Get the file that the editor is currently working on */
				IFileEditorInput fileEditorInput = (IFileEditorInput) textEditor.getEditorInput();
				IFile editorFile = fileEditorInput.getFile();

				/* Get the project for that file */
				IProject currentProject = editorFile.getProject();

				/* Create file path * */
				IPath editorFilePath = editorFile.getFullPath();
				editorFilePath = editorFilePath.removeFirstSegments(1);
				editorFilePath = editorFilePath.removeLastSegments(1);
				IPath editorFileLocatedPath = editorFilePath.append(attrValueLoaded);
				String streditorFileLocatedPath = editorFileLocatedPath.toString();

				/* Get file */
				IFile fullFileLoaded = currentProject
						.getFile(streditorFileLocatedPath);

				if (fullFileLoaded.exists()) {
					/* open editor */
					try {
						IWorkbenchPage page = PlatformUI.getWorkbench()
								.getActiveWorkbenchWindow().getActivePage();
						IDE.openEditor(page, fullFileLoaded, true);
					} catch (PartInitException e) {
						displayEditorNotOpenError();
					}
				} else {
					/* file doesn't exist, issue an error */
					displayAttributeError();
				}
			}
		}
	}

	/**
	 * Error; no src attribute
	 */
	protected void displayAttributeError2() {
		VoicetoolsResourceHandler.displayErrorDialog(
				"EditReferencedFileErrorTitle", //$NON-NLS-1$
		"EditReferencedFileInvalidLocation"); //$NON-NLS-1$

	}	
	
	/**
	 * set attribute error
	 */
	protected void displayAttributeError() {
		VoicetoolsResourceHandler.displayErrorDialog(
				"EditReferencedFileErrorTitle", //$NON-NLS-1$
		"EditReferencedFileErrorFileNotFound"); //$NON-NLS-1$

	}

	/**
	 * set file not found error
	 */
	protected void displayPathError() {
		VoicetoolsResourceHandler.displayErrorDialog(
				"EditReferencedFileErrorTitle", //$NON-NLS-1$
		"EditReferencedFileErrorPathNotResolved"); //$NON-NLS-1$

	}

	/**
	 * set set editor not open error
	 */
	protected void displayEditorNotOpenError() {
		VoicetoolsResourceHandler.displayErrorDialog(
				"EditReferencedFileErrorTitle", //$NON-NLS-1$
		"EditReferencedFileErrorEditorNotOpen"); //$NON-NLS-1$

	}

	/**
	 * return an array of element names for which this action is applicable.
	 * If this method returns String[]{null}, only attribute names are used and the action
	 * will be available on all elements having the attribute names returned
	 * by getAttributeNames
	 * @return array with element names or as in the default case String[]{null}
	 */
//	private String[] getElementNames() {
//		return new String[]{null};
//	}

	/**
	 * return all the attribute names for which this action is applicable
	 * The attribute values are assumed to take the name of a file that 
	 * can be opened. This default implementation returns an array containing
	 * "src" only.
	 * @return array of attribute names
	 */
	protected String[] getAttributeNames() {
		return new String[]{"src"}; //$NON-NLS-1$
	}

	public void selectionChanged(IAction action, ISelection selection) {
		// do nothing
	}

}
