/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/

package org.eclipse.vtp.internal.dialer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * Minimal implementation of the IVoipDialerListener interface.
 * 
 * This class implements IVoipDialerListener in a format that saves all
 * messages it receives in a synchronized, ArrayList-backed store. The user of
 * an instance of this class may retrieve the most-recently-received message
 * at any time, or retrieve an array of String objects representing the
 * complete message history.
 *
 * @author rjray
 */
public class VoipDialerListener implements IVoipDialerListener {
    final private List messages = Collections.synchronizedList(new ArrayList());
    
    /* (non-Javadoc)
     * @see org.eclipse.vtp.dialer.IVoipDialerListener#sendMessage(java.lang.String)
     */
    public void dialerMessage(final String message) {
        messages.add(message);
    }

    /**
     * Retrieve the most-recent message this listener has received.
     * 
     * @return The most-recent message as a String 
     */
    public String lastMessage() {
        return (String)messages.get(messages.size() - 1);
    }

    /**
     * Retrieve all the messages received by this listener, in chronological
     * order.
     * 
     * @return All messages as an array of String objects
     */
    public String[] messageHistory() {
        return (String[])messages.toArray(new String[1]);
    }
}
