/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/

package org.eclipse.vtp.launching.internal.tellme;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogToken {
	final static int HTML_TOKEN = 1;
	final static int TEXT_TOKEN = HTML_TOKEN << 1;
	final static int EOF_TOKEN = TEXT_TOKEN << 1;
	final static int IOE_TOKEN = EOF_TOKEN << 1;

	final private int localtype;
	final private String localcontent;
	final private boolean localcomplete;
	
	public LogToken(int type, String content, boolean complete){
		localtype = type;
		localcontent = content;
		localcomplete = complete;
	}
	
	final private static Pattern logDivPat = Pattern
	.compile("<div class=\"log_(\\w+?)\">"); //$NON-NLS-1$
	final private static Pattern logEndDivPat = Pattern.compile("</div>"); //$NON-NLS-1$
	
	private String logtype = ""; //$NON-NLS-1$
	
	public boolean isDiv(){
		logtype = ""; //$NON-NLS-1$
		if (localtype != HTML_TOKEN) return false;
		final Matcher divMatcher = logDivPat.matcher(localcontent);
		if (divMatcher.matches()){
			logtype = divMatcher.group(1);
			return true;
		}
		return false;
	}
	
	public String getLogType() {
		return logtype;
	}
	
	public boolean isEndDiv(){
		if (localtype != HTML_TOKEN) return false;
		return logEndDivPat.matcher(localcontent).matches();
	}

	public int getType() {
		return localtype;
	}
	
	public String getContent(){
		return localcontent;
	}
	
	public boolean getComplete() {
		return localcomplete;
	}
}
