package org.eclipse.vtp.launching;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/

import java.util.Date;

/**
 * Class to communicate log events from a VoiceXML Browser to any Eclipse listener.
 * 
 * @author Brent D. Metz
 */
public class VoiceXMLLogMessage {
	/**
	 * The date the event occurred.
	 */
	protected Date date=null;
	
	/**
	 * Log message generated by the VoiceXML Browser
	 */
	protected String message=""; //$NON-NLS-1$
	
	/**
	 * Creates a new VoiceXMLLogMessage object.
	 * 
	 * @param date The date the event occurred.
	 * @param message The content of the event.
	 */
	public VoiceXMLLogMessage(Date date, String message) {
		setDate(date);
		setMessage(message);
	}

	/**
	 * Returns the date the event occurred.
	 * 
	 * @return The date the event occurred.
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * Sets the event's date.
	 * 
	 * @param date The date of the event. May be null.
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * Returns the message contained in the event.
	 * 
	 * @return The message contained in the event. Will not be null.
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * Sets the message in the event.
	 * 
	 * @param message The message the event should contain.
	 */
	public void setMessage(String message) {
		if (message == null) {
			message=""; //$NON-NLS-1$
		}
		this.message = message;
	}
}
