package org.eclipse.vtp.editor.srgxml.ui.internal.actions;
/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
import org.eclipse.vtp.editor.internal.actions.ActionContributorXML;



/**
 * XMLEditorActionContributor
 * 
 * This class should not be used inside multi page editor's
 * ActionBarContributor, since cascaded init() call from the
 * ActionBarContributor will causes exception and it leads to lose whole
 * toolbars.
 * 
 * Instead, use SourcePageActionContributor for source page contributor of
 * multi page editor.
 * 
 * Note that this class is still valid for single page editor.
 */
public class ActionContributorSRGXML extends ActionContributorXML {
	private static final String[] EDITOR_IDS = {"org.eclipse.core.runtime.srgxml.source3", "org.eclipse.core.runtime.srgxml.source4"}; //$NON-NLS-1$ //$NON-NLS-2$

	public ActionContributorSRGXML() {
		super();
	}
	

	protected String[] getExtensionIDs() {
		return EDITOR_IDS;
	}	
}
