/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/
package org.eclipse.vtp.internal.dialer;


/**
 * This interface describes a factory pattern for retrieving objects that
 * implement the IVoipDialer interface. VoiceXML Browser implementations will
 * need to instantiate dialer objects in order to place calls via VoIP. The
 * factory structure allows an extension package to abstract the actual
 * implementation of the dialer object from the browser itself. This is the
 * expected type used in the extension-point that this plug-in defines, for
 * VoIP-phones hook to.
 *
 * @author rjray
 *
 */
public interface IVoipDialerFactory {
    /**
     * Get an object of an underlying class that implements the IVoipDialer
     * interface. The class of the underlying object should not be
     * important.
     *
     * @return An object instance which implements the IVoipDialer interface
     * @throws VoipDialerException when a problem occurs initializing the dialer
     */
    IVoipDialer getDialer() throws VoipDialerException;
}
