package org.eclipse.vtp.launching.internal.tellme.config;

/*******************************************************************************
 * Copyright (c) 2005 Tellme Networks, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tellme Networks, Inc. - Initial implementation
 *******************************************************************************/

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.debug.ui.BrowserConfigurationUIListener;
import org.eclipse.vtp.debug.ui.IBrowserConfigurationUI;
import org.eclipse.vtp.launching.internal.tellme.DisplayActions;
import org.eclipse.vtp.launching.internal.tellme.Messages;
import org.eclipse.vtp.launching.internal.tellme.TellmePlugin;

public class TellmeBrowserConfig implements IBrowserConfigurationUI {

	protected Text devID = null;

	protected Label idlabel = null;

	protected Text devPIN = null;

	protected Label pinlabel = null;

	protected Text devEMAIL = null;

	protected Text devPSWD = null;

	protected Button noAutoLogin = null;

	private Group tellmeGroup = null;

	private final String phoneNumber;
	
	// guard variable to prevent setting off modifylistener while initializing fields
	private boolean inInitialize=false;

	public TellmeBrowserConfig() {
		super();
		final Preferences pluginPrefs = TellmePlugin.getDefault()
				.getPluginPreferences();
		phoneNumber = pluginPrefs
				.getString(ITellmeVoiceXMLBrowserConstants.STUDIO_PHONE);
	}

	public void drawConfigurationUI(final Composite compUI,
			final BrowserConfigurationUIListener callback) {
		final BrowserConfigurationUIListener localcallback = callback;
		final ModifyListener listener = new ModifyListener() {
			public void modifyText(ModifyEvent event) {
				if (!inInitialize) {
					localcallback.contentsChanged();
				}
			}
		};
		final SelectionListener check = new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				Button myWidget = (Button) event.widget;
				if (myWidget.getSelection()) {
					devID.setEnabled(true);
					idlabel.setEnabled(true);
					devPIN.setEnabled(true);
					pinlabel.setEnabled(true);
				} else {
					devID.setEnabled(false);
					idlabel.setEnabled(false);
					devPIN.setEnabled(false);
					pinlabel.setEnabled(false);
				}
				localcallback.contentsChanged();
			}
		};
		final Text info = new Text(compUI, SWT.READ_ONLY);
		final GridData infoData = new GridData(GridData.FILL_HORIZONTAL);
		infoData.verticalIndent = 20;
		info.setText(Messages.TellmeBrowserConfig_0);
		tellmeGroup = new Group(compUI, SWT.SHADOW_ETCHED_IN);
		final GridData groupgd = new GridData(GridData.FILL_HORIZONTAL);
		groupgd.verticalIndent = 15;
		tellmeGroup.setLayoutData(groupgd);
		final GridLayout layout = new GridLayout();
		layout.numColumns = 4;
		tellmeGroup.setLayout(layout);
		tellmeGroup.setText(Messages.TellmeBrowserConfig_1);

		// UI to get user email and password
		Label email = new Label(tellmeGroup, SWT.NONE);
		email.setText(Messages.TellmeBrowserConfig_2);
		email.setLayoutData(new GridData());
		devEMAIL = new Text(tellmeGroup, SWT.SINGLE | SWT.BORDER);
		GridData grid = new GridData(GridData.FILL_HORIZONTAL);
		grid.grabExcessHorizontalSpace = true;
		devEMAIL.setLayoutData(grid);
		devEMAIL.addModifyListener(listener);
		Label pswd = new Label(tellmeGroup, SWT.NONE);
		pswd.setText(Messages.TellmeBrowserConfig_3);
		pswd.setLayoutData(new GridData());
		devPSWD = new Text(tellmeGroup, SWT.SINGLE | SWT.BORDER | SWT.PASSWORD);
		grid = new GridData(GridData.FILL_HORIZONTAL);
		grid.grabExcessHorizontalSpace = true;
		devPSWD.setLayoutData(grid);
		devPSWD.addModifyListener(listener);

		// UI to control login DTMF
		final Composite loginControl = new Composite(tellmeGroup, SWT.NONE);
		final GridData loginCtrlLayout = new GridData(GridData.FILL_HORIZONTAL);
		loginCtrlLayout.horizontalSpan = 4;
		loginControl.setLayoutData(loginCtrlLayout);
		loginControl.setLayout(new RowLayout(SWT.HORIZONTAL));
		noAutoLogin = new Button(loginControl, SWT.CHECK);
		noAutoLogin.setSelection(false);
		noAutoLogin.addSelectionListener(check);
		final Label box = new Label(loginControl, SWT.NONE);
		box.setText(Messages.TellmeBrowserConfig_4);

		idlabel = new Label(tellmeGroup, SWT.NONE);
		idlabel.setText(Messages.TellmeBrowserConfig_5);
		idlabel.setLayoutData(new GridData());
		idlabel.setEnabled(false);
		devID = new Text(tellmeGroup, SWT.SINGLE | SWT.BORDER);
		grid = new GridData(GridData.FILL_HORIZONTAL);
		grid.grabExcessHorizontalSpace = true;
		devID.setLayoutData(grid);
		devID.addModifyListener(listener);
		devID.setEnabled(false);

		pinlabel = new Label(tellmeGroup, SWT.NONE);
		pinlabel.setText(Messages.TellmeBrowserConfig_6);
		pinlabel.setLayoutData(new GridData());
		pinlabel.setEnabled(false);
		devPIN = new Text(tellmeGroup, SWT.SINGLE | SWT.BORDER | SWT.PASSWORD);
		grid = new GridData(GridData.FILL_HORIZONTAL);
		grid.grabExcessHorizontalSpace = true;
		devPIN.setLayoutData(grid);
		devPIN.addModifyListener(listener);
		devPIN.setEnabled(false);

		// Create information block 
		final Group tellmeInfoGroup = new Group(compUI, SWT.SHADOW_ETCHED_IN| SWT.READ_ONLY);
		final GridLayout gl2 = new GridLayout();
		tellmeInfoGroup.setText(Messages.TellmeBrowserConfig_7);
		tellmeInfoGroup.setLayout(gl2);
		final GridData groupgd2 = new GridData(GridData.FILL_BOTH);
		groupgd2.grabExcessHorizontalSpace = true;
		groupgd2.grabExcessVerticalSpace = true;
		tellmeInfoGroup.setLayoutData(groupgd2);
		Link l = new Link(tellmeInfoGroup, SWT.NONE);
		l.setText(Messages.TellmeBrowserConfig_8
				+ Messages.TellmeBrowserConfig_9
				+ Messages.TellmeBrowserConfig_10
				+ Messages.TellmeBrowserConfig_11
				+ Messages.TellmeBrowserConfig_12
				+ Messages.TellmeBrowserConfig_13
				+ Messages.TellmeBrowserConfig_14);
		l.addListener (SWT.Selection, new Listener () {
			public void handleEvent(Event event) {
				if (event.text != null && event.text.startsWith("http")) {
					Program.launch(event.text);
				}
			}
		});
		final GridData txtgd = new GridData(GridData.FILL_BOTH);
		l.setLayoutData(txtgd);

		compUI.pack();
	}

	public void setDefaults(final ILaunchConfigurationWorkingCopy configuration) {
		if (devEMAIL != null) {
			devEMAIL.setText(""); //$NON-NLS-1$
		}
		if (devPSWD != null) {
			devPSWD.setText(""); //$NON-NLS-1$
		}
		if (devID != null) {
			devID.setText(""); //$NON-NLS-1$
		}
		if (devPIN != null) {
			devPIN.setText(""); //$NON-NLS-1$
		}
		noAutoLogin.setSelection(false);
	}

	public void performApply(final ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(
				ITellmeVoiceXMLBrowserConstants.DEVELOPER_ID, devID.getText()
						.trim());
		configuration.setAttribute(
				ITellmeVoiceXMLBrowserConstants.DEVELOPER_PIN, devPIN.getText()
						.trim());
		configuration.setAttribute(
				ITellmeVoiceXMLBrowserConstants.DEVELOPER_EMAIL, devEMAIL
						.getText().trim());
		configuration.setAttribute(
				ITellmeVoiceXMLBrowserConstants.DEVELOPER_PSWD, devPSWD
						.getText().trim());
		configuration.setAttribute(
				ITellmeVoiceXMLBrowserConstants.NO_AUTO_LOGIN, String.valueOf(
						noAutoLogin.getSelection()).trim());
	}

	public void initializeFrom(final ILaunchConfiguration configuration) {
		inInitialize = true; // prevent modifyListeners on fields from firing
		try {
			devID.setText(configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.DEVELOPER_ID, "")); //$NON-NLS-1$
			devPIN.setText(configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.DEVELOPER_PIN, "")); //$NON-NLS-1$
			devEMAIL.setText(configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.DEVELOPER_EMAIL, "")); //$NON-NLS-1$
			devPSWD.setText(configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.DEVELOPER_PSWD, "")); //$NON-NLS-1$
			noAutoLogin.setSelection("true".equals(configuration.getAttribute( //$NON-NLS-1$
					ITellmeVoiceXMLBrowserConstants.NO_AUTO_LOGIN, "false"))); //$NON-NLS-1$
			if (noAutoLogin.getSelection()) {
				devID.setEnabled(true);
				devPIN.setEnabled(true);
				idlabel.setEnabled(true);
				pinlabel.setEnabled(true);
			}
		} catch (CoreException e) {
			DisplayActions
					.showError(Messages.TellmeBrowserConfig_15
							+ e.getMessage());
		}
		inInitialize = false;
	}

	public boolean isValid(final ILaunchConfiguration configuration) {
		boolean valid = true;
		String devid;
		String devpin;
		String devemail;
		String devpswd;
		String noautologin;

		try {
			devid = configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.DEVELOPER_ID, "").trim(); //$NON-NLS-1$
			devpin = configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.DEVELOPER_PIN, "").trim(); //$NON-NLS-1$
			devemail = configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.DEVELOPER_EMAIL, "").trim(); //$NON-NLS-1$
			
			// don't trim password - might have spaces intentionally
			devpswd = configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.DEVELOPER_PSWD, ""); //$NON-NLS-1$
			noautologin = configuration.getAttribute(
					ITellmeVoiceXMLBrowserConstants.NO_AUTO_LOGIN, "false") //$NON-NLS-1$
					.trim();

			if (!noautologin.equals("false")) { //$NON-NLS-1$
				if (devid.length() == 0 || devpin.length() == 0) {
					return false;
				}
			}
			if (devemail.length() == 0 || devpswd.length() == 0) {
				return false;
			}
			
//			valid = ((devid.length() == 0 && "false".equals(noautologin)) || (devid //$NON-NLS-1$
//					.length() != 0 && devid.matches("\\d{1,5}"))); //$NON-NLS-1$
//			valid = valid
//					&& ((devpin.length() == 0 && "false".equals(noautologin)) || (devpin //$NON-NLS-1$
//							.length() != 0 && devpin.matches("\\d{4,9}"))); //$NON-NLS-1$
//			// very weak validation of email address
//			valid = valid
//					&& (devemail.length() != 0 && devemail.indexOf('@') != -1);
//			// password may be 7-20 alphanumerics or punctuation, with at least one digit
//			valid = valid
//					&& (devpswd.length() != 0 && devpswd
//							.matches("[\\w!-/:-@\\[-`{-~]{7,20}") && devpswd.matches(".*\\d.*")); //$NON-NLS-1$//$NON-NLS-2$
			
		} catch (CoreException e) {
			valid = false;
			e.printStackTrace();
		}
		return valid;
	}

	public void dispose() {
		if (tellmeGroup == null) {
			return;
		}
		tellmeGroup.dispose();
	}
}
