/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     
 *******************************************************************************/
package org.eclipse.vtp.editor.internal.nls;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.jface.dialogs.MessageDialog;

import org.eclipse.vtp.editor.internal.Logger;

/**
 * Utility class to obtain strings from the resource bundle
 */
public class VoicetoolsResourceHandler {

	private static ResourceBundle fgResourceBundle;

	/**
	 * name of the resource bundle
	 */
	public static final String RESOURCE_BUNDLE = "org.eclipse.vtp.editor.internal.nls.VoicetoolsResources"; //$NON-NLS-1$

	/**
	 * name of the documentaion plugin (needed for F1-Help contexts)
	 */
	public static final String EDITOR_DOC_ROOT_PLUGIN = "org.eclipse.vtp.editor.doc"; //$NON-NLS-1$

	/**
	 * Action key for the Edit Referenced File action
	 */
	public static final String ACTION_NAME_EDIT_REFERENCED_FILE = "EditReferencedFile."; //$NON-NLS-1$

	/**
	 * Hide constructor of utility class
	 */
	private VoicetoolsResourceHandler() {
	}

	/**
	 * @return the resource bundle used by all classes in this Project
	 */
	public static ResourceBundle getResourceBundle() {
		try {
			return ResourceBundle.getBundle(RESOURCE_BUNDLE); //$NON-NLS-1$
		} catch (MissingResourceException e) {
			Logger.logException("Resourcebundle not found.", e); //$NON-NLS-1$
		}
		return null;
	}

	/**
	 * Get a string from the resource bndle
	 * 
	 * @param key
	 *            key
	 * @return value
	 */
	public static String getString(String key) {
		if (fgResourceBundle == null) {
			fgResourceBundle = getResourceBundle();
		}

		if (fgResourceBundle != null) {
			try {
				return fgResourceBundle.getString(key);
			} catch (MissingResourceException e) {
				return "!" + key + "!"; //$NON-NLS-2$//$NON-NLS-1$
			}
		} else {
			return "!" + key + "!"; //$NON-NLS-2$//$NON-NLS-1$
		}
	}

	/**
	 * Get string and use MessageFormat to insert parameters
	 * @param key	key 
	 * @param args	parameters to replace {0}, {1}, etc.
	 * @return	value with parameters inserted
	 */
	public static String getString(String key, Object[] args) {

		try {
			return MessageFormat.format(getString(key), args);
		} catch (IllegalArgumentException e) {
			return getString(key);
		}

	}


	/**
	 * This method reads its title and message from the resource bundle
	 * 
	 * @param title
	 *            property key for the title
	 * @param message
	 *            property key for the message
	 */
	public static void displayErrorDialog(String title, String message) {
		String titleMessage = getString(title);
		String errorMessage = getString(message);
		MessageDialog.openError(null, titleMessage, errorMessage);
	}

}