/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.ProjectFacetsUiManager;
import org.eclipse.wst.common.project.facet.ui.internal.AddRemoveFacetsDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPage;

public class AddRemoveFacetsWizard
extends Wizard {
    protected IFacetedProject fproj;
    private final WizardContext context = new WizardContext();
    protected final FacetsSelectionPage facetsSelectionPage;
    private FacetPages[] facetPages = new FacetPages[0];
    private Composite pageContainer;
    private final List pagesToDispose = new ArrayList();
    private final AddRemoveFacetsDataModel model = new AddRemoveFacetsDataModel();

    public AddRemoveFacetsWizard(IFacetedProject fproj) {
        this.fproj = fproj;
        Set base = null;
        if (this.fproj != null) {
            base = this.fproj.getProjectFacets();
            ChangeTargetedRuntimesDataModel rdm = this.model.getTargetedRuntimesDataModel();
            rdm.setTargetedRuntimes(this.fproj.getTargetedRuntimes());
            rdm.setPrimaryRuntime(this.fproj.getPrimaryRuntime());
        }
        this.facetsSelectionPage = new FacetsSelectionPage(this.context, base, this.model);
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(Resources.wizardTitle);
    }

    public final AddRemoveFacetsDataModel getModel() {
        return this.model;
    }

    public void addPages() {
        if (this.fproj != null) {
            this.facetsSelectionPage.setInitialSelection(this.fproj.getProjectFacets());
            this.facetsSelectionPage.setFixedProjectFacets(this.fproj.getFixedProjectFacets());
        }
        this.facetsSelectionPage.addSelectedFacetsChangedListener(new Listener(){

            public void handleEvent(Event event) {
                AddRemoveFacetsWizard.this.handleSelectedFacetsChangedEvent();
            }
        });
        this.addPage((IWizardPage)this.facetsSelectionPage);
    }

    public int getPageCount() {
        return this.getPages().length;
    }

    public IWizardPage[] getPages() {
        ArrayList<FacetsSelectionPage> list = new ArrayList<FacetsSelectionPage>();
        list.add(this.facetsSelectionPage);
        int i = 0;
        while (i < this.facetPages.length) {
            list.addAll(this.facetPages[i].pages);
            ++i;
        }
        return list.toArray(new IWizardPage[0]);
    }

    public IWizardPage getPage(String pageName) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page.getName().equals(pageName)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getStartingPage() {
        return this.getPages()[0];
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int pos = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                pos = i;
            }
            ++i;
        }
        if (pos == pages.length - 1) {
            return null;
        }
        return pages[pos + 1];
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int pos = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                pos = i;
            }
            ++i;
        }
        if (pos == 0) {
            return null;
        }
        return pages[pos - 1];
    }

    public boolean canFinish() {
        if (!this.facetsSelectionPage.isPageComplete()) {
            return false;
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite container) {
        super.createPageControls(container);
        this.pageContainer = container;
        this.handleSelectedFacetsChangedEvent();
    }

    public boolean performFinish() {
        int i = 0;
        while (i < this.facetPages.length) {
            FacetPages fp = this.facetPages[i];
            Iterator itr = fp.pages.iterator();
            while (itr.hasNext()) {
                ((IFacetWizardPage)itr.next()).transferStateToConfig();
            }
            ++i;
        }
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AddRemoveFacetsWizard.this.performFinish(monitor);
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof CoreException) {
                IStatus st = ((CoreException)te).getStatus();
                ErrorDialog.openError((Shell)this.getShell(), (String)Resources.errDlgTitle, (String)st.getMessage(), (IStatus)st);
                FacetUiPlugin.log(st);
            }
            throw new RuntimeException(e.getTargetException());
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 3);
        try {
            ChangeTargetedRuntimesDataModel rdm = this.model.getTargetedRuntimesDataModel();
            this.fproj.setTargetedRuntimes(rdm.getTargetedRuntimes(), AddRemoveFacetsWizard.submon(monitor, 1));
            if (rdm.getPrimaryRuntime() != null) {
                this.fproj.setPrimaryRuntime(rdm.getPrimaryRuntime(), AddRemoveFacetsWizard.submon(monitor, 1));
            }
            this.fproj.modify(this.facetsSelectionPage.getActions(), AddRemoveFacetsWizard.submon(monitor, 1));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }

    public String getProjectName() {
        return this.fproj.getProject().getName();
    }

    public Object getConfig(IProjectFacetVersion fv, IFacetedProject.Action.Type type, String pjname) throws CoreException {
        return null;
    }

    public void syncWithPresetsModel(Combo combo) {
        this.facetsSelectionPage.syncWithPresetsModel(combo);
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.facetPages.length) {
            this.pagesToDispose.addAll(this.facetPages[i].pages);
            ++i;
        }
        Iterator itr = this.pagesToDispose.iterator();
        while (itr.hasNext()) {
            ((IWizardPage)itr.next()).dispose();
        }
        this.model.dispose();
    }

    private static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return new SubProgressMonitor(parent, ticks);
    }

    private void handleSelectedFacetsChangedEvent() {
        if (!this.facetsSelectionPage.isPageComplete()) {
            return;
        }
        Set base = this.getBaseFacets();
        Set actions = this.facetsSelectionPage.getActions();
        ArrayList sortedActions = new ArrayList(actions);
        ProjectFacetsManager.sort((Set)base, sortedActions);
        ArrayList<FacetPages> newFacetPages = new ArrayList<FacetPages>();
        boolean[] markers = new boolean[this.facetPages.length];
        boolean changed = false;
        Iterator itr1 = sortedActions.iterator();
        while (itr1.hasNext()) {
            IFacetedProject.Action action = (IFacetedProject.Action)itr1.next();
            IProjectFacetVersion fv = action.getProjectFacetVersion();
            FacetPages fp = this.findFacetPages(action, markers);
            if (fp == null) {
                IActionDefinition actiondef;
                try {
                    actiondef = fv.getActionDefinition(base, action.getType());
                }
                catch (CoreException e) {
                    FacetUiPlugin.log((Exception)((Object)e));
                    continue;
                }
                List pages = ProjectFacetsUiManager.getWizardPages(actiondef.getId());
                if (!pages.isEmpty()) {
                    fp = new FacetPages();
                    fp.action = action;
                    fp.pages = pages;
                    Iterator itr2 = fp.pages.iterator();
                    while (itr2.hasNext()) {
                        IFacetWizardPage page = (IFacetWizardPage)itr2.next();
                        page.setWizard((IWizard)this);
                        page.setWizardContext(this.context);
                        page.setConfig(action.getConfig());
                        if (page.getControl() != null) continue;
                        page.createControl(this.pageContainer);
                        page.getControl().setVisible(false);
                    }
                    changed = true;
                }
            }
            if (fp == null) continue;
            newFacetPages.add(fp);
        }
        int i = 0;
        while (i < this.facetPages.length) {
            if (!markers[i]) {
                Iterator itr = this.facetPages[i].pages.iterator();
                while (itr.hasNext()) {
                    IFacetWizardPage page = (IFacetWizardPage)itr.next();
                    page.setWizard(null);
                    this.pagesToDispose.add(page);
                }
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.facetPages = new FacetPages[newFacetPages.size()];
            newFacetPages.toArray(this.facetPages);
            this.pageContainer.layout(true, true);
        }
    }

    private FacetPages findFacetPages(IFacetedProject.Action action, boolean[] markers) {
        int i = 0;
        while (i < this.facetPages.length) {
            FacetPages fp = this.facetPages[i];
            if (fp.action == action) {
                markers[i] = true;
                return fp;
            }
            ++i;
        }
        return null;
    }

    private Set getBaseFacets() {
        if (this.fproj == null) {
            return Collections.EMPTY_SET;
        }
        return this.fproj.getProjectFacets();
    }

    private static final class FacetPages {
        public IFacetedProject.Action action;
        public List pages;

        private FacetPages() {
        }
    }

    private static final class Resources
    extends NLS {
        public static String wizardTitle;
        public static String errDlgTitle;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.AddRemoveFacetsWizard");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.AddRemoveFacetsWizard$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }

    private final class WizardContext
    implements IWizardContext {
        private WizardContext() {
        }

        public String getProjectName() {
            return AddRemoveFacetsWizard.this.getProjectName();
        }

        public Set getSelectedProjectFacets() {
            return AddRemoveFacetsWizard.this.facetsSelectionPage.getSelectedProjectFacets();
        }

        public boolean isProjectFacetSelected(IProjectFacetVersion fv) {
            return this.getSelectedProjectFacets().contains(fv);
        }

        public Set getActions() {
            FacetsSelectionPage page = AddRemoveFacetsWizard.this.facetsSelectionPage;
            return page.getActions();
        }

        public IFacetedProject.Action getAction(IFacetedProject.Action.Type type, IProjectFacetVersion f) {
            Iterator itr = this.getActions().iterator();
            while (itr.hasNext()) {
                IFacetedProject.Action action = (IFacetedProject.Action)itr.next();
                if (action.getType() != type || action.getProjectFacetVersion() != f) continue;
                return action;
            }
            return null;
        }

        public Object getConfig(IProjectFacetVersion fv, IFacetedProject.Action.Type type, String pjname) throws CoreException {
            Object config = AddRemoveFacetsWizard.this.getConfig(fv, type, pjname);
            if (config == null) {
                Set base = AddRemoveFacetsWizard.this.getBaseFacets();
                IActionDefinition def = fv.getActionDefinition(base, type);
                config = def.createConfigObject(fv, pjname);
            }
            return config;
        }
    }
}

