/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.preferences;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage {
    private static final RDBCorePlugin core = RDBCorePlugin.getDefault();
    private static final ResourceLoader loader = ResourceLoader.getResourceLoader();
    private static final String C_TIMEOUT_ERR1 = loader.queryString("PREFERENCES.CONNECTION_TIMEOUT_ERR1");
    private static final String C_TIMEOUT_ERR2 = loader.queryString("PREFERENCES.CONNECTION_TIMEOUT_ERR2");
    private static final String C_TIMEOUT_LB = loader.queryString("PREFERENCES.CONNECTION_TIMEOUT_LB");
    private static final String C_DB_SETTINGS = loader.queryString("PREFERENCES.CONNECTION_DB_SETTINGS");
    private static final String C_DB_RECONNECT = loader.queryString("PREFERENCES.CONNECTION_DB_RECONN");
    private static final String C_DB_RECONNECT_T = loader.queryString("PREFERENCES.CONNECTION_DB_RECONN_T");
    private static final String C_PASS_GROUP = loader.queryString("PREFERENCES.CONNECTION_PASS_G");
    private static final String C_PASS_STORE = loader.queryString("PREFERENCES.CONNECTION_PASS_S");
    private static final String C_PASS_NEVER = loader.queryString("PREFERENCES.CONNECTION_PASS_NEVER");
    private static final String C_PASS_APP = loader.queryString("PREFERENCES.CONNECTION_PASS_APP");
    private static final String C_PASS_APP_T = loader.queryString("PREFERENCES.CONNECTION_PASS_S_T");
    private static final String C_PASS_PERS = loader.queryString("PREFERENCES.CONNECTION_PASS_PERS");
    private static final String C_PASS_ENC = loader.queryString("PREFERENCES.CONNECTION_PASS_ENC");
    private static final String C_PASS_ENC_M = loader.queryString("PREFERENCES.CONNECTION_PASS_ENC_M");
    private static final String C_PASS_ENC_S = loader.queryString("PREFERENCES.CONNECTION_PASS_ENC_S");
    private static final String C_RECONN = loader.queryString("PREFERENCES.CONNECTION_RECONNE_S");
    private static final String C_VIRTUAL_CONNECTION = loader.queryString("PREFERENCES.CONNECTION_VIRTUAL_CONNECTIONS");
    private static final String C_VIRTUAL_CONNECTION_T = loader.queryString("PREFERENCES.CONNECTION_VIRTUAL_CONNECTIONS_T");
    private static final String INFOPOP = "org.eclipse.wst.rdb.core.ui.data_preference_page";
    private FormColors formColors;
    private Button reconnect;
    private Button reconnectStartup;
    private Button virtualConnection;
    private Text timeout;
    private Combo encriptionKey;
    private Combo storedPassword;
    private Label encriptionLabel;

    private void createSeparator(Composite parent, boolean visible) {
        Label label = new Label(parent, 258);
        label.setVisible(visible);
        GridData separatorData = new GridData(768);
        separatorData.horizontalSpan = 2;
        label.setLayoutData((Object)separatorData);
    }

    protected Control createContents(Composite parent) {
        this.formColors = new FormColors(Display.getCurrent());
        this.formColors.initializeSectionToolBarColors();
        Composite preferenceParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData data = new GridData(1808);
        preferenceParent.setLayout((Layout)layout);
        preferenceParent.setLayoutData((Object)data);
        CLabel descriptionLabel = new CLabel(preferenceParent, 0x800000);
        descriptionLabel.addPaintListener((PaintListener)new LabelPainter(C_DB_SETTINGS));
        GridData descriptionData = new GridData(768);
        descriptionData.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)descriptionData);
        this.createSeparator(preferenceParent, false);
        this.virtualConnection = new Button(preferenceParent, 32);
        this.virtualConnection.setText(C_VIRTUAL_CONNECTION);
        this.virtualConnection.setToolTipText(C_VIRTUAL_CONNECTION_T);
        GridData virtualConnectionData = new GridData(768);
        virtualConnectionData.horizontalSpan = 2;
        this.virtualConnection.setLayoutData((Object)virtualConnectionData);
        this.createSeparator(preferenceParent, false);
        this.createSeparator(preferenceParent, true);
        this.createSeparator(preferenceParent, false);
        Label timeoutLabel = new Label(preferenceParent, 0);
        timeoutLabel.setText(C_TIMEOUT_LB);
        this.timeout = new Text(preferenceParent, 0x800800);
        this.timeout.setLayoutData((Object)new GridData(768));
        this.timeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int x = Integer.parseInt(PreferencePage.this.timeout.getText());
                    if (x >= 0) {
                        PreferencePage.this.setErrorMessage(null);
                        PreferencePage.this.setValid(true);
                    } else {
                        PreferencePage.this.setErrorMessage(C_TIMEOUT_ERR1);
                        PreferencePage.this.setValid(false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    PreferencePage.this.setErrorMessage(C_TIMEOUT_ERR2);
                    PreferencePage.this.setValid(false);
                }
            }
        });
        this.reconnect = new Button(preferenceParent, 32);
        this.reconnect.setText(C_DB_RECONNECT);
        this.reconnect.setToolTipText(C_DB_RECONNECT_T);
        GridData reconnectData = new GridData(768);
        reconnectData.horizontalSpan = 2;
        this.reconnect.setLayoutData((Object)reconnectData);
        this.createSeparator(preferenceParent, false);
        this.createSeparator(preferenceParent, true);
        this.createSeparator(preferenceParent, false);
        Group passwordGroup = new Group(preferenceParent, 0);
        passwordGroup.setText(C_PASS_GROUP);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        GridData groupData = new GridData(768);
        groupData.horizontalSpan = 2;
        passwordGroup.setLayoutData((Object)groupData);
        passwordGroup.setLayout((Layout)groupLayout);
        Label scopeLabel = new Label((Composite)passwordGroup, 0);
        scopeLabel.setText(C_PASS_STORE);
        scopeLabel.setToolTipText(C_PASS_APP_T);
        this.storedPassword = new Combo((Composite)passwordGroup, 0x80000C);
        this.storedPassword.add(C_PASS_NEVER);
        this.storedPassword.add(C_PASS_APP);
        this.storedPassword.add(C_PASS_PERS);
        this.storedPassword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencePage.this.enableEncriptionControls();
            }
        });
        this.encriptionLabel = new Label((Composite)passwordGroup, 0);
        this.encriptionLabel.setText(C_PASS_ENC);
        this.encriptionKey = new Combo((Composite)passwordGroup, 0x80000C);
        this.encriptionKey.add(C_PASS_ENC_S);
        this.encriptionKey.add(C_PASS_ENC_M);
        this.reconnectStartup = new Button((Composite)passwordGroup, 32);
        this.reconnectStartup.setText(C_RECONN);
        GridData reconnectsData = new GridData(768);
        reconnectsData.horizontalSpan = 2;
        this.reconnectStartup.setLayoutData((Object)reconnectsData);
        this.applyPreferences();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, INFOPOP);
        return parent;
    }

    private void enableEncriptionControls() {
        this.encriptionLabel.setEnabled(this.storedPassword.getSelectionIndex() == 2);
        this.encriptionKey.setEnabled(this.storedPassword.getSelectionIndex() == 2);
        this.reconnectStartup.setEnabled(this.storedPassword.getSelectionIndex() == 2);
    }

    private void applyPreferences() {
        this.timeout.setText(core.getPluginPreferences().getString("DATABASE_EXPLORER_CONNECTION_CONNECTION_TIMEOUT"));
        this.reconnect.setSelection(core.getPluginPreferences().getBoolean("DATABASE_EXPLORER_CONNECTION_RECONNECT_ON_TIMEOUT"));
        this.storedPassword.select(core.getPluginPreferences().getInt("DATABASE_EXPLORER_CONNECTION_PASSWORD_SCOPE"));
        this.encriptionKey.select(core.getPluginPreferences().getInt("DATABASE_EXPLORER_CONNECTION_ENCRIPTION_STRENGTH"));
        this.reconnectStartup.setSelection(core.getPluginPreferences().getBoolean("DATABASE_EXPLORER_CONNECTION_RECONNECT_AT_STARTUP"));
        this.virtualConnection.setSelection(core.getPluginPreferences().getBoolean("DATABASE_EXPLORER_CONNECTION_VIRTUAL_CONNECTION"));
        this.enableEncriptionControls();
    }

    private void storePreferences() {
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_CONNECTION_TIMEOUT", this.timeout.getText());
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_RECONNECT_ON_TIMEOUT", this.reconnect.getSelection());
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_PASSWORD_SCOPE", this.storedPassword.getSelectionIndex());
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_ENCRIPTION_STRENGTH", this.encriptionKey.getSelectionIndex());
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_RECONNECT_AT_STARTUP", this.reconnectStartup.getSelection());
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_VIRTUAL_CONNECTION", this.virtualConnection.getSelection());
        core.savePluginPreferences();
    }

    protected void performDefaults() {
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_CONNECTION_TIMEOUT", core.getPluginPreferences().getDefaultString("DATABASE_EXPLORER_CONNECTION_CONNECTION_TIMEOUT"));
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_RECONNECT_ON_TIMEOUT", core.getPluginPreferences().getDefaultBoolean("DATABASE_EXPLORER_CONNECTION_RECONNECT_ON_TIMEOUT"));
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_PASSWORD_SCOPE", core.getPluginPreferences().getDefaultInt("DATABASE_EXPLORER_CONNECTION_PASSWORD_SCOPE"));
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_ENCRIPTION_STRENGTH", core.getPluginPreferences().getDefaultInt("DATABASE_EXPLORER_CONNECTION_ENCRIPTION_STRENGTH"));
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_RECONNECT_AT_STARTUP", core.getPluginPreferences().getDefaultBoolean("DATABASE_EXPLORER_CONNECTION_RECONNECT_AT_STARTUP"));
        core.getPluginPreferences().setValue("DATABASE_EXPLORER_CONNECTION_VIRTUAL_CONNECTION", core.getPluginPreferences().getDefaultBoolean("DATABASE_EXPLORER_CONNECTION_VIRTUAL_CONNECTION"));
        this.applyPreferences();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    public void dispose() {
        this.formColors.dispose();
        this.formColors = null;
    }

    public void init(IWorkbench workbench) {
    }

    private class LabelPainter
    implements PaintListener {
        private String text;

        private void fillColor(GC gc, Control control, int marginWidth, int marginHeight, Rectangle bounds) {
            Color bg = PreferencePage.this.formColors.getColor("org.eclipse.ui.forms.TB_BG");
            Color gbg = PreferencePage.this.formColors.getColor("org.eclipse.ui.forms.TB_GBG");
            Color foreground = gc.getForeground();
            gc.setForeground(bg);
            gc.setBackground(gbg);
            gc.fillGradientRectangle(marginWidth, marginHeight, bounds.width - 1, bounds.height - 1, false);
            gc.setForeground(foreground);
        }

        public LabelPainter(String text) {
            this.text = text;
        }

        public void paintControl(PaintEvent e) {
            Control control = (Control)e.widget;
            GC g = e.gc;
            Display display = e.widget.getDisplay();
            Point size = control.getSize();
            int w = size.x;
            this.fillColor(g, control, 0, 1, control.getBounds());
            g.setBackground(display.getSystemColor(18));
            g.fillRectangle(0, 1, w, 1);
            g.fillRectangle(0, size.y - 1, w, size.y - 1);
            Font previousFont = g.getFont();
            FontData data = new FontData(previousFont.getFontData()[0].getName(), previousFont.getFontData()[0].getHeight(), 1);
            Font newFont = new Font((Device)display, data);
            g.setFont(newFont);
            Point textSize = g.textExtent(this.text);
            g.drawImage(loader.queryImageFromRegistry("server_explorer.gif"), 1, 2);
            g.drawText(this.text, 25, (e.height - textSize.y) / 2, true);
            newFont.dispose();
            g.setFont(previousFont);
        }
    }
}

