/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.ant.internal.ui.preferences.AbstractAntEditorPreferencePage;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.ColorEditor;
import org.eclipse.ant.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class AntCodeAssistPreferencePage
extends AbstractAntEditorPreferencePage {
    private final String[][] fContentAssistColorListModel = new String[][]{{AntPreferencesMessages.AntCodeAssistPreferencePage_backgroundForCompletionProposals, "org.eclipse.ant.ui.codeAssistProposalsBackgroundColor"}, {AntPreferencesMessages.AntCodeAssistPreferencePage_foregroundForCompletionProposals, "org.eclipse.ant.ui.codeAssistProposalsForegroundColor"}};
    private List fContentAssistColorList;
    private ColorEditor fContentAssistColorEditor;
    private Control fAutoInsertDelayText;
    private Control fAutoInsertTriggerText;
    private Label fAutoInsertDelayLabel;
    private Label fAutoInsertTriggerLabel;

    protected OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_userDefinedTasks"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.ant.ui.codeAssistProposalsBackgroundColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.ant.ui.codeAssistProposalsForegroundColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_java"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    private Control createContentAssistPage(Composite parent) {
        Font font = parent.getFont();
        Composite contentAssistComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contentAssistComposite.setLayout((Layout)layout);
        contentAssistComposite.setFont(font);
        String text = AntPreferencesMessages.AntCodeAssistPreferencePage_Insert;
        this.addCheckBox(contentAssistComposite, text, "content_assist_autoinsert", 0);
        text = AntPreferencesMessages.AntCodeAssistPreferencePage_0;
        this.addCheckBox(contentAssistComposite, text, "content_assist_userDefinedTasks", 0);
        text = AntPreferencesMessages.AntCodeAssistPreferencePage__Enable_auto_activation_2;
        Button autoactivation = this.addCheckBox(contentAssistComposite, text, "content_assist_autoactivation", 0);
        autoactivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntCodeAssistPreferencePage.this.updateAutoactivationControls();
            }
        });
        text = AntPreferencesMessages.AntCodeAssistPreferencePage_Auto_activation__delay__3;
        String[] errorMessages = new String[]{AntPreferencesMessages.AntCodeAssistPreferencePage_empty_input_auto_activation, AntPreferencesMessages.AntCodeAssistPreferencePage_invalid_input_auto_activation};
        Control[] labelledTextField = this.addLabelledTextField(contentAssistComposite, text, "content_assist_autoactivation_delay", 4, 0, errorMessages);
        this.fAutoInsertDelayLabel = this.getLabelControl(labelledTextField);
        this.fAutoInsertDelayText = this.getTextControl(labelledTextField);
        text = AntPreferencesMessages.AntCodeAssistPreferencePage_Auto_activation_tri_ggers__4;
        labelledTextField = this.addLabelledTextField(contentAssistComposite, text, "content_assist_autoactivation_triggers_java", 4, 0, null);
        this.fAutoInsertTriggerLabel = this.getLabelControl(labelledTextField);
        this.fAutoInsertTriggerText = this.getTextControl(labelledTextField);
        Label label = new Label(contentAssistComposite, 16384);
        label.setText(AntPreferencesMessages.AntCodeAssistPreferencePage_Code_assist_colo_r_options__5);
        label.setFont(font);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(contentAssistComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        editorComposite.setFont(font);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fContentAssistColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(3);
        this.fContentAssistColorList.setLayoutData((Object)gd);
        this.fContentAssistColorList.setFont(font);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        stylesComposite.setFont(font);
        label = new Label(stylesComposite, 16384);
        label.setText(AntPreferencesMessages.AntEditorPreferencePage_6);
        label.setFont(font);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fContentAssistColorEditor = new ColorEditor(stylesComposite);
        Button colorButton = this.fContentAssistColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        colorButton.setLayoutData((Object)gd);
        this.fContentAssistColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AntCodeAssistPreferencePage.this.handleContentAssistColorListSelection();
            }
        });
        colorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntCodeAssistPreferencePage.this.fContentAssistColorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String key = AntCodeAssistPreferencePage.this.fContentAssistColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntCodeAssistPreferencePage.this.getOverlayStore(), (String)key, (RGB)AntCodeAssistPreferencePage.this.fContentAssistColorEditor.getColorValue());
            }
        });
        return contentAssistComposite;
    }

    private void handleContentAssistColorListSelection() {
        int i = this.fContentAssistColorList.getSelectionIndex();
        if (i == -1) {
            return;
        }
        String key = this.fContentAssistColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)key);
        this.fContentAssistColorEditor.setColorValue(rgb);
    }

    private void updateAutoactivationControls() {
        boolean autoactivation = this.getOverlayStore().getBoolean("content_assist_autoactivation");
        this.fAutoInsertDelayText.setEnabled(autoactivation);
        this.fAutoInsertDelayLabel.setEnabled(autoactivation);
        this.fAutoInsertTriggerText.setEnabled(autoactivation);
        this.fAutoInsertTriggerLabel.setEnabled(autoactivation);
    }

    protected Control createContents(Composite parent) {
        this.getOverlayStore().load();
        this.getOverlayStore().start();
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        control.setLayout((Layout)layout);
        this.createContentAssistPage(control);
        this.initialize();
        this.applyDialogFont(control);
        return control;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fContentAssistColorListModel.length) {
            this.fContentAssistColorList.add(this.fContentAssistColorListModel[i][0]);
            ++i;
        }
        this.fContentAssistColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AntCodeAssistPreferencePage.this.fContentAssistColorList != null && !AntCodeAssistPreferencePage.this.fContentAssistColorList.isDisposed()) {
                    AntCodeAssistPreferencePage.this.fContentAssistColorList.select(0);
                    AntCodeAssistPreferencePage.this.handleContentAssistColorListSelection();
                }
            }
        });
    }

    protected void handleDefaults() {
        this.handleContentAssistColorListSelection();
        this.updateAutoactivationControls();
    }
}

