/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DataModelElementFactory;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.wst.rdb.internal.models.sql.constraints.impl.CheckConstraintImpl;
import org.eclipse.wst.rdb.internal.models.sql.expressions.SQLExpressionsPackage;
import org.eclipse.wst.rdb.internal.models.sql.expressions.SearchCondition;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class DerbyCatalogCheckConstraint
extends CheckConstraintImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257282535142011699L;
    private boolean loaded = false;

    public void refresh() {
        this.loaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    public SearchCondition getSearchCondition() {
        if (!this.loaded) {
            this.load();
        }
        return this.searchCondition;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 11) {
            this.getSearchCondition();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT CHECKDEFINITION FROM SYS.SYSCHECKS A,SYS.SYSCONSTRAINTS B WHERE A.CONSTRAINTID=B.CONSTRAINTID AND B.CONSTRAINTNAME='" + this.getName() + "'";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String text = r.getString("CHECKDEFINITION");
                DataModelElementFactory factory = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
                SearchCondition searchCondition = (SearchCondition)factory.create(SQLExpressionsPackage.eINSTANCE.getSearchConditionDefault());
                searchCondition.setSQL(text);
                this.setSearchCondition(searchCondition);
            }
            this.loaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }
}

