/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.ddl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.rdb.internal.core.rte.DDLGeneratorWithCallback;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionID;
import org.eclipse.wst.rdb.internal.core.rte.IEngineeringCallBack;
import org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGenerationOptions;
import org.eclipse.wst.rdb.internal.derby.ddl.DerbyDdlBuilder;
import org.eclipse.wst.rdb.internal.derby.ddl.DerbyDdlScript;
import org.eclipse.wst.rdb.internal.models.sql.constraints.CheckConstraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.constraints.TableConstraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.UserDefinedType;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.UserDefinedFunction;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;
import org.eclipse.wst.rdb.internal.models.sql.tables.ViewTable;

public final class DerbyDdlGenerator
implements DDLGeneratorWithCallback,
IExecutableExtension {
    private String product;
    private String version;
    private EngineeringOption[] options = null;
    private EngineeringOptionCategory[] categories = null;
    private DerbyDdlBuilder builder = null;
    private OptionDependency optionDependency = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.product = config.getAttribute("product");
        this.version = config.getAttribute("version");
        this.builder = new DerbyDdlBuilder();
    }

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        return this.generateDDL(elements, progressMonitor, null);
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.createSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor, null);
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.dropSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor, null);
    }

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        String[] statements = new String[]{};
        EngineeringOption[] options = this.getSelectedOptions(elements);
        if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])options)) {
            statements = this.createSQLObjects(elements, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])options), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])options), progressMonitor);
        }
        if (EngineeringOptionID.generateDropStatement((EngineeringOption[])options)) {
            String[] drop = this.dropSQLObjects(elements, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])options), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])options), progressMonitor);
            String[] temp = statements;
            statements = new String[temp.length + drop.length];
            int i = 0;
            while (i < drop.length) {
                statements[i] = drop[i];
                ++i;
            }
            i = 0;
            while (i < temp.length) {
                statements[i + drop.length] = temp[i];
                ++i;
            }
        }
        return statements;
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        return this.createStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        return this.dropStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
    }

    private String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        DerbyDdlScript script = new DerbyDdlScript();
        if (this.builder == null) {
            this.builder = new DerbyDdlBuilder();
        }
        Set set = null;
        if (this.optionDependency != null) {
            set = this.optionDependency.getElementsToUse();
        }
        Iterator it = null;
        it = set != null && set.size() > 0 ? this.optionDependency.getElementsToUse().iterator() : GenericDdlGenerationOptions.getAllContainedDisplayableElementSet((SQLObject[])elements).iterator();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof BaseTable) {
                if (!EngineeringOptionID.generateTables((EngineeringOption[])options) || (statement = this.builder.createTable((BaseTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!EngineeringOptionID.generateViews((EngineeringOption[])options) || (statement = this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!EngineeringOptionID.generateStoredProcedures((EngineeringOption[])options) || (statement = this.builder.createProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!EngineeringOptionID.generateFunctions((EngineeringOption[])options) || (statement = this.builder.createUserDefinedFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRoutineStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!EngineeringOptionID.generateTriggers((EngineeringOption[])options) || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!EngineeringOptionID.generateCKConstraints((EngineeringOption[])options) || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!EngineeringOptionID.generatePKConstraints((EngineeringOption[])options) || this.builder.isImplicitConstraint((TableConstraint)((UniqueConstraint)o)) || (statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!EngineeringOptionID.generateFKConstraints((EngineeringOption[])options) || this.builder.isImplicitConstraint((TableConstraint)((ForeignKey)o)) || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !EngineeringOptionID.generateIndexes((EngineeringOption[])options) || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCreateIndexStatement(statement);
        }
        return script.getStatements();
    }

    private String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        DerbyDdlScript script = new DerbyDdlScript();
        if (this.builder == null) {
            this.builder = new DerbyDdlBuilder();
        }
        Iterator it = GenericDdlGenerationOptions.getAllContainedDisplayableElementSet((SQLObject[])elements).iterator();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof BaseTable) {
                if (!EngineeringOptionID.generateTables((EngineeringOption[])options) || (statement = this.builder.dropTable((BaseTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!EngineeringOptionID.generateViews((EngineeringOption[])options) || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!EngineeringOptionID.generateStoredProcedures((EngineeringOption[])options) || (statement = this.builder.dropProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!EngineeringOptionID.generateFunctions((EngineeringOption[])options) || (statement = this.builder.dropFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRoutineStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!EngineeringOptionID.generateTriggers((EngineeringOption[])options) || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!EngineeringOptionID.generateCKConstraints((EngineeringOption[])options) || (statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!EngineeringOptionID.generatePKConstraints((EngineeringOption[])options) || this.builder.isImplicitConstraint((TableConstraint)((UniqueConstraint)o)) || (statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!EngineeringOptionID.generateFKConstraints((EngineeringOption[])options) || this.builder.isImplicitConstraint((TableConstraint)((ForeignKey)o)) || (statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !EngineeringOptionID.generateIndexes((EngineeringOption[])options) || (statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropIndexStatement(statement);
        }
        return script.getStatements();
    }

    public EngineeringOption[] getOptions() {
        if (this.options == null) {
            ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration");
            Vector<EngineeringOption> optionVec = new Vector<EngineeringOption>();
            EngineeringOption[] temp = GenericDdlGenerationOptions.createDDLGenerationOptions((EngineeringOptionCategory[])this.getOptionCategories());
            int i = 0;
            while (i < temp.length) {
                optionVec.add(temp[i]);
                ++i;
            }
            EngineeringOptionCategory additional_element = null;
            int i2 = 0;
            while (i2 < this.categories.length) {
                if (this.categories[i2].getId().equals("GENERATE_ELEMENTS")) {
                    additional_element = this.categories[i2];
                }
                ++i2;
            }
            optionVec.add(new EngineeringOption("GENERATE_STOREDPROCEDURES", resource.getString("GENERATE_STOREDPROCEDURE"), resource.getString("GENERATE_STOREDPROCEDURE_DES"), true, additional_element));
            optionVec.add(new EngineeringOption("GENERATE_FUNCTIONS", resource.getString("GENERATE_FUNCTION"), resource.getString("GENERATE_FUNCTION_DES"), true, additional_element));
            this.options = new EngineeringOption[optionVec.size()];
            optionVec.copyInto(this.options);
        }
        return this.options;
    }

    public EngineeringOption[] getOptions(SQLObject[] elements) {
        return this.getOptions(elements, false);
    }

    public EngineeringOption[] getOptions(SQLObject[] elements, boolean autoDiscovery) {
        EngineeringOptionCategory[] categories_new = this.getOptionCategories();
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        int i = 0;
        while (i < categories_new.length) {
            if (categories_new[i].getId().equals("GENERATE_OPTIONS")) {
                general_options = categories_new[i];
            } else if (categories_new[i].getId().equals("GENERATE_ELEMENTS")) {
                additional_element = categories_new[i];
            }
            ++i;
        }
        int idx = 0;
        int size = 0;
        this.optionDependency = new OptionDependency(elements, autoDiscovery);
        Set sOptions = this.optionDependency.getOptions();
        this.options = new EngineeringOption[sOptions.size()];
        int i2 = 0;
        Iterator it = sOptions.iterator();
        while (it.hasNext()) {
            this.options[i2] = GenericDdlGenerationOptions.getEngineeringOption((String)((String)it.next()), (EngineeringOptionCategory)general_options, (EngineeringOptionCategory)additional_element);
            if (this.options[i2] != null && this.options[i2].getCategory().getId().equals("GENERATE_ELEMENTS")) {
                idx = i2;
                ++size;
            }
            ++i2;
        }
        if (size == 1) {
            EngineeringOption option = this.options[idx];
            option.setBoolean(true);
        }
        return this.options;
    }

    private static Set getAllContainedDisplayableElementSetDepedency(SQLObject[] elements) {
        SingletonOptionDependency sod = SingletonOptionDependency.getSingletonObject();
        TreeSet s = new TreeSet();
        int i = 0;
        while (i < elements.length) {
            Class<?> key = null;
            if (elements[i] instanceof Database) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.schema.Database");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof Schema) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.schema.Schema");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof BaseTable) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.tables.Table");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof Index) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.constraints.Index");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof Procedure) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.routines.Procedure");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof UserDefinedFunction) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.routines.UserDefinedFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof ViewTable) {
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.tables.ViewTable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof Trigger) {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.tables.Trigger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof UserDefinedType) {
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.datatypes.UserDefinedType");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof UniqueConstraint) {
                Class<?> clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof CheckConstraint) {
                Class<?> clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.constraints.CheckConstraint");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            } else if (elements[i] instanceof ForeignKey) {
                Class<?> clazz = class$11;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                key = clazz;
            }
            try {
                int mask = sod.getMask(key);
                EngineeringOptionID.populateOptions(s, (int)mask);
            }
            catch (Exception exception) {}
            ++i;
        }
        return s;
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            this.categories = GenericDdlGenerationOptions.createDDLGenerationOptionCategories();
        }
        return this.categories;
    }

    public EngineeringOption[] getSelectedOptions() {
        if (this.options == null) {
            this.getOptions();
        }
        return this.options;
    }

    public EngineeringOption[] getSelectedOptions(SQLObject[] elements) {
        if (this.options == null) {
            if (this.optionDependency == null) {
                this.getOptions(elements);
            } else {
                this.getOptions();
            }
        }
        return this.options;
    }

    public class OptionDependency {
        private SQLObject[] elements = null;
        private Set sOptions = new LinkedHashSet();
        private Set sElementsToUse = null;

        public OptionDependency(SQLObject[] elements, boolean autoDiscovery) {
            this.elements = elements;
            this.sElementsToUse = new LinkedHashSet();
            this.doDiscovery(autoDiscovery);
        }

        private void doDiscovery(boolean autoDiscovery) {
            this.setOption("GENERATE_FULLY_QUALIFIED_NAME");
            this.setOption("GENERATE_QUOTED_IDENTIFIER");
            this.setOption("GENERATE_DROP_STATEMENTS");
            this.setOption("GENERATE_CREATE_STATEMENTS");
            TreeSet<String> additionalOptions = new TreeSet<String>();
            if (autoDiscovery) {
                Iterator it = GenericDdlGenerationOptions.getAllContainedDisplayableElementSet((SQLObject[])this.elements).iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    this.sElementsToUse.add(o);
                    if (o instanceof BaseTable) {
                        additionalOptions.add("GENERATE_TABLES");
                        continue;
                    }
                    if (o instanceof Index) {
                        additionalOptions.add("GENERATE_INDICES");
                        continue;
                    }
                    if (o instanceof Procedure) {
                        additionalOptions.add("GENERATE_STOREDPROCEDURES");
                        continue;
                    }
                    if (o instanceof UserDefinedFunction) {
                        additionalOptions.add("GENERATE_FUNCTIONS");
                        continue;
                    }
                    if (o instanceof ViewTable) {
                        additionalOptions.add("GENERATE_VIEWS");
                        continue;
                    }
                    if (o instanceof Trigger) {
                        additionalOptions.add("GENERATE_TRIGGERS");
                        continue;
                    }
                    if (o instanceof UniqueConstraint) {
                        additionalOptions.add("GENERATE_PK_CONSTRAINTS");
                        continue;
                    }
                    if (o instanceof CheckConstraint) {
                        additionalOptions.add("GENERATE_CK_CONSTRAINTS");
                        continue;
                    }
                    if (o instanceof ForeignKey) {
                        additionalOptions.add("GENERATE_FK_CONSTRAINTS");
                        continue;
                    }
                    boolean cfr_ignored_0 = o instanceof Column;
                }
                it = additionalOptions.iterator();
                while (it.hasNext()) {
                    this.setOption((String)it.next());
                }
            } else {
                this.sOptions.addAll(DerbyDdlGenerator.getAllContainedDisplayableElementSetDepedency(this.elements));
            }
        }

        public Set getOptions() {
            return this.sOptions;
        }

        public void setOption(String option) {
            this.sOptions.add(option);
        }

        public Set getElementsToUse() {
            return this.sElementsToUse;
        }
    }

    public static class SingletonOptionDependency {
        private Map data = new HashMap();
        private static SingletonOptionDependency ref;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;
        static /* synthetic */ Class class$6;
        static /* synthetic */ Class class$7;
        static /* synthetic */ Class class$8;
        static /* synthetic */ Class class$9;
        static /* synthetic */ Class class$10;
        static /* synthetic */ Class class$11;
        static /* synthetic */ Class class$12;

        private SingletonOptionDependency() {
        }

        public static SingletonOptionDependency getSingletonObject() {
            if (ref == null) {
                ref = new SingletonOptionDependency();
                int mask = 827138;
                Map map = SingletonOptionDependency.ref.data;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.schema.Database");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map.put(clazz, new Integer(mask));
                mask = 827138;
                Map map2 = SingletonOptionDependency.ref.data;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.schema.Schema");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map2.put(clazz2, new Integer(mask));
                mask = 823554;
                Map map3 = SingletonOptionDependency.ref.data;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.tables.Table");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map3.put(clazz3, new Integer(mask));
                mask = 256;
                Map map4 = SingletonOptionDependency.ref.data;
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.constraints.Index");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map4.put(clazz4, new Integer(mask));
                mask = 512;
                Map map5 = SingletonOptionDependency.ref.data;
                Class<?> clazz5 = class$4;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$4 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.routines.Procedure");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map5.put(clazz5, new Integer(mask));
                mask = 1024;
                Map map6 = SingletonOptionDependency.ref.data;
                Class<?> clazz6 = class$5;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$5 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.routines.UserDefinedFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map6.put(clazz6, new Integer(mask));
                mask = 6144;
                Map map7 = SingletonOptionDependency.ref.data;
                Class<?> clazz7 = class$6;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$6 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.tables.ViewTable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map7.put(clazz7, new Integer(mask));
                mask = 4096;
                Map map8 = SingletonOptionDependency.ref.data;
                Class<?> clazz8 = class$7;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$7 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.tables.Trigger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map8.put(clazz8, new Integer(mask));
                mask = 8192;
                Map map9 = SingletonOptionDependency.ref.data;
                Class<?> clazz9 = class$8;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$8 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.schema.Sequence");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map9.put(clazz9, new Integer(mask));
                mask = 16384;
                Map map10 = SingletonOptionDependency.ref.data;
                Class<?> clazz10 = class$9;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$9 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.datatypes.UserDefinedType");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map10.put(clazz10, new Integer(mask));
                mask = 32768;
                Map map11 = SingletonOptionDependency.ref.data;
                Class<?> clazz11 = class$10;
                if (clazz11 == null) {
                    try {
                        clazz11 = class$10 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map11.put(clazz11, new Integer(mask));
                mask = 524288;
                Map map12 = SingletonOptionDependency.ref.data;
                Class<?> clazz12 = class$11;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$11 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map12.put(clazz12, new Integer(mask));
                mask = 262144;
                Map map13 = SingletonOptionDependency.ref.data;
                Class<?> clazz13 = class$12;
                if (clazz13 == null) {
                    try {
                        clazz13 = class$12 = Class.forName("org.eclipse.wst.rdb.internal.models.sql.constraints.CheckConstraint");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map13.put(clazz13, new Integer(mask));
            }
            return ref;
        }

        public Integer getMask(Class key) {
            return (Integer)this.data.get(key);
        }
    }
}

