/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.REMPrimitiveBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMShortTypeBeanProxy;

final class REMShortTypeBeanTypeProxy
extends REMPrimitiveBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;
    private final INumberBeanProxy oneProxy;
    private final INumberBeanProxy twoProxy;
    private final INumberBeanProxy threeProxy;

    REMShortTypeBeanTypeProxy(REMProxyFactoryRegistry aRegistry) {
        super(aRegistry, new Integer(13), Short.TYPE.getName());
        this.zeroProxy = new REMShortTypeBeanProxy(aRegistry, 0);
        this.oneProxy = new REMShortTypeBeanProxy(aRegistry, 1);
        this.twoProxy = new REMShortTypeBeanProxy(aRegistry, 2);
        this.threeProxy = new REMShortTypeBeanProxy(aRegistry, 3);
    }

    INumberBeanProxy createShortBeanProxy(short aShort) {
        switch (aShort) {
            case 0: {
                return this.zeroProxy;
            }
            case 1: {
                return this.oneProxy;
            }
            case 2: {
                return this.twoProxy;
            }
            case 3: {
                return this.threeProxy;
            }
        }
        return new REMShortTypeBeanProxy(this.fRegistry, aShort);
    }

    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createShortBeanProxy(value.aShort);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBeanProxy newInstance(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        short aShort;
        String trim = initializationString.trim();
        if (trim.length() == 0) {
            return super.newInstance(initializationString);
        }
        if (trim.startsWith("(short)")) {
            Number v = REMShortTypeBeanTypeProxy.parseString(trim.substring("(short)".length()).trim());
            if (v == null) return super.newInstance(initializationString);
            aShort = v.shortValue();
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aShort);
        }
        try {
            aShort = Short.decode(trim);
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aShort);
        }
        catch (NumberFormatException numberFormatException) {
            return super.newInstance(initializationString);
        }
    }
}

